/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.wfs.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Rectangle2D;
import java.util.Stack;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.cresques.cts.IProjection;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.gui.AbstractViewPanel;
import org.gvsig.app.project.documents.view.gui.IView;
import org.gvsig.app.project.documents.view.toolListeners.AreaListener;
import org.gvsig.app.project.documents.view.toolListeners.MeasureListener;
import org.gvsig.app.project.documents.view.toolListeners.PanListener;
import org.gvsig.app.project.documents.view.toolListeners.StatusBarListener;
import org.gvsig.app.project.documents.view.toolListeners.ZoomInListener;
import org.gvsig.app.project.documents.view.toolListeners.ZoomOutListener;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.events.ColorEvent;
import org.gvsig.fmap.mapcontext.events.ExtentEvent;
import org.gvsig.fmap.mapcontext.events.ProjectionEvent;
import org.gvsig.fmap.mapcontext.events.listeners.ViewPortListener;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseMovementBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MoveBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolygonBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PolylineBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.RectangleBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PolylineListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.RectangleListener;
import org.gvsig.fmap.mapcontrol.tools.ZoomOutRightButtonListener;
import org.gvsig.gui.beans.panelGroup.AbstractPanelGroup;
import org.gvsig.gui.beans.specificcaretposition.JTextFieldWithSCP;
import org.gvsig.gui.beans.swing.jComboBoxWithImageIconItems.ImageIconItemInfo;
import org.gvsig.gui.beans.swing.jComboBoxWithImageIconItems.JComboBoxWithImageIconItems;
import org.gvsig.utils.stringNumberUtilities.StringNumberUtilities;
import org.gvsig.wfs.gui.panels.AbstractWFSPanel;
import org.gvsig.wfs.gui.panels.WFSParamsPanel;
import org.gvsig.wfs.gui.panels.model.WFSSelectedFeature;

public class WFSAreaPanel
extends AbstractWFSPanel {
    private final Rectangle DEFAULT_AREA_COORDINATES_PANEL_RECTANGLE = new Rectangle(8, 20, 481, 60);
    private final Rectangle DEFAULT_AREA_MAPCONTROL_PANEL_RECTANGLE = new Rectangle(8, 115, 481, 265);
    private final Rectangle DEFAULT_UNDO_ICON_BUTTON_RECTANGLE = new Rectangle(250, 85, 25, 25);
    private final Rectangle DEFAULT_PAN_ICON_BUTTON_RECTANGLE = new Rectangle(250, 85, 25, 25);
    private final Rectangle DEFAULT_TOOL_JCOMBOBOX_RECTANGLE = new Rectangle(10, 87, 230, 21);
    private final Rectangle DEFAULT_ENABLING_CHECKBOX_RECTANGLE = new Rectangle(10, 87, 150, 21);
    private final Rectangle DEFAULT_ZOOMINANDOUT_JCOMBOBOX_RECTANGLE = new Rectangle(277, 85, 47, 25);
    private final Rectangle DEFAULT_ZOOMPREVIOUS_ICON_BUTTON_RECTANGLE = new Rectangle(326, 85, 25, 25);
    private final Rectangle DEFAULT_ZOOMCOMPLETE_ICON_BUTTON_RECTANGLE = new Rectangle(353, 85, 25, 25);
    private final Rectangle DEFAULT_ZOOMINANDOUTVIEWCENTERED_JCOMBOBOX_RECTANGLE = new Rectangle(380, 85, 47, 25);
    private final Rectangle DEFAULT_OTHER_TOOLS_JCOMBOBOX_RECTANGLE = new Rectangle(429, 85, 47, 25);
    private final int DISABLED_OPERATION = 0;
    private final int SELECTION_BY_COORDINATES_OPERATION = 1;
    private final int SELECTION_BY_AREA_OPERATION = 2;
    private Stack<Rectangle2D> previousExtentValids = null;
    private AreaCoordinatesPanel coordinatesPanel = null;
    private SelectableMapControlAreaPanel selectableMapAreaPanel = null;
    private JComboBox jComboBoxToolSelection = null;
    private JButton jButtonUndo = null;
    private JButton jButtonPan = null;
    private JButton jButtonZoomPrevious = null;
    private JButton jButtonZoomComplete = null;
    private JComboBoxWithImageIconItems jComboBoxZoomInAndOut = null;
    private JComboBoxWithImageIconItems jComboBoxZoomInAndOutViewCentered = null;
    private JComboBoxWithImageIconItems jComboBoxOtherTools = null;
    private JCheckBox jEnablingCheckBox = null;
    private final String PAN_TOOL = "HAND";
    private final String ZOOM_IN_TOOL = "zoomIn";
    private final String ZOOM_OUT_TOOL = "zoomOut";
    private final String ZOOM_IN_VIEW_CENTERED_TOOL = "ZOOM_IN_VIEW_CENTERED";
    private final String ZOOM_OUT_VIEW_CENTERED_TOOL = "ZOOM_OUT_VIEW_CENTERED";
    private final String MEASURE_DISTANCES_TOOL = "MEASURE_DISTANCES";
    private final String MEASURE_AREA_TOOL = "MEASURE_AREA";
    private JPanel northPanel = null;
    private IProjection srs = null;

    public WFSAreaPanel() {
        this.initialize();
    }

    private void initCoordinates() {
        IWindow wi = PluginServices.getMDIManager().getActiveWindow();
        if (!(wi instanceof IView)) {
            return;
        }
        ViewPort viewPort = ((IView)wi).getMapControl().getViewPort();
        Envelope envelope = viewPort.getAdjustedEnvelope();
        if (envelope != null) {
            this.previousExtentValids.push(new Rectangle2D.Double(envelope.getMinimum(0), envelope.getMinimum(1), envelope.getMaximum(0) - envelope.getMaximum(0), envelope.getMaximum(1) - envelope.getMinimum(1)));
            this.setCoordinates(envelope.getMaximum(0), envelope.getMaximum(1), envelope.getMinimum(0), envelope.getMinimum(1));
        }
        this.setSrs(viewPort.getProjection());
    }

    public void clearCoordinates() {
        this.previousExtentValids.clear();
    }

    private void setCoordinates(double v1x, double v1y, double v2x, double v2y) {
        this.getCoordinatesPanel().getJTextFieldVertex1X().setText(Double.toString(v1x));
        this.getCoordinatesPanel().getJTextFieldVertex1Y().setText(Double.toString(v1y));
        this.getCoordinatesPanel().getJTextFieldVertex2X().setText(Double.toString(v2x));
        this.getCoordinatesPanel().getJTextFieldVertex2Y().setText(Double.toString(v2y));
    }

    private void setCoordinates(Rectangle2D bbox) {
        this.getCoordinatesPanel().getJTextFieldVertex1X().setText(Double.toString(bbox.getMaxX()));
        this.getCoordinatesPanel().getJTextFieldVertex1Y().setText(Double.toString(bbox.getMaxY()));
        this.getCoordinatesPanel().getJTextFieldVertex2X().setText(Double.toString(bbox.getMinX()));
        this.getCoordinatesPanel().getJTextFieldVertex2Y().setText(Double.toString(bbox.getMinY()));
    }

    private AreaCoordinatesPanel getCoordinatesPanel() {
        if (this.coordinatesPanel == null) {
            this.coordinatesPanel = new AreaCoordinatesPanel();
        }
        return this.coordinatesPanel;
    }

    private JCheckBox getEnablingJCheckBox() {
        if (this.jEnablingCheckBox == null) {
            this.jEnablingCheckBox = new JCheckBox(PluginServices.getText((Object)this, (String)"enabled"));
            this.jEnablingCheckBox.setBounds(this.DEFAULT_ENABLING_CHECKBOX_RECTANGLE);
            this.jEnablingCheckBox.setToolTipText(PluginServices.getText((Object)this, (String)"enable_filter_by_area"));
            this.jEnablingCheckBox.setSelected(false);
            this.jEnablingCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        WFSAreaPanel.this.jEnablingCheckBox.setToolTipText(PluginServices.getText((Object)this, (String)"disable_filter_by_area"));
                        WFSAreaPanel.this.enableCoorderatesRegionOperation();
                    } else {
                        WFSAreaPanel.this.jEnablingCheckBox.setToolTipText(PluginServices.getText((Object)this, (String)"enable_filter_by_area"));
                        WFSAreaPanel.this.disableCoorderatesRegionOperation();
                    }
                    AbstractPanelGroup panelGroup = WFSAreaPanel.this.getPanelGroup();
                    if (panelGroup == null) {
                        return;
                    }
                    ((WFSParamsPanel)panelGroup).setApplicable(true);
                }
            });
            this.disableCoorderatesRegionOperation();
        }
        return this.jEnablingCheckBox;
    }

    private JComboBox getJComboBoxToolSelection() {
        if (this.jComboBoxToolSelection == null) {
            this.jComboBoxToolSelection = new JComboBox();
            this.jComboBoxToolSelection.setBounds(this.DEFAULT_TOOL_JCOMBOBOX_RECTANGLE);
            this.jComboBoxToolSelection.setToolTipText(PluginServices.getText((Object)this, (String)"select_a_tool"));
            this.jComboBoxToolSelection.setEditable(false);
            this.jComboBoxToolSelection.addItem(new ItemOperation(PluginServices.getText((Object)this, (String)"disabled"), this.DISABLED_OPERATION));
            this.jComboBoxToolSelection.addItem(new ItemOperation(PluginServices.getText((Object)this, (String)"define_absolute_coordinates"), this.SELECTION_BY_COORDINATES_OPERATION));
            this.jComboBoxToolSelection.addItem(new ItemOperation(PluginServices.getText((Object)this, (String)"define_coordinates_using_view"), this.SELECTION_BY_AREA_OPERATION));
            this.jComboBoxToolSelection.addActionListener(e -> {
                JComboBox cb = (JComboBox)e.getSource();
                switch (((ItemOperation)cb.getSelectedItem()).getOperation()) {
                    case 0: {
                        this.disableCoorderatesRegionOperation();
                        this.disableAreaRegionOperation();
                        break;
                    }
                    case 1: {
                        this.disableAreaRegionOperation();
                        this.enableCoorderatesRegionOperation();
                        break;
                    }
                    case 2: {
                        if (this.getSelectableMapAreaPanel().getMapContext().getLayers().getLayersCount() > 0) {
                            this.disableCoorderatesRegionOperation();
                            this.enableAreaRegionOperation();
                            break;
                        }
                        JOptionPane.showMessageDialog(this.jComboBoxToolSelection, PluginServices.getText(null, (String)"there_is_no_layer_loaded_in_the_active_view"), PluginServices.getText(null, (String)"information"), 1);
                        this.jComboBoxToolSelection.setSelectedIndex(0);
                        this.disableCoorderatesRegionOperation();
                    }
                }
            });
        }
        return this.jComboBoxToolSelection;
    }

    private void enableCoorderatesRegionOperation() {
        this.getCoordinatesPanel().setAllTextFieldsEnabled(true);
        if (!this.getEnablingJCheckBox().isSelected()) {
            MDIManager mdiManager = ApplicationLocator.getManager().getUIManager();
            IWindow[] windows = mdiManager.getOrderedWindows();
            IView view = null;
            for (IWindow window : windows) {
                if (!(window instanceof IView)) continue;
                view = (IView)window;
            }
            if (view == null) {
                return;
            }
            ViewPort viewPort = view.getMapControl().getMapContext().getViewPort();
            Envelope envelope = viewPort.getAdjustedEnvelope();
            if (envelope != null) {
                this.getCoordinatesPanel().updateCoordinates(envelope);
            }
        }
        this.getCoordinatesPanel().getJButtonValidateArea().setEnabled(true);
        this.repaint();
    }

    private void enableAreaRegionOperation() {
        this.add(this.getJButtonPan(), null);
        this.add((Component)this.getJComboBoxZoomInAndOut(), null);
        this.getJComboBoxZoomInAndOut().revalidate();
        this.add(this.getJButtonZoomPrevious(), null);
        this.add(this.getJButtonZoomComplete(), null);
        this.add((Component)this.getJComboBoxZoomInAndOutViewCentered(), null);
        this.getJComboBoxZoomInAndOutViewCentered().revalidate();
        this.add((Component)this.getJComboBoxOtherTools(), null);
        this.getJComboBoxOtherTools().revalidate();
        this.getSelectableMapAreaPanel().setEnabled(true);
    }

    private void disableCoorderatesRegionOperation() {
        this.getCoordinatesPanel().setAllTextFieldsEnabled(false);
        this.getCoordinatesPanel().getJButtonValidateArea().setEnabled(false);
        this.repaint();
    }

    private void disableAreaRegionOperation() {
        this.remove(this.getJButtonPan());
        this.remove((Component)this.getJComboBoxZoomInAndOut());
        this.remove(this.getJButtonZoomPrevious());
        this.remove(this.getJButtonZoomComplete());
        this.remove((Component)this.getJComboBoxZoomInAndOutViewCentered());
        this.remove((Component)this.getJComboBoxOtherTools());
        this.getSelectableMapAreaPanel().setEnabled(false);
    }

    private SelectableMapControlAreaPanel getSelectableMapAreaPanel() {
        if (this.selectableMapAreaPanel == null) {
            this.selectableMapAreaPanel = new SelectableMapControlAreaPanel();
        }
        return this.selectableMapAreaPanel;
    }

    private JButton getJButtonUndo() {
        if (this.jButtonUndo == null) {
            this.jButtonUndo = new JButton();
            this.jButtonUndo.setBounds(this.DEFAULT_UNDO_ICON_BUTTON_RECTANGLE);
            this.jButtonUndo.setIcon(PluginServices.getIconTheme().get("wfs-properties-undo"));
            this.jButtonUndo.setToolTipText(PluginServices.getText((Object)this, (String)"previous_area"));
            this.jButtonUndo.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WFSAreaPanel.this.goToPreviousZoom();
                }
            });
        }
        return this.jButtonUndo;
    }

    private JButton getJButtonPan() {
        if (this.jButtonPan == null) {
            this.jButtonPan = new JButton();
            this.jButtonPan.setBounds(this.DEFAULT_PAN_ICON_BUTTON_RECTANGLE);
            this.jButtonPan.setIcon(PluginServices.getIconTheme().get("wfs-properties-pan"));
            this.jButtonPan.setToolTipText(PluginServices.getText((Object)this, (String)"Desplazamiento"));
            this.jButtonPan.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WFSAreaPanel.this.getSelectableMapAreaPanel().setTool("HAND");
                }
            });
        }
        return this.jButtonPan;
    }

    private JComboBoxWithImageIconItems getJComboBoxZoomInAndOut() {
        if (this.jComboBoxZoomInAndOut == null) {
            this.jComboBoxZoomInAndOut = new JComboBoxWithImageIconItems();
            this.jComboBoxZoomInAndOut.setBounds(this.DEFAULT_ZOOMINANDOUT_JCOMBOBOX_RECTANGLE);
            this.jComboBoxZoomInAndOut.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-zoom-in"), PluginServices.getText((Object)this, (String)"Zoom_Mas"), (Object)"zoomIn"));
            this.jComboBoxZoomInAndOut.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-zoom-out"), PluginServices.getText((Object)this, (String)"Zoom_Menos"), (Object)"zoomOut"));
            this.jComboBoxZoomInAndOut.addActionListener(e -> {
                JComboBoxWithImageIconItems cb = (JComboBoxWithImageIconItems)e.getSource();
                ImageIconItemInfo iiii = (ImageIconItemInfo)cb.getSelectedItem();
                this.getSelectableMapAreaPanel().setTool((String)iiii.getItemValue());
            });
        }
        return this.jComboBoxZoomInAndOut;
    }

    private JButton getJButtonZoomPrevious() {
        if (this.jButtonZoomPrevious == null) {
            this.jButtonZoomPrevious = new JButton();
            this.jButtonZoomPrevious.setBounds(this.DEFAULT_ZOOMPREVIOUS_ICON_BUTTON_RECTANGLE);
            this.jButtonZoomPrevious.setIcon(PluginServices.getIconTheme().get("wfs-properties-zoom-back"));
            this.jButtonZoomPrevious.setToolTipText(PluginServices.getText((Object)this, (String)"Zoom_Previo"));
            this.jButtonZoomPrevious.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WFSAreaPanel.this.goToPreviousZoom();
                }
            });
        }
        return this.jButtonZoomPrevious;
    }

    private JButton getJButtonZoomComplete() {
        if (this.jButtonZoomComplete == null) {
            this.jButtonZoomComplete = new JButton();
            this.jButtonZoomComplete.setBounds(this.DEFAULT_ZOOMCOMPLETE_ICON_BUTTON_RECTANGLE);
            this.jButtonZoomComplete.setIcon(PluginServices.getIconTheme().get("wfs-properties-zoom-all"));
            this.jButtonZoomComplete.setToolTipText(PluginServices.getText((Object)this, (String)"Zoom_Completo"));
            this.jButtonZoomComplete.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    WFSAreaPanel.this.getSelectableMapAreaPanel().getViewPort().setEnvelope(WFSAreaPanel.this.getSelectableMapAreaPanel().getMapContext().getLayers().getFullEnvelope());
                    AbstractViewPanel view = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
                    view.repaintMap();
                }
            });
        }
        return this.jButtonZoomComplete;
    }

    private JComboBoxWithImageIconItems getJComboBoxZoomInAndOutViewCentered() {
        if (this.jComboBoxZoomInAndOutViewCentered == null) {
            this.jComboBoxZoomInAndOutViewCentered = new JComboBoxWithImageIconItems();
            this.jComboBoxZoomInAndOutViewCentered.setBounds(this.DEFAULT_ZOOMINANDOUTVIEWCENTERED_JCOMBOBOX_RECTANGLE);
            this.jComboBoxZoomInAndOutViewCentered.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-zoom-plus"), PluginServices.getText((Object)this, (String)"Zoom_Acercar"), (Object)"ZOOM_IN_VIEW_CENTERED"));
            this.jComboBoxZoomInAndOutViewCentered.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-zoom-minus"), PluginServices.getText((Object)this, (String)"Zoom_Alejar"), (Object)"ZOOM_OUT_VIEW_CENTERED"));
            this.jComboBoxZoomInAndOutViewCentered.addActionListener(e -> {
                JComboBoxWithImageIconItems cb = (JComboBoxWithImageIconItems)e.getSource();
                ImageIconItemInfo iiii = (ImageIconItemInfo)cb.getSelectedItem();
                if (((String)iiii.getItemValue()).compareTo("ZOOM_IN_VIEW_CENTERED") == 0) {
                    this.getSelectableMapAreaPanel().zoomIn();
                } else {
                    this.getSelectableMapAreaPanel().zoomOut();
                }
            });
        }
        return this.jComboBoxZoomInAndOutViewCentered;
    }

    private JComboBoxWithImageIconItems getJComboBoxOtherTools() {
        if (this.jComboBoxOtherTools == null) {
            this.jComboBoxOtherTools = new JComboBoxWithImageIconItems();
            this.jComboBoxOtherTools.setBounds(this.DEFAULT_OTHER_TOOLS_JCOMBOBOX_RECTANGLE);
            this.jComboBoxOtherTools.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-query-distance"), PluginServices.getText((Object)this, (String)"medir_distancias"), (Object)"MEASURE_DISTANCES"));
            this.jComboBoxOtherTools.addImageIconItem(new ImageIconItemInfo(null, PluginServices.getIconTheme().get("wfs-properties-query-area"), PluginServices.getText((Object)this, (String)"medir_area"), (Object)"MEASURE_AREA"));
            this.jComboBoxOtherTools.addActionListener(e -> {
                JComboBoxWithImageIconItems cb = (JComboBoxWithImageIconItems)e.getSource();
                ImageIconItemInfo iiii = (ImageIconItemInfo)cb.getSelectedItem();
                this.getSelectableMapAreaPanel().setTool((String)iiii.getItemValue());
            });
        }
        return this.jComboBoxOtherTools;
    }

    private void goToPreviousZoom() {
        ViewPort vp = this.getSelectableMapAreaPanel().getMapContext().getViewPort();
        if (vp.getExtents().hasPrevious()) {
            vp.setPreviousExtent();
            this.getCoordinatesPanel().updateCoordinates(vp.getAdjustedExtent());
        }
    }

    public void setEnvelope(Envelope envelope) {
        if (envelope != null) {
            this.getCoordinatesPanel().updateCoordinates(envelope);
            if (this.getSelectableMapAreaPanel().getMapContext().getLayers().getLayersCount() > 0) {
                this.getSelectableMapAreaPanel().getMapContext().getViewPort().setEnvelope(envelope);
            }
        }
    }

    public Geometry getArea() {
        if (!this.getEnablingJCheckBox().isSelected()) {
            return null;
        }
        if (this.getCoordinatesPanel().areAllCoordinatesUndefined()) {
            return null;
        }
        if (this.getCoordinatesPanel().validVertexes()) {
            try {
                return this.getCoordinatesPanel().getSurface();
            }
            catch (CreateGeometryException e) {
                logger.error("Creating the area", (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public void setArea(Geometry area) {
        if (area != null && area.getType() == 3) {
            this.getCoordinatesPanel().setSurface((Surface)area);
            this.getEnablingJCheckBox().setSelected(true);
        }
    }

    public IProjection getSrs() {
        return this.srs;
    }

    public void setSrs(IProjection srs) {
        this.srs = srs;
    }

    private void setApplicable(boolean b) {
        AbstractPanelGroup panelGroup = this.getPanelGroup();
        if (panelGroup == null) {
            return;
        }
        ((WFSParamsPanel)panelGroup).setApplicable(b);
    }

    public boolean areThereSomeCoordinatesWritten() {
        return this.getCoordinatesPanel().areThereSomeCoordinatesWritten();
    }

    public boolean areThereSomeCoordinatesUndefined() {
        return this.getCoordinatesPanel().isThereAnyCoordinateUndefined();
    }

    public void updateWFSArea() {
        this.getSelectableMapAreaPanel().disableAllMouseListeners();
        this.getSelectableMapAreaPanel().getMapContext().beginAtomicEvent();
        try {
            int i;
            MapContext mapContext = this.getSelectableMapAreaPanel().getMapContext();
            int numberOfLayers = mapContext.getLayers().getLayersCount();
            for (i = numberOfLayers - 1; i >= 0; --i) {
                mapContext.getLayers().removeLayer(i);
            }
            PluginServices.getMainFrame().enableControls();
            AbstractViewPanel view = (AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow();
            ViewPort vP = view.getMapControl().getMapContext().getViewPort();
            this.setSrs(vP.getProjection());
            Envelope envelope = vP.getAdjustedExtent();
            if (envelope == null) {
                this.getSelectableMapAreaPanel().getMapContext().endAtomicEvent();
                this.getJComboBoxToolSelection().setSelectedIndex(0);
                return;
            }
            this.getCoordinatesPanel().updateCoordinates(envelope);
            mapContext.getViewPort().setEnvelope(envelope);
            MapContext mC = view.getMapControl().getMapContext();
            numberOfLayers = mC.getLayers().getLayersCount();
            for (i = numberOfLayers - 1; i >= 0; --i) {
                FLayer clonedLayer = mC.getLayers().getLayer(i).cloneLayer();
                mapContext.getLayers().addLayer(clonedLayer);
                clonedLayer.dispose();
            }
            if (((ItemOperation)this.getJComboBoxToolSelection().getSelectedItem()).getOperation() == 2) {
                this.getSelectableMapAreaPanel().enableAllMouseListeners();
            }
            this.getSelectableMapAreaPanel().getMapContext().endAtomicEvent();
            this.getSelectableMapAreaPanel().getViewPort().refreshExtent();
        }
        catch (Exception e) {
            NotificationManager.addError((Throwable)e);
            this.getSelectableMapAreaPanel().getMapContext().endAtomicEvent();
            this.getJComboBoxToolSelection().setSelectedIndex(0);
            return;
        }
    }

    @Override
    protected void initialize() {
        this.setLabel(PluginServices.getText((Object)this, (String)"area"));
        this.setLabelGroup(PluginServices.getText((Object)this, (String)"wfs"));
        this.setLayout(new BorderLayout());
        this.northPanel = new JPanel();
        this.northPanel.setLayout(new GridBagLayout());
        this.northPanel.setBorder(BorderFactory.createTitledBorder(null, PluginServices.getText((Object)this, (String)"select_by_area_in_crs_of_view"), 0, 0, null, null));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.getCoordinatesPanel(), gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.northPanel.add((Component)this.getEnablingJCheckBox(), gridBagConstraints);
        this.previousExtentValids = new Stack();
        this.initCoordinates();
        this.add(this.northPanel, "North");
    }

    @Override
    public void refresh(WFSSelectedFeature layer) {
    }

    private class ValidationInfo {
        private final boolean _valid;
        private final String _message;

        public ValidationInfo(boolean valid, String message) {
            this._valid = valid;
            this._message = message;
        }

        public boolean isValid() {
            return this._valid;
        }

        public String getMessage() {
            return this._message;
        }
    }

    private class SelectableMapControlAreaPanel
    extends MapControl {
        private MouseListener[] mouseListeners;
        private MouseWheelListener[] mouseWheelListeners;
        private MouseMotionListener[] mouseMotionListeners;

        public SelectableMapControlAreaPanel() {
            this.initialize();
        }

        public void initialize() {
            this.setBounds(WFSAreaPanel.this.DEFAULT_AREA_MAPCONTROL_PANEL_RECTANGLE);
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            MapContext mp = ((AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow()).getMapControl().getMapContext();
            this.setMapContext(mp.cloneFMap());
            ViewPort vP = this.getViewPort();
            Envelope envelope = vP.getAdjustedExtent();
            if (envelope != null) {
                vP.refreshExtent();
                WFSAreaPanel.this.getCoordinatesPanel().updateCoordinates(envelope);
            }
            this.addToolsListeners();
            this.setTool("HAND");
        }

        public void refreshWithTheActiveView() {
            MapContext mp = ((AbstractViewPanel)PluginServices.getMDIManager().getActiveWindow()).getMapControl().getMapContext();
            this.setMapContext(mp.cloneFMap());
            ViewPort vP = this.getViewPort();
            Envelope envelope = vP.getAdjustedExtent();
            if (envelope != null) {
                vP.refreshExtent();
                WFSAreaPanel.this.getCoordinatesPanel().updateCoordinates(envelope);
            }
        }

        private void addToolsListeners() {
            StatusBarListener sbl = new StatusBarListener((MapControl)this);
            ZoomOutListener zol = new ZoomOutListener((MapControl)this);
            this.addBehavior("zoomOut", new Behavior[]{new PointBehavior((PointListener)zol), new MouseMovementBehavior((PointListener)sbl)});
            ZoomOutRightButtonListener zoil = new ZoomOutRightButtonListener((MapControl)this);
            ZoomInListener zil = new ZoomInListener((MapControl)this);
            this.addBehavior("zoomIn", new Behavior[]{new RectangleBehavior((RectangleListener)zil), new PointBehavior((PointListener)zoil), new MouseMovementBehavior((PointListener)sbl)});
            PanListener pl = new PanListener((MapControl)this);
            this.addBehavior("HAND", new Behavior[]{new MoveBehavior((org.gvsig.fmap.mapcontrol.tools.Listeners.PanListener)pl), new MouseMovementBehavior((PointListener)sbl)});
            MeasureListener mli = new MeasureListener((MapControl)this);
            this.addBehavior("MEASURE_DISTANCES", new Behavior[]{new PolylineBehavior((PolylineListener)mli), new MouseMovementBehavior((PointListener)sbl)});
            AreaListener ali = new AreaListener((MapControl)this);
            this.addBehavior("MEASURE_AREA", new Behavior[]{new PolygonBehavior((PolylineListener)ali), new MouseMovementBehavior((PointListener)sbl)});
            this.getViewPort().addViewPortListener(new ViewPortListener(){

                public void extentChanged(ExtentEvent e) {
                    if (!WFSAreaPanel.this.getEnablingJCheckBox().isSelected()) {
                        return;
                    }
                    if (SelectableMapControlAreaPanel.this.getMapContext().getViewPort().getEnvelopes().hasPrevious()) {
                        Envelope envelope = SelectableMapControlAreaPanel.this.getViewPort().getAdjustedEnvelope();
                        if (envelope != null) {
                            WFSAreaPanel.this.getCoordinatesPanel().updateCoordinates(envelope);
                        }
                        WFSAreaPanel.this.getJButtonZoomPrevious().setEnabled(true);
                        WFSAreaPanel.this.getJButtonUndo().setEnabled(true);
                    } else {
                        WFSAreaPanel.this.getJButtonZoomPrevious().setEnabled(false);
                        WFSAreaPanel.this.getJButtonUndo().setEnabled(false);
                    }
                }

                public void backColorChanged(ColorEvent e) {
                }

                public void projectionChanged(ProjectionEvent e) {
                }
            });
        }

        public void setEnabled(boolean b) {
            super.setEnabled(b);
            if (b) {
                this.enableAllMouseListeners();
            } else {
                this.disableAllMouseListeners();
            }
        }

        public void disableAllMouseListeners() {
            int i;
            if (this.mouseListeners == null) {
                this.mouseListeners = this.getMouseListeners();
                for (i = 0; i < this.mouseListeners.length; ++i) {
                    this.removeMouseListener(this.mouseListeners[i]);
                }
            }
            if (this.mouseWheelListeners == null) {
                this.mouseWheelListeners = this.getMouseWheelListeners();
                for (i = 0; i < this.mouseWheelListeners.length; ++i) {
                    this.removeMouseWheelListener(this.mouseWheelListeners[i]);
                }
            }
            if (this.mouseMotionListeners == null) {
                this.mouseMotionListeners = this.getMouseMotionListeners();
                for (i = 0; i < this.mouseMotionListeners.length; ++i) {
                    this.removeMouseMotionListener(this.mouseMotionListeners[i]);
                }
            }
        }

        public void enableAllMouseListeners() {
            int i;
            for (i = 0; i < this.mouseListeners.length; ++i) {
                this.addMouseListener(this.mouseListeners[i]);
            }
            this.mouseListeners = null;
            for (i = 0; i < this.mouseWheelListeners.length; ++i) {
                this.addMouseWheelListener(this.mouseWheelListeners[i]);
            }
            this.mouseWheelListeners = null;
            for (i = 0; i < this.mouseMotionListeners.length; ++i) {
                this.addMouseMotionListener(this.mouseMotionListeners[i]);
            }
            this.mouseMotionListeners = null;
        }
    }

    private class AreaCoordinatesPanel
    extends JPanel {
        private final Rectangle DEFAULT_JBUTTON_GO_TO_AREA_RECTANGLE = new Rectangle(412, 5, 62, 51);
        private final int DEFAULT_LABELS_AND_TEXT_FIELDS_HEIGHT = 20;
        private final int DEFAULT_COORDINATE_LABEL_WIDTH = 20;
        private final int DEFAULT_TEXT_FIELDS_WIDTH = 132;
        private final int DEFAULT_X_LOCATION = 8;
        private final int DEFAULT_Y_LEFT_UP_CORNER_LOCATION = 6;
        private final int DEFAULT_COORDINATE_WIDTH = 162;
        private final int DEFAULT_COORDINATE_HEIGHT = 25;
        private final Dimension DEFAULT_JLABEL_VERTEX_DIMENSION = new Dimension(60, 20);
        private final int DEFAULT_XY_COORDINATES_WIDTH;
        private final String JTEXTFIELD_V1X_NAME = "V1X";
        private final String JTEXTFIELD_V1Y_NAME = "V1Y";
        private final String JTEXTFIELD_V2X_NAME = "V2X";
        private final String JTEXTFIELD_V2Y_NAME = "V2Y";
        private final short JTEXTFIELD_V1X = 1;
        private final short JTEXTFIELD_V1Y = 2;
        private final short JTEXTFIELD_V2X = 3;
        private final short JTEXTFIELD_V2Y = 4;
        private JPanel jPanelVertex1;
        private JPanel jPanelVertex2;
        private JPanel jPanelVertex1X;
        private JPanel jPanelVertex1Y;
        private JPanel jPanelVertex2X;
        private JPanel jPanelVertex2Y;
        private JLabel jLabelVertex1;
        private JLabel jLabelVertex2;
        private JLabel jLabelVertex1X;
        private JLabel jLabelVertex1Y;
        private JLabel jLabelVertex2X;
        private JLabel jLabelVertex2Y;
        private JTextFieldWithSCP jTextFieldVertex1X;
        private JTextFieldWithSCP jTextFieldVertex1Y;
        private JTextFieldWithSCP jTextFieldVertex2X;
        private JTextFieldWithSCP jTextFieldVertex2Y;
        private JButton jButtonPreviewArea;
        private String[] last_Coordinates;
        private boolean hasChanged_v1X;
        private boolean hasChanged_v1Y;
        private boolean hasChanged_v2X;
        private boolean hasChanged_v2Y;
        private String[] previous_Coordinate_Value;
        private short current_coordinate_with_focus;
        private FocusListener focusListenerForCoordinateValidation;
        private KeyListener keyListenerForCoordinateValidation;

        public AreaCoordinatesPanel() {
            this.DEFAULT_XY_COORDINATES_WIDTH = 324 + this.DEFAULT_JLABEL_VERTEX_DIMENSION.width + 10;
            this.JTEXTFIELD_V1X_NAME = "V1X";
            this.JTEXTFIELD_V1Y_NAME = "V1Y";
            this.JTEXTFIELD_V2X_NAME = "V2X";
            this.JTEXTFIELD_V2Y_NAME = "V2Y";
            this.JTEXTFIELD_V1X = 1;
            this.JTEXTFIELD_V1Y = (short)2;
            this.JTEXTFIELD_V2X = (short)3;
            this.JTEXTFIELD_V2Y = (short)4;
            this.jPanelVertex1 = null;
            this.jPanelVertex2 = null;
            this.jPanelVertex1X = null;
            this.jPanelVertex1Y = null;
            this.jPanelVertex2X = null;
            this.jPanelVertex2Y = null;
            this.jLabelVertex1 = null;
            this.jLabelVertex2 = null;
            this.jLabelVertex1X = null;
            this.jLabelVertex1Y = null;
            this.jLabelVertex2X = null;
            this.jLabelVertex2Y = null;
            this.jTextFieldVertex1X = null;
            this.jTextFieldVertex1Y = null;
            this.jTextFieldVertex2X = null;
            this.jTextFieldVertex2Y = null;
            this.jButtonPreviewArea = null;
            this.focusListenerForCoordinateValidation = null;
            this.keyListenerForCoordinateValidation = null;
            this.initialize();
        }

        private void initialize() {
            this.setLayout(new GridBagLayout());
            this.setBounds(WFSAreaPanel.this.DEFAULT_AREA_COORDINATES_PANEL_RECTANGLE);
            this.setBorder(BorderFactory.createLineBorder(Color.gray, 1));
            this.setToolTipText(PluginServices.getText((Object)this, (String)"select_by_vertexes_coordinates"));
            this.last_Coordinates = new String[4];
            this.last_Coordinates[0] = "";
            this.last_Coordinates[1] = "";
            this.last_Coordinates[2] = "";
            this.last_Coordinates[3] = "";
            this.previous_Coordinate_Value = new String[4];
            this.resetCoordinatesFlags();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.getJPanelVertex1(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.getJPanelVertex2(), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            this.add((Component)this.getJButtonValidateArea(), gridBagConstraints);
        }

        public int getDefaultWidth() {
            return 324;
        }

        public int getDefaultHeight() {
            return 50;
        }

        private void resetCoordinatesFlags() {
            this.hasChanged_v1X = false;
            this.hasChanged_v1Y = false;
            this.hasChanged_v2X = false;
            this.hasChanged_v2Y = false;
        }

        private JPanel getJPanelVertex1() {
            if (this.jPanelVertex1 == null) {
                this.jPanelVertex1 = new JPanel();
                this.jPanelVertex1.setBounds(8, 6, this.DEFAULT_XY_COORDINATES_WIDTH, 25);
                this.jPanelVertex1.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex1.add((Component)this.getJLabelVertex1(), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex1.add((Component)this.getJPanelVertex1X(), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex1.add((Component)this.getJPanelVertex1Y(), gridBagConstraints);
            }
            return this.jPanelVertex1;
        }

        private JPanel getJPanelVertex2() {
            if (this.jPanelVertex2 == null) {
                this.jPanelVertex2 = new JPanel();
                this.jPanelVertex2.setBounds(8, 31, this.DEFAULT_XY_COORDINATES_WIDTH, 25);
                this.jPanelVertex2.setLayout(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex2.add((Component)this.getJLabelVertex2(), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex2.add((Component)this.getJPanelVertex2X(), gridBagConstraints);
                gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                this.jPanelVertex2.add((Component)this.getJPanelVertex2Y(), gridBagConstraints);
            }
            return this.jPanelVertex2;
        }

        private JLabel getJLabelVertex1() {
            if (this.jLabelVertex1 == null) {
                this.jLabelVertex1 = new JLabel();
                this.jLabelVertex1.setPreferredSize(this.DEFAULT_JLABEL_VERTEX_DIMENSION);
                this.jLabelVertex1.setToolTipText(PluginServices.getText((Object)this, (String)"coordinates_from_area_right_up_vertex"));
                this.jLabelVertex1.setText(PluginServices.getText((Object)this, (String)"vertex") + " 1:");
                this.jLabelVertex1.setHorizontalAlignment(2);
                this.jLabelVertex1.setVerticalAlignment(0);
                this.jLabelVertex1.setForeground(new Color(0, 0, 255));
            }
            return this.jLabelVertex1;
        }

        private JLabel getJLabelVertex2() {
            if (this.jLabelVertex2 == null) {
                this.jLabelVertex2 = new JLabel();
                this.jLabelVertex2.setPreferredSize(this.DEFAULT_JLABEL_VERTEX_DIMENSION);
                this.jLabelVertex2.setToolTipText(PluginServices.getText((Object)this, (String)"coordinates_from_area_left_bottom_vertex"));
                this.jLabelVertex2.setText(PluginServices.getText((Object)this, (String)"vertex") + " 2:");
                this.jLabelVertex2.setHorizontalAlignment(2);
                this.jLabelVertex2.setVerticalAlignment(0);
                this.jLabelVertex2.setForeground(new Color(128, 64, 0));
            }
            return this.jLabelVertex2;
        }

        private JPanel getJPanelVertex1X() {
            if (this.jPanelVertex1X == null) {
                this.jPanelVertex1X = new JPanel();
                this.jPanelVertex1X.setPreferredSize(new Dimension(new Dimension(162, 25)));
                this.jPanelVertex1X.setLayout(new GridBagLayout());
                this.jPanelVertex1X.add((Component)this.getJLabelVertex1X(), null);
                this.jPanelVertex1X.add((Component)this.getJTextFieldVertex1X(), null);
            }
            return this.jPanelVertex1X;
        }

        private JPanel getJPanelVertex1Y() {
            if (this.jPanelVertex1Y == null) {
                this.jPanelVertex1Y = new JPanel();
                this.jPanelVertex1Y.setPreferredSize(new Dimension(new Dimension(162, 25)));
                this.jPanelVertex1Y.setLayout(new GridBagLayout());
                this.jPanelVertex1Y.add((Component)this.getJLabelVertex1Y(), null);
                this.jPanelVertex1Y.add((Component)this.getJTextFieldVertex1Y(), null);
            }
            return this.jPanelVertex1Y;
        }

        private JPanel getJPanelVertex2X() {
            if (this.jPanelVertex2X == null) {
                this.jPanelVertex2X = new JPanel();
                this.jPanelVertex2X.setPreferredSize(new Dimension(new Dimension(162, 25)));
                this.jPanelVertex2X.setLayout(new GridBagLayout());
                this.jPanelVertex2X.add((Component)this.getJLabelVertex2X(), null);
                this.jPanelVertex2X.add((Component)this.getJTextFieldVertex2X(), null);
            }
            return this.jPanelVertex2X;
        }

        private JPanel getJPanelVertex2Y() {
            if (this.jPanelVertex2Y == null) {
                this.jPanelVertex2Y = new JPanel();
                this.jPanelVertex2Y.setPreferredSize(new Dimension(new Dimension(162, 25)));
                this.jPanelVertex2Y.setLayout(new GridBagLayout());
                this.jPanelVertex2Y.add((Component)this.getJLabelVertex2Y(), null);
                this.jPanelVertex2Y.add((Component)this.getJTextFieldVertex2Y(), null);
            }
            return this.jPanelVertex2Y;
        }

        private JLabel getJLabelVertex1X() {
            if (this.jLabelVertex1X == null) {
                this.jLabelVertex1X = new JLabel();
                this.jLabelVertex1X.setPreferredSize(new Dimension(20, 20));
                this.jLabelVertex1X.setToolTipText(PluginServices.getText((Object)this, (String)"x_coordinate_from_area_right_up_vertex"));
                this.jLabelVertex1X.setText(PluginServices.getText((Object)this, (String)"x") + ":");
                this.jLabelVertex1X.setHorizontalAlignment(0);
                this.jLabelVertex1X.setVerticalAlignment(0);
                this.jLabelVertex1X.setForeground(new Color(0, 0, 255));
            }
            return this.jLabelVertex1X;
        }

        private JLabel getJLabelVertex2X() {
            if (this.jLabelVertex2X == null) {
                this.jLabelVertex2X = new JLabel();
                this.jLabelVertex2X.setPreferredSize(new Dimension(20, 20));
                this.jLabelVertex2X.setToolTipText(PluginServices.getText((Object)this, (String)"x_coordinate_from_area_left_bottom_vertex"));
                this.jLabelVertex2X.setText(PluginServices.getText((Object)this, (String)"x") + ":");
                this.jLabelVertex2X.setHorizontalAlignment(0);
                this.jLabelVertex2X.setVerticalAlignment(0);
                this.jLabelVertex2X.setForeground(new Color(128, 64, 0));
            }
            return this.jLabelVertex2X;
        }

        private JLabel getJLabelVertex1Y() {
            if (this.jLabelVertex1Y == null) {
                this.jLabelVertex1Y = new JLabel();
                this.jLabelVertex1Y.setPreferredSize(new Dimension(20, 20));
                this.jLabelVertex1Y.setToolTipText(PluginServices.getText((Object)this, (String)"y_coordinate_from_area_right_up_vertex"));
                this.jLabelVertex1Y.setText(PluginServices.getText((Object)this, (String)"y") + ":");
                this.jLabelVertex1Y.setHorizontalAlignment(0);
                this.jLabelVertex1Y.setVerticalAlignment(0);
                this.jLabelVertex1Y.setForeground(new Color(0, 0, 255));
            }
            return this.jLabelVertex1Y;
        }

        private JLabel getJLabelVertex2Y() {
            if (this.jLabelVertex2Y == null) {
                this.jLabelVertex2Y = new JLabel();
                this.jLabelVertex2Y.setPreferredSize(new Dimension(20, 20));
                this.jLabelVertex2Y.setToolTipText(PluginServices.getText((Object)this, (String)"y_coordinate_from_area_left_bottom_vertex"));
                this.jLabelVertex2Y.setText(PluginServices.getText((Object)this, (String)"y") + ":");
                this.jLabelVertex2Y.setHorizontalAlignment(0);
                this.jLabelVertex2Y.setVerticalAlignment(0);
                this.jLabelVertex2Y.setForeground(new Color(128, 64, 0));
            }
            return this.jLabelVertex2Y;
        }

        private FocusListener getFocusListenerForCoordinateValidation() {
            if (this.focusListenerForCoordinateValidation == null) {
                this.focusListenerForCoordinateValidation = new FocusListener(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        JTextField jTF = (JTextField)e.getSource();
                        if (jTF.getName().compareTo("V1X") == 0) {
                            AreaCoordinatesPanel.this.current_coordinate_with_focus = (short)1;
                            return;
                        }
                        if (jTF.getName().compareTo("V1Y") == 0) {
                            AreaCoordinatesPanel.this.current_coordinate_with_focus = (short)2;
                            return;
                        }
                        if (jTF.getName().compareTo("V2X") == 0) {
                            AreaCoordinatesPanel.this.current_coordinate_with_focus = (short)3;
                            return;
                        }
                        if (jTF.getName().compareTo("V2Y") == 0) {
                            AreaCoordinatesPanel.this.current_coordinate_with_focus = (short)4;
                            return;
                        }
                    }

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (!WFSAreaPanel.this.getEnablingJCheckBox().isSelected()) {
                            return;
                        }
                        JTextField jTF = (JTextField)e.getSource();
                        String text = jTF.getText();
                        if (jTF.getName().compareTo("V1X") == 0) {
                            if (text.compareTo(AreaCoordinatesPanel.this.last_Coordinates[0]) != 0) {
                                AreaCoordinatesPanel.this.hasChanged_v1X = true;
                            }
                            return;
                        }
                        if (jTF.getName().compareTo("V1Y") == 0) {
                            if (text.compareTo(AreaCoordinatesPanel.this.last_Coordinates[1]) != 0) {
                                AreaCoordinatesPanel.this.hasChanged_v1Y = true;
                            }
                            return;
                        }
                        if (jTF.getName().compareTo("V2X") == 0) {
                            if (text.compareTo(AreaCoordinatesPanel.this.last_Coordinates[2]) != 0) {
                                AreaCoordinatesPanel.this.hasChanged_v2X = true;
                            }
                            return;
                        }
                        if (jTF.getName().compareTo("V2Y") == 0) {
                            if (text.compareTo(AreaCoordinatesPanel.this.last_Coordinates[3]) != 0) {
                                AreaCoordinatesPanel.this.hasChanged_v2Y = true;
                            }
                            return;
                        }
                    }
                };
            }
            return this.focusListenerForCoordinateValidation;
        }

        private KeyListener getKeyListenerForCoordinateValidation() {
            if (this.keyListenerForCoordinateValidation == null) {
                this.keyListenerForCoordinateValidation = new KeyListener(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                    }

                    @Override
                    public void keyReleased(KeyEvent e) {
                        AreaCoordinatesPanel.this.validateCoordinate(AreaCoordinatesPanel.this.current_coordinate_with_focus);
                    }

                    @Override
                    public void keyTyped(KeyEvent e) {
                    }
                };
            }
            return this.keyListenerForCoordinateValidation;
        }

        private JTextFieldWithSCP getJTextFieldVertex1X() {
            if (this.jTextFieldVertex1X == null) {
                this.jTextFieldVertex1X = new JTextFieldWithSCP("");
                this.jTextFieldVertex1X.setPreferredSize(new Dimension(132, 20));
                this.jTextFieldVertex1X.setToolTipText(PluginServices.getText((Object)this, (String)"x_coordinate_from_area_right_up_vertex"));
                this.jTextFieldVertex1X.addFocusListener(this.getFocusListenerForCoordinateValidation());
                this.jTextFieldVertex1X.addKeyListener(this.getKeyListenerForCoordinateValidation());
                this.jTextFieldVertex1X.setName("V1X");
            }
            return this.jTextFieldVertex1X;
        }

        private JTextFieldWithSCP getJTextFieldVertex1Y() {
            if (this.jTextFieldVertex1Y == null) {
                this.jTextFieldVertex1Y = new JTextFieldWithSCP("");
                this.jTextFieldVertex1Y.setPreferredSize(new Dimension(132, 20));
                this.jTextFieldVertex1Y.setToolTipText(PluginServices.getText((Object)this, (String)"y_coordinate_from_area_right_up_vertex"));
                this.jTextFieldVertex1Y.addFocusListener(this.getFocusListenerForCoordinateValidation());
                this.jTextFieldVertex1Y.addKeyListener(this.getKeyListenerForCoordinateValidation());
                this.jTextFieldVertex1Y.setName("V1Y");
            }
            return this.jTextFieldVertex1Y;
        }

        private JTextFieldWithSCP getJTextFieldVertex2X() {
            if (this.jTextFieldVertex2X == null) {
                this.jTextFieldVertex2X = new JTextFieldWithSCP("");
                this.jTextFieldVertex2X.setPreferredSize(new Dimension(132, 20));
                this.jTextFieldVertex2X.setToolTipText(PluginServices.getText((Object)this, (String)"x_coordinate_from_area_left_bottom_vertex"));
                this.jTextFieldVertex2X.addFocusListener(this.getFocusListenerForCoordinateValidation());
                this.jTextFieldVertex2X.addKeyListener(this.getKeyListenerForCoordinateValidation());
                this.jTextFieldVertex2X.setName("V2X");
            }
            return this.jTextFieldVertex2X;
        }

        private JTextFieldWithSCP getJTextFieldVertex2Y() {
            if (this.jTextFieldVertex2Y == null) {
                this.jTextFieldVertex2Y = new JTextFieldWithSCP("");
                this.jTextFieldVertex2Y.setPreferredSize(new Dimension(132, 20));
                this.jTextFieldVertex2Y.setToolTipText(PluginServices.getText((Object)this, (String)"y_coordinate_from_area_left_bottom_vertex"));
                this.jTextFieldVertex2Y.addFocusListener(this.getFocusListenerForCoordinateValidation());
                this.jTextFieldVertex2Y.addKeyListener(this.getKeyListenerForCoordinateValidation());
                this.jTextFieldVertex2Y.setName("V2Y");
            }
            return this.jTextFieldVertex2Y;
        }

        public double getDoubleValueOfJTextFieldV1X() {
            return Double.parseDouble(this.getJTextFieldVertex1X().getText());
        }

        public double getDoubleValueOfJTextFieldV1Y() {
            return Double.parseDouble(this.getJTextFieldVertex1Y().getText());
        }

        public double getDoubleValueOfJTextFieldV2X() {
            return Double.parseDouble(this.getJTextFieldVertex2X().getText());
        }

        public double getDoubleValueOfJTextFieldV2Y() {
            return Double.parseDouble(this.getJTextFieldVertex2Y().getText());
        }

        public double getDoubleValueOfLastJTextFieldV1XValue() {
            return Double.parseDouble(this.last_Coordinates[0]);
        }

        public double getDoubleValueOfLastJTextFieldV1YValue() {
            return Double.parseDouble(this.last_Coordinates[1]);
        }

        public double getDoubleValueOfLastJTextFieldV2XValue() {
            return Double.parseDouble(this.last_Coordinates[2]);
        }

        public double getDoubleValueOfLastJTextFieldV2YValue() {
            return Double.parseDouble(this.last_Coordinates[3]);
        }

        private boolean validateCoordinate(JTextField coordinate) {
            if (coordinate != null) {
                return coordinate.getText().compareTo("") == 0 || StringNumberUtilities.isRealNumberWithIntegerExponent((String)coordinate.getText());
            }
            return false;
        }

        private boolean validateCoordinate(int coordinate_ID) {
            switch (coordinate_ID) {
                case 1: {
                    JTextFieldWithSCP coordinate = this.getJTextFieldVertex1X();
                    String text = coordinate.getText();
                    if (text.compareTo("") != 0 && !StringNumberUtilities.isRealNumberWithIntegerExponent((String)text)) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText(null, (String)"incorrect_coordinate_format"), PluginServices.getText(null, (String)"error"), 0);
                        coordinate.setText(this.previous_Coordinate_Value[0]);
                        return false;
                    }
                    this.previous_Coordinate_Value[0] = text;
                    return true;
                }
                case 2: {
                    JTextFieldWithSCP coordinate = this.getJTextFieldVertex1Y();
                    String text = coordinate.getText();
                    if (text.compareTo("") != 0 && !StringNumberUtilities.isRealNumberWithIntegerExponent((String)text)) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText(null, (String)"incorrect_coordinate_format"), PluginServices.getText(null, (String)"error"), 0);
                        coordinate.setText(this.previous_Coordinate_Value[1]);
                        return false;
                    }
                    this.previous_Coordinate_Value[1] = text;
                    return true;
                }
                case 3: {
                    JTextFieldWithSCP coordinate = this.getJTextFieldVertex2X();
                    String text = coordinate.getText();
                    if (text.compareTo("") != 0 && !StringNumberUtilities.isRealNumberWithIntegerExponent((String)text)) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText(null, (String)"incorrect_coordinate_format"), PluginServices.getText(null, (String)"error"), 0);
                        coordinate.setText(this.previous_Coordinate_Value[2]);
                        return false;
                    }
                    this.previous_Coordinate_Value[2] = text;
                    return true;
                }
                case 4: {
                    JTextFieldWithSCP coordinate = this.getJTextFieldVertex2Y();
                    String text = coordinate.getText();
                    if (text.compareTo("") != 0 && !StringNumberUtilities.isRealNumberWithIntegerExponent((String)text)) {
                        JOptionPane.showMessageDialog(this, PluginServices.getText(null, (String)"incorrect_coordinate_format"), PluginServices.getText(null, (String)"error"), 0);
                        coordinate.setText(this.previous_Coordinate_Value[3]);
                        return false;
                    }
                    this.previous_Coordinate_Value[3] = text;
                    return true;
                }
            }
            return true;
        }

        private JButton getJButtonValidateArea() {
            if (this.jButtonPreviewArea == null) {
                this.jButtonPreviewArea = new JButton();
                this.jButtonPreviewArea.setBounds(this.DEFAULT_JBUTTON_GO_TO_AREA_RECTANGLE);
                this.jButtonPreviewArea.setToolTipText(PluginServices.getText((Object)this, (String)"to_validate_coodinates"));
                this.jButtonPreviewArea.setVerticalTextPosition(0);
                this.jButtonPreviewArea.setHorizontalTextPosition(0);
                this.jButtonPreviewArea.setIcon(PluginServices.getIconTheme().get("wfs-properties-validate-area"));
                this.jButtonPreviewArea.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        AreaCoordinatesPanel.this.validVertexes();
                    }
                });
            }
            return this.jButtonPreviewArea;
        }

        public void setAllTextFieldsEnabled(boolean b) {
            this.getJTextFieldVertex1X().setEnabled(b);
            this.getJTextFieldVertex1Y().setEnabled(b);
            this.getJTextFieldVertex2X().setEnabled(b);
            this.getJTextFieldVertex2Y().setEnabled(b);
        }

        public void updateCoordinates(Envelope envelope) {
            this.getJTextFieldVertex1X().setText(String.valueOf(envelope.getMaximum(0)));
            this.last_Coordinates[0] = this.getJTextFieldVertex1X().getText();
            this.previous_Coordinate_Value[0] = this.last_Coordinates[0];
            this.getJTextFieldVertex1Y().setText(String.valueOf(envelope.getMaximum(1)));
            this.last_Coordinates[1] = this.getJTextFieldVertex1Y().getText();
            this.previous_Coordinate_Value[1] = this.last_Coordinates[1];
            this.getJTextFieldVertex2X().setText(String.valueOf(envelope.getMinimum(0)));
            this.last_Coordinates[2] = this.getJTextFieldVertex2X().getText();
            this.previous_Coordinate_Value[2] = this.last_Coordinates[2];
            this.getJTextFieldVertex2Y().setText(String.valueOf(envelope.getMinimum(1)));
            this.last_Coordinates[3] = this.getJTextFieldVertex2Y().getText();
            this.previous_Coordinate_Value[3] = this.last_Coordinates[3];
            this.resetCoordinatesFlags();
        }

        private void setBackGroundColorToCoordinatesFields(Color c) {
            this.getJTextFieldVertex1X().setBackground(c);
            this.getJTextFieldVertex1Y().setBackground(c);
            this.getJTextFieldVertex2X().setBackground(c);
            this.getJTextFieldVertex2Y().setBackground(c);
        }

        private ValidationInfo validVertexesCoordinates() {
            String infoPrefix = null;
            String infoSufix = null;
            if (!this.validateCoordinate((JTextField)this.getJTextFieldVertex1X())) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v1x");
                }
                this.getJTextFieldVertex1X().setBackground(Color.RED);
            }
            if (!this.validateCoordinate((JTextField)this.getJTextFieldVertex1Y())) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v1y");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v1y");
                }
                this.getJTextFieldVertex1Y().setBackground(Color.RED);
            }
            if (!this.validateCoordinate((JTextField)this.getJTextFieldVertex2X())) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v2x");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v2x");
                }
                this.getJTextFieldVertex2X().setBackground(Color.RED);
            }
            if (!this.validateCoordinate((JTextField)this.getJTextFieldVertex2Y())) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v2y");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"invalid_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v2y");
                }
                this.getJTextFieldVertex2Y().setBackground(Color.RED);
            }
            if (infoPrefix != null) {
                return new ValidationInfo(false, infoPrefix + infoSufix);
            }
            this.setBackGroundColorToCoordinatesFields(Color.GREEN);
            return new ValidationInfo(true, "");
        }

        private ValidationInfo validVertexesPositions() {
            String infoPrefix = null;
            String infoSufix = null;
            if (this.getJTextFieldVertex1X().getText().compareTo("") == 0) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v1x");
                }
                this.getJTextFieldVertex1X().setBackground(Color.RED);
            }
            if (this.getJTextFieldVertex1Y().getText().compareTo("") == 0) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v1y");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v1y");
                }
                this.getJTextFieldVertex1Y().setBackground(Color.RED);
            }
            if (this.getJTextFieldVertex2X().getText().compareTo("") == 0) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v2x");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v2x");
                }
                this.getJTextFieldVertex2X().setBackground(Color.RED);
            }
            if (this.getJTextFieldVertex2Y().getText().compareTo("") == 0) {
                if (infoSufix == null) {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinate") + ": ";
                    infoSufix = PluginServices.getText((Object)this, (String)"v2y");
                } else {
                    infoPrefix = PluginServices.getText((Object)this, (String)"undefined_coordinates") + ": ";
                    infoSufix = infoSufix + ", " + PluginServices.getText((Object)this, (String)"v2y");
                }
                this.getJTextFieldVertex2Y().setBackground(Color.RED);
            }
            if (infoPrefix != null) {
                return new ValidationInfo(false, infoPrefix + infoSufix);
            }
            if (this.getDoubleValueOfJTextFieldV1X() < this.getDoubleValueOfJTextFieldV2X()) {
                this.getJTextFieldVertex1X().setBackground(Color.RED);
                this.getJTextFieldVertex2X().setBackground(Color.RED);
                return new ValidationInfo(false, PluginServices.getText((Object)this, (String)"v1x") + " < " + PluginServices.getText((Object)this, (String)"v2x"));
            }
            if (this.getDoubleValueOfJTextFieldV1Y() < this.getDoubleValueOfJTextFieldV2Y()) {
                this.getJTextFieldVertex1Y().setBackground(Color.RED);
                this.getJTextFieldVertex2Y().setBackground(Color.RED);
                return new ValidationInfo(false, PluginServices.getText((Object)this, (String)"v1y") + " < " + PluginServices.getText((Object)this, (String)"v2y"));
            }
            this.setBackGroundColorToCoordinatesFields(Color.GREEN);
            return new ValidationInfo(true, "");
        }

        public boolean validVertexes() {
            ValidationInfo v1 = this.validVertexesCoordinates();
            if (!v1.isValid()) {
                JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)(PluginServices.getText((Object)this, (String)"invalid_coordinates") + ": " + v1.getMessage())), PluginServices.getText(null, (String)"warning"), 2);
                if (!WFSAreaPanel.this.previousExtentValids.isEmpty()) {
                    Rectangle2D previousExtent = (Rectangle2D)WFSAreaPanel.this.previousExtentValids.pop();
                    WFSAreaPanel.this.setCoordinates(previousExtent);
                    if (WFSAreaPanel.this.previousExtentValids.isEmpty()) {
                        WFSAreaPanel.this.setApplicable(false);
                    }
                    WFSAreaPanel.this.previousExtentValids.push(previousExtent);
                }
                return false;
            }
            ValidationInfo v2 = this.validVertexesPositions();
            if (!v2.isValid()) {
                JOptionPane.showMessageDialog(null, PluginServices.getText(null, (String)(PluginServices.getText((Object)this, (String)"invalid_coordinates") + ": " + v2.getMessage())), PluginServices.getText(null, (String)"warning"), 2);
                if (!WFSAreaPanel.this.previousExtentValids.isEmpty()) {
                    Rectangle2D previousExtent = (Rectangle2D)WFSAreaPanel.this.previousExtentValids.pop();
                    WFSAreaPanel.this.setCoordinates(previousExtent);
                    if (WFSAreaPanel.this.previousExtentValids.isEmpty()) {
                        WFSAreaPanel.this.setApplicable(false);
                    }
                    WFSAreaPanel.this.previousExtentValids.push(previousExtent);
                }
                return false;
            }
            if (!WFSAreaPanel.this.previousExtentValids.isEmpty()) {
                Rectangle2D previousExtent = (Rectangle2D)WFSAreaPanel.this.previousExtentValids.pop();
                if (!this.areEqual(previousExtent, this.getExtent())) {
                    WFSAreaPanel.this.previousExtentValids.push(previousExtent);
                    WFSAreaPanel.this.previousExtentValids.push(this.getExtent());
                    WFSAreaPanel.this.setApplicable(true);
                } else {
                    WFSAreaPanel.this.previousExtentValids.push(previousExtent);
                }
            } else {
                WFSAreaPanel.this.previousExtentValids.push(this.getExtent());
                WFSAreaPanel.this.setApplicable(true);
            }
            return true;
        }

        private boolean areEqual(Rectangle2D rect1, Rectangle2D rect2) {
            return rect1.getX() == rect2.getX() && rect1.getY() == rect2.getY() && rect1.getWidth() == rect2.getWidth() && rect1.getHeight() == rect2.getHeight();
        }

        public Rectangle2D getExtent() {
            double v1x = this.getDoubleValueOfJTextFieldV1X();
            double v1y = this.getDoubleValueOfJTextFieldV1Y();
            double v2x = this.getDoubleValueOfJTextFieldV2X();
            double v2y = this.getDoubleValueOfJTextFieldV2Y();
            return new Rectangle2D.Double(v2x, v2y, v1x - v2x, v1y - v2y);
        }

        public Surface getSurface() throws CreateGeometryException {
            double v1x = this.getDoubleValueOfJTextFieldV1X();
            double v1y = this.getDoubleValueOfJTextFieldV1Y();
            double v2x = this.getDoubleValueOfJTextFieldV2X();
            double v2y = this.getDoubleValueOfJTextFieldV2Y();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            Polygon polygon = geometryManager.createPolygon(0);
            polygon.addVertex(v1x, v1y);
            polygon.addVertex(v1x, v2y);
            polygon.addVertex(v2x, v2y);
            polygon.addVertex(v2x, v1y);
            return polygon;
        }

        public void setSurface(Surface surface) {
            Envelope envelope = surface.getEnvelope();
            this.updateCoordinates(envelope);
        }

        public boolean areThereSomeCoordinatesWritten() {
            return this.getJTextFieldVertex1X().getText().compareTo("") != 0 | this.getJTextFieldVertex1Y().getText().compareTo("") != 0 | this.getJTextFieldVertex2X().getText().compareTo("") != 0 | this.getJTextFieldVertex2Y().getText().compareTo("") != 0;
        }

        public boolean areAllCoordinatesUndefined() {
            return this.getJTextFieldVertex1X().getText().compareTo("") == 0 & this.getJTextFieldVertex1Y().getText().compareTo("") == 0 & this.getJTextFieldVertex2X().getText().compareTo("") == 0 & this.getJTextFieldVertex2Y().getText().compareTo("") == 0;
        }

        public boolean isThereAnyCoordinateUndefined() {
            return this.getJTextFieldVertex1X().getText().compareTo("") == 0 | this.getJTextFieldVertex1Y().getText().compareTo("") == 0 | this.getJTextFieldVertex2X().getText().compareTo("") == 0 | this.getJTextFieldVertex2Y().getText().compareTo("") == 0;
        }
    }

    private class ItemOperation {
        String _name;
        int _operation;

        public ItemOperation(String name, int operation) {
            this._name = name;
            this._operation = operation;
        }

        public String getName() {
            return this._name;
        }

        public int getOperation() {
            return this._operation;
        }

        public String toString() {
            return this._name;
        }
    }
}

