/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.hyperlink.app.extension.layers;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.hyperlink.app.extension.layers.ILinkLayerManager;
import org.gvsig.hyperlink.app.extension.layers.IncompatibleLayerException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPoint;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;

public class ManagerRegistry {
    public static final String EXTENSIONPOINTNAME = "hyperlink.layer.manager";
    private ExtensionPoint extensionPoint;
    private HashMap<Class, String> cachedManagers;
    private HashSet<Class> cachedUnmanagedLayers;

    public ManagerRegistry() {
        ExtensionPointManager epm = ToolsLocator.getExtensionPointManager();
        this.extensionPoint = epm.add(EXTENSIONPOINTNAME, "Registers ILinkToolManagers that are able to manage specific layer types.");
        this.cachedManagers = new HashMap();
        this.cachedManagers.put(FLyrVect.class, FLyrVect.class.getName());
        this.cachedUnmanagedLayers = new HashSet();
    }

    public void put(Class layerType, Class manager) {
        if (layerType.isInterface()) {
            throw new RuntimeException("Interfaces are not supported");
        }
        if (!ILinkLayerManager.class.isAssignableFrom(manager)) {
            throw new RuntimeException("Managers must be of type ILinkLayerManager");
        }
        this.extensionPoint.append(layerType.getName(), "", manager);
    }

    public ILinkLayerManager get(FLayer layer) throws ClassNotFoundException, InstantiationException, IllegalAccessException, IncompatibleLayerException {
        if (this.cachedManagers.containsKey(layer.getClass())) {
            String layerType = this.cachedManagers.get(layer.getClass());
            ILinkLayerManager manager = (ILinkLayerManager)this.extensionPoint.create(layerType);
            manager.setLayer(layer);
            return manager;
        }
        if (this.cachedUnmanagedLayers.contains(layer.getClass())) {
            return null;
        }
        Iterator it = this.extensionPoint.getNames().iterator();
        TreeSet<Class> classList = new TreeSet<Class>(new ClassComparator());
        while (it.hasNext()) {
            String layerType = it.next().toString();
            Class<?> layerClass = Class.forName(layerType);
            if (!layerClass.isInstance(layer)) continue;
            classList.add(layerClass);
        }
        if (!classList.isEmpty()) {
            ILinkLayerManager manager = (ILinkLayerManager)this.extensionPoint.create(classList.first().getName());
            this.cachedManagers.put(layer.getClass(), classList.first().getName());
            manager.setLayer(layer);
            return manager;
        }
        this.cachedUnmanagedLayers.add(layer.getClass());
        return null;
    }

    public boolean hasManager(FLayer layer) {
        if (this.cachedManagers.containsKey(layer.getClass())) {
            return true;
        }
        if (this.cachedUnmanagedLayers.contains(layer.getClass())) {
            return false;
        }
        Iterator it = this.extensionPoint.iterator();
        while (it.hasNext()) {
            Class layerClass = ((ExtensionPoint.Extension)it.next()).getExtension();
            if (!layerClass.isInstance(layer)) continue;
            return true;
        }
        return false;
    }

    private class ClassComparator
    implements Comparator<Class> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class class1, Class class2) {
            if (class1.equals(class2)) {
                return 0;
            }
            if (class1.isAssignableFrom(class2)) {
                return 1;
            }
            return -1;
        }
    }
}

