/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.util.ArrayList;
import org.gvsig.expressionevaluator.ExpressionEvaluatorLibrary;
import org.gvsig.fmap.dal.DALFileLibrary;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLibrary;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreProviderFactory;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFLibrary;
import org.gvsig.fmap.dal.store.shp.SHPFilesystemServerProvider;
import org.gvsig.fmap.dal.store.shp.SHPNewStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.SHPStoreProvider;
import org.gvsig.fmap.dal.store.shp.SHPStoreProviderFactory;
import org.gvsig.fmap.dal.store.shp.SHPStoreSaveEncodingMethod;
import org.gvsig.fmap.geom.GeometryLibrary;
import org.gvsig.metadata.exceptions.MetadataException;
import org.gvsig.tools.dynobject.DynClass;
import org.gvsig.tools.dynobject.DynMethod;
import org.gvsig.tools.library.AbstractLibrary;
import org.gvsig.tools.library.LibraryException;

public class SHPLibrary
extends AbstractLibrary {
    public void doRegistration() {
        this.registerAsServiceOf(DALLibrary.class);
        this.require(DALFileLibrary.class);
        this.require(DBFLibrary.class);
        this.require(GeometryLibrary.class);
        this.require(ExpressionEvaluatorLibrary.class);
    }

    protected void doPostInitialize() throws LibraryException {
        ArrayList<Throwable> exs = new ArrayList<Throwable>();
        FileHelper.registerParametersDefinition((String)"SHPStoreParameters", SHPStoreParameters.class, (String)"SHPParameters.xml");
        FileHelper.registerParametersDefinition((String)"SHPNewStoreParameters", SHPNewStoreParameters.class, (String)"SHPParameters.xml");
        try {
            DynClass metadataDefinition = (DynClass)FileHelper.registerMetadataDefinition((String)SHPStoreProvider.METADATA_DEFINITION_NAME, SHPStoreProvider.class, (String)"SHPMetadata.xml");
            metadataDefinition.addDynMethod((DynMethod)new SHPStoreSaveEncodingMethod());
        }
        catch (MetadataException e1) {
            exs.add(e1);
        }
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        try {
            if (!dataman.getStoreProviders().contains(SHPStoreProvider.NAME)) {
                dataman.registerStoreProviderFactory((DataStoreProviderFactory)new SHPStoreProviderFactory(SHPStoreProvider.NAME, SHPStoreProvider.DESCRIPTION));
            }
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        try {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(SHPStoreProvider.NAME, SHPStoreProvider.DESCRIPTION, SHPFilesystemServerProvider.class);
        }
        catch (RuntimeException e) {
            exs.add(e);
        }
        if (exs.size() > 0) {
            throw new LibraryException(((Object)((Object)this)).getClass(), exs);
        }
    }

    protected void doInitialize() throws LibraryException {
    }
}

