/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.FileHelper;
import org.gvsig.fmap.dal.exception.CloseException;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.exception.InitializeException;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.CreateGeometryException;
import org.gvsig.fmap.dal.feature.exception.PerformEditingException;
import org.gvsig.fmap.dal.feature.spi.FeatureProvider;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.resource.ResourceAction;
import org.gvsig.fmap.dal.resource.exception.ResourceException;
import org.gvsig.fmap.dal.resource.exception.ResourceExecuteException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyChangesException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyCloseException;
import org.gvsig.fmap.dal.resource.exception.ResourceNotifyOpenException;
import org.gvsig.fmap.dal.resource.spi.MultiResource;
import org.gvsig.fmap.dal.resource.spi.ResourceConsumer;
import org.gvsig.fmap.dal.resource.spi.ResourceProvider;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.fmap.dal.store.dbf.DBFFeatureProvider;
import org.gvsig.fmap.dal.store.dbf.DBFStoreParameters;
import org.gvsig.fmap.dal.store.dbf.DBFStoreProvider;
import org.gvsig.fmap.dal.store.shp.SHPFeatureProvider;
import org.gvsig.fmap.dal.store.shp.SHPFeatureWriter;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.ISHPFile;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPFile2;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.dynobject.exception.DynFieldNotFoundException;
import org.gvsig.tools.exception.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPStoreProvider
extends DBFStoreProvider {
    private static final GeometryManager GEOM_MANAGER = GeometryLocator.getGeometryManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(SHPStoreProvider.class);
    public static String NAME = "Shape";
    public static String DESCRIPTION = "Shape file";
    private ISHPFile shpFile;
    private MultiResource resource;
    public static final String GEOMETRY_ATTIBUTE_NAME = "GEOMETRY";
    public static final String METADATA_DEFINITION_NAME = NAME;
    private SHPFeatureWriter writer = null;
    private boolean loTengoEnUso;

    public SHPStoreProvider(SHPStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        super((DBFStoreParameters)params, storeServices, FileHelper.newMetadataContainer((String)METADATA_DEFINITION_NAME));
    }

    protected void init(DBFStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        this.shpFile = new SHPFile2((SHPStoreParameters)params);
        super.init(params, storeServices);
        this.shpFile.setUseNullGeometry(this.getShpParameters().getUseNullGeometry());
    }

    public SHPStoreParameters getParameters() {
        return (SHPStoreParameters)super.getParameters();
    }

    public IProjection getProjection() {
        return this.getShpParameters().getCRS();
    }

    public Object getDynValue(String name) throws DynFieldNotFoundException {
        if ("CRS".equalsIgnoreCase(name)) {
            return this.getShpParameters().getCRS();
        }
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.shpFile.getFullExtent();
            }
            catch (ReadException e) {
                return null;
            }
        }
        return super.getDynValue(name);
    }

    public boolean hasDynValue(String name) throws DynFieldNotFoundException {
        if ("CRS".equalsIgnoreCase(name)) {
            return this.getShpParameters().getCRS() != null;
        }
        if ("Envelope".equalsIgnoreCase(name)) {
            try {
                return this.shpFile.getFullExtent() != null;
            }
            catch (ReadException e) {
                return false;
            }
        }
        return super.hasDynValue(name);
    }

    protected void initResource(DBFStoreParameters params, DataStoreProviderServices storeServices) throws InitializeException {
        SHPStoreParameters shpParams = (SHPStoreParameters)params;
        this.resource = (MultiResource)this.createResource("multi", new Object[]{shpParams.getSHPFileName()});
        this.resource.addResource("file", new Object[]{shpParams.getSHPFileName()}, true);
        this.resource.addResource("file", new Object[]{shpParams.getSHXFileName()}, true);
        this.resource.addResource("file", new Object[]{shpParams.getDBFFileName()}, true);
        this.resource.frozen();
        this.resource.addMultiResourceConsumer((ResourceConsumer)this);
        super.initResource((ResourceProvider)this.resource, storeServices);
    }

    public ResourceProvider getResource() {
        return this.resource;
    }

    protected void resourcesNotifyChanges() throws ResourceNotifyChangesException {
        this.getResource().notifyChanges();
    }

    protected void resourcesNotifyClose() throws ResourceNotifyCloseException {
        this.getResource().notifyClose();
    }

    protected void doDispose() throws BaseException {
        super.doDispose();
        this.getResource().removeConsumer((ResourceConsumer)this);
        this.writer = null;
        this.shpFile = null;
    }

    protected void disposeResource() {
        this.getResource().removeConsumer((ResourceConsumer)this);
    }

    protected void resourcesOpen() throws ResourceNotifyOpenException {
        this.getResource().notifyOpen();
    }

    protected static EditableFeatureAttributeDescriptor addGeometryColumn(EditableFeatureType fType) {
        EditableFeatureAttributeDescriptor attrTmp2 = null;
        EditableFeatureAttributeDescriptor attr = null;
        for (EditableFeatureAttributeDescriptor attrTmp2 : fType) {
            if (attrTmp2.getType() != 66) continue;
            if (attr != null) {
                fType.remove(attrTmp2.getName());
                continue;
            }
            attr = attrTmp2;
        }
        if (attr == null) {
            String geofield = SHPStoreProvider.createGeometryFieldName((FeatureType)fType);
            attr = fType.add(geofield, 66);
            attr.setDefaultValue(null);
        }
        attr.setObjectClass(Geometry.class);
        attr.setAllowNull(true);
        return attr;
    }

    private static String createGeometryFieldName(FeatureType ft) {
        if (ft.getAttributeDescriptor(GEOMETRY_ATTIBUTE_NAME) == null) {
            return GEOMETRY_ATTIBUTE_NAME;
        }
        int i = 0;
        String candidate = GEOMETRY_ATTIBUTE_NAME + i;
        while (ft.getAttributeDescriptor(candidate) != null) {
            candidate = GEOMETRY_ATTIBUTE_NAME + ++i;
        }
        return candidate;
    }

    protected EditableFeatureType getTheFeatureType() throws InitializeException {
        try {
            this.open();
        }
        catch (DataException e) {
            throw new InitializeException(this.getProviderName(), (Throwable)e);
        }
        final EditableFeatureType fType = super.getTheFeatureType();
        try {
            this.getResource().execute(new ResourceAction(){

                public Object run() throws Exception {
                    EditableFeatureAttributeDescriptor attr = SHPStoreProvider.addGeometryColumn(fType);
                    attr.setGeometryType(GEOM_MANAGER.getGeometryType(SHPStoreProvider.this.shpFile.getGeometryType(), SHPStoreProvider.this.shpFile.getGeometrySubType()));
                    IProjection srs = SHPStoreProvider.this.getShpParameters().getCRS();
                    attr.setSRS(srs);
                    return null;
                }
            });
            return fType;
        }
        catch (ResourceExecuteException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    protected SHPStoreParameters getShpParameters() {
        return this.getParameters();
    }

    public String getProviderName() {
        return NAME;
    }

    public boolean allowWrite() {
        return this.shpFile.isEditable() && super.allowWrite() && !this.getShpParameters().getLoadCorruptGeometriesAsNull() && !this.getShpParameters().getAllowInconsistenciesInGeometryType() && !this.getShpParameters().getFixLinearRings();
    }

    protected FeatureProvider getFeatureProviderByIndex(long index, FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        this.open();
        try {
            FeatureProvider featureProvider = super.getFeatureProviderByIndex(index, providerFeatureType, storeFeatureType);
            featureProvider.setDefaultEnvelope(this.shpFile.getBoundingBox(index));
            return featureProvider;
        }
        catch (DataException e) {
            throw e;
        }
        catch (CreateEnvelopeException e) {
            throw new CreateGeometryException((Throwable)e);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new CreateGeometryException((Throwable)e);
        }
    }

    protected void initFeatureProviderByIndex(FeatureProvider featureProvider, long index, FeatureType featureType) throws DataException {
        try {
            super.initFeatureProviderByIndex(featureProvider, index, featureType);
            featureProvider.setDefaultEnvelope(this.shpFile.getBoundingBox(index));
        }
        catch (CreateEnvelopeException e) {
            throw new CreateGeometryException((Throwable)e);
        }
        catch (org.gvsig.fmap.geom.exception.CreateGeometryException e) {
            throw new CreateGeometryException((Throwable)e);
        }
    }

    protected void loadFeatureProviderByIndex(FeatureProvider featureProvider) throws DataException {
        FeatureType featureType = featureProvider.getType();
        long index = (Long)featureProvider.getOID();
        boolean hasGeometry = false;
        int i = featureType.getDefaultGeometryAttributeIndex();
        if (i >= 0) {
            if (!featureProvider.isReadOnly(i)) {
                Geometry geom;
                try {
                    geom = this.shpFile.getGeometry(index);
                }
                catch (Exception e) {
                    if (this.getShpParameters().getLoadCorruptGeometriesAsNull()) {
                        geom = null;
                    }
                    throw new ReadGeometryException(this.getName(), featureProvider.getOID(), e);
                }
                featureProvider.set(i, (Object)geom);
            }
            hasGeometry = true;
        }
        if (this.hasDBFAttributes(featureType, hasGeometry)) {
            super.loadFeatureProviderByIndex(featureProvider);
        }
    }

    private boolean hasDBFAttributes(FeatureType featureType, boolean hasGeometry) {
        FeatureAttributeDescriptor[] attributes = featureType.getAttributeDescriptors();
        if (attributes == null || attributes.length == 0) {
            return false;
        }
        return attributes.length != 1 || !hasGeometry;
    }

    protected void loadValue(DBFFeatureProvider featureProvider, long rowIndex, FeatureAttributeDescriptor descriptor) throws ReadException {
        if (descriptor.getType() != 66) {
            super.loadValue(featureProvider, rowIndex, descriptor);
        }
    }

    public FeatureProvider createFeatureProvider(FeatureType type) throws DataException {
        SHPFeatureProvider data = new SHPFeatureProvider(this, type, null);
        return data;
    }

    public FeatureProvider createFeatureProvider(FeatureType providerFeatureType, FeatureType storeFeatureType) throws DataException {
        return new SHPFeatureProvider(this, providerFeatureType, storeFeatureType);
    }

    protected void openFile() throws IOException, DataException {
        super.openFile();
        this.shpFile.open();
    }

    protected void closeFile() throws CloseException {
        super.closeFile();
        if (this.shpFile == null || !this.shpFile.isOpen()) {
            return;
        }
        this.shpFile.close();
    }

    public boolean canWriteGeometry(final int geometryType, int geometrySubType) throws DataException {
        this.open();
        return (Boolean)this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                boolean value = SHPStoreProvider.this.shpFile.canWriteGeometry(geometryType);
                return value ? Boolean.TRUE : Boolean.FALSE;
            }
        });
    }

    public void performChanges(Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator originalFeatureTypesUpdated) throws PerformEditingException {
        FeatureType fType;
        final ArrayList originalFeatureTypesUpdatedList = new ArrayList();
        while (originalFeatureTypesUpdated.hasNext()) {
            originalFeatureTypesUpdatedList.add(originalFeatureTypesUpdated.next());
        }
        this.checkNewFieldsNameSize(originalFeatureTypesUpdatedList.iterator());
        try {
            fType = this.getStoreServices().getDefaultFeatureType();
        }
        catch (DataException e) {
            throw new PerformEditingException(this.getProviderName(), (Throwable)e);
        }
        try {
            this.loTengoEnUso = true;
            this.resourceCloseRequest();
            this.getResource().execute(new ResourceAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Object run() throws Exception {
                    Object var9_9;
                    FeatureSet set = null;
                    DisposableIterator iter = null;
                    try {
                        File prjFile;
                        set = SHPStoreProvider.this.getFeatureStore().getFeatureSet();
                        SHPStoreProvider.this.writer = new SHPFeatureWriter(SHPStoreProvider.this.getProviderName());
                        SHPStoreParameters shpParams = SHPStoreProvider.this.getShpParameters();
                        SHPStoreParameters tmpParams = (SHPStoreParameters)shpParams.getCopy();
                        File tmp_base = File.createTempFile("tmp_" + System.currentTimeMillis(), null);
                        String str_base = tmp_base.getCanonicalPath();
                        tmpParams.setDBFFile(str_base + ".dbf");
                        tmpParams.setSHPFile(str_base + ".shp");
                        tmpParams.setSHXFile(str_base + ".shx");
                        SHPStoreProvider.this.writer.begin(tmpParams, fType, set.getSize());
                        iter = set.fastIterator();
                        while (iter.hasNext()) {
                            Feature feature = (Feature)iter.next();
                            SHPStoreProvider.this.writer.append(feature);
                        }
                        SHPStoreProvider.this.writer.end();
                        SHPStoreProvider.this.loTengoEnUso = false;
                        SHPStoreProvider.this.close();
                        if (!shpParams.getDBFFile().delete()) {
                            LOGGER.debug("Can't delete dbf file '" + shpParams.getDBFFile() + "'.");
                            throw new IOException("Can't delete dbf '" + FilenameUtils.getBaseName((String)shpParams.getDBFFileName()) + "' file to replace with the new dbf.\nThe new dbf is in temporary file '" + str_base + "'");
                        }
                        if (!shpParams.getSHPFile().delete()) {
                            LOGGER.debug("Can't delete dbf file '" + shpParams.getSHPFile() + "'.");
                            throw new IOException("Can't delete shp '" + FilenameUtils.getBaseName((String)shpParams.getSHPFileName()) + "' file to replace with the new shp.\nThe new shp is in temporary file '" + str_base + "'");
                        }
                        if (!shpParams.getSHXFile().delete()) {
                            LOGGER.debug("Can't delete dbf file '" + shpParams.getSHXFile() + "'.");
                            throw new IOException("Can't delete shx '" + FilenameUtils.getBaseName((String)shpParams.getSHXFileName()) + "' file to replace with the new shx.\nThe new shx is in temporary file '" + str_base + "'");
                        }
                        if (shpParams.getCPGFile().exists() && !shpParams.getCPGFile().delete()) {
                            LOGGER.debug("Can't delete cpg file '" + shpParams.getCPGFile() + "'.");
                            throw new IOException("Can't delete cpg '" + FilenameUtils.getBaseName((String)shpParams.getCPGFileName()) + "' file to replace with the new cpg.\nThe new cpg is in temporary file '" + str_base + "'");
                        }
                        IProjection proj = tmpParams.getCRS();
                        String export = proj.export("wkt_esri");
                        if (export != null && (prjFile = SHP.getPrjFile(shpParams.getSHPFile())).exists() && !prjFile.delete()) {
                            LOGGER.debug("Can't delete prj file '" + prjFile + "'.");
                            throw new IOException("Can't delete shx '" + FilenameUtils.getBaseName((String)prjFile.getPath()) + "' file to replace with the new shx.\nThe new shx is in temporary file '" + str_base + "'");
                        }
                        FileUtils.moveFile((File)tmpParams.getDBFFile(), (File)shpParams.getDBFFile());
                        FileUtils.moveFile((File)tmpParams.getSHPFile(), (File)shpParams.getSHPFile());
                        FileUtils.moveFile((File)tmpParams.getSHXFile(), (File)shpParams.getSHXFile());
                        FileUtils.moveFile((File)tmpParams.getCPGFile(), (File)shpParams.getCPGFile());
                        SHPStoreProvider.this.savePrjFile(shpParams.getFile(), proj);
                        SHPStoreProvider.this.resourcesNotifyChanges();
                        if (!originalFeatureTypesUpdatedList.isEmpty()) {
                            SHPStoreProvider.this.initFeatureType();
                        }
                        var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        SHPStoreProvider.this.loTengoEnUso = false;
                        SHPStoreProvider.this.dispose((Disposable)set);
                        SHPStoreProvider.this.dispose(iter);
                        throw throwable;
                    }
                    SHPStoreProvider.this.loTengoEnUso = false;
                    SHPStoreProvider.this.dispose((Disposable)set);
                    SHPStoreProvider.this.dispose((Disposable)iter);
                    return var9_9;
                }
            });
        }
        catch (Exception e) {
            throw new PerformEditingException(this.getProviderName(), (Throwable)e);
        }
    }

    protected void resourceCloseRequest() throws ResourceException {
        this.getResource().closeRequest();
    }

    public Envelope getEnvelope() throws DataException {
        this.open();
        return (Envelope)this.getDynValue("Envelope");
    }

    public void append(final FeatureProvider featureProvider) throws DataException {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                SHPStoreProvider.this.writer.append(SHPStoreProvider.this.getStoreServices().createFeature(featureProvider));
                return null;
            }
        });
    }

    public void beginAppend() throws DataException {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                FeatureStore store = SHPStoreProvider.this.getFeatureStore();
                FeatureType fType = store.getDefaultFeatureType();
                SHPStoreProvider.this.writer = new SHPFeatureWriter(SHPStoreProvider.this.getProviderName());
                SHPStoreProvider.this.writer.begin(SHPStoreProvider.this.getShpParameters(), fType, store.getFeatureCount());
                return null;
            }
        });
    }

    public void endAppend() throws DataException {
        this.getResource().execute(new ResourceAction(){

            public Object run() throws Exception {
                SHPStoreProvider.this.writer.end();
                SHPStoreProvider.this.close();
                SHPStoreParameters shpParameters = SHPStoreProvider.this.getShpParameters();
                SHPStoreProvider.this.savePrjFile(shpParameters.getFile(), shpParameters.getCRS());
                SHPStoreProvider.this.resourcesNotifyChanges();
                return null;
            }
        });
    }

    public Object getSourceId() {
        return this.getShpParameters().getFile();
    }

    public void fixFeatureTypeFromParameters() {
        try {
            super.fixFeatureTypeFromParameters();
            FeatureStoreProviderServices store = this.getStoreServices();
            FeatureType ft = store.getDefaultFeatureType();
            FeatureAttributeDescriptor geomAttr = ft.getDefaultGeometryAttribute();
            GeometryType geomType = geomAttr.getGeomType();
            if (geomType.getType() != this.shpFile.getGeometryType() || geomType.getSubType() != this.shpFile.getGeometrySubType()) {
                EditableFeatureType eft = ft.getEditable();
                EditableFeatureAttributeDescriptor geomEditableAttr = (EditableFeatureAttributeDescriptor)eft.getDefaultGeometryAttribute();
                geomEditableAttr.setGeometryType(this.shpFile.getGeometryType(), this.shpFile.getGeometrySubType());
                this.setStoreFeatureType(eft.getNotEditableCopy());
            }
        }
        catch (DataException ex) {
            LOGGER.warn("Can't fix feture type.", (Throwable)ex);
        }
    }

    public class ReadGeometryException
    extends ReadException {
        private static final String MESSAGE_FORMAT = "There was errors loading a geometry from '%(store)'.\nCheck 'Load corrupt geometries as null' in the shape's properties of the add layer dialog to skip corrupt geometries. The layer will become read only.";
        private static final String MESSAGE_KEY = "_ReadGeometryException";
        private static final long serialVersionUID = 2626155328734197112L;

        public ReadGeometryException(String store, Object oid, Throwable cause) {
            super(MESSAGE_FORMAT, cause, MESSAGE_KEY, 2626155328734197112L);
            this.setValue("store", store);
            this.setValue("storeParameters", (Object)SHPStoreProvider.this.getParameters());
        }
    }
}

