/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.io.File;
import org.gvsig.fmap.dal.store.shp.utils.MyFileFilter;
import org.gvsig.fmap.dal.store.shp.utils.SHPMultiLine2DMWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPMultiLine2DWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPMultiLine3DWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPMultiPointWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPNullWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPPointWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPPolygon2DMWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPPolygon2DWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPPolygon3DWriter;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;

public class SHP {
    public static final int NULL = 0;
    public static final int POINT2D = 1;
    public static final int POLYLINE2D = 3;
    public static final int POLYGON2D = 5;
    public static final int MULTIPOINT2D = 8;
    public static final int POINT3D = 11;
    public static final int POLYLINE3D = 13;
    public static final int POLYGON3D = 15;
    public static final int MULTIPOINT3D = 18;
    public static final int POINTM = 21;
    public static final int POLYLINEM = 23;
    public static final int POLYGONM = 25;
    public static final int MULTIPOINTM = 28;

    public static SHPShapeWriter create(int type) {
        SHPShapeWriter writer;
        switch (type) {
            case 0: {
                writer = new SHPNullWriter();
                break;
            }
            case 1: 
            case 11: 
            case 21: {
                writer = new SHPPointWriter(type);
                break;
            }
            case 3: {
                writer = new SHPMultiLine2DWriter();
                break;
            }
            case 13: {
                writer = new SHPMultiLine3DWriter();
                break;
            }
            case 23: {
                writer = new SHPMultiLine2DMWriter();
                break;
            }
            case 5: {
                writer = new SHPPolygon2DWriter();
                break;
            }
            case 15: {
                writer = new SHPPolygon3DWriter();
                break;
            }
            case 25: {
                writer = new SHPPolygon2DMWriter();
                break;
            }
            case 8: 
            case 18: 
            case 28: {
                writer = new SHPMultiPointWriter(type);
                break;
            }
            default: {
                writer = null;
            }
        }
        return writer;
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "NULL";
            }
            case 1: {
                return "POINT2D";
            }
            case 11: {
                return "POINT3D";
            }
            case 21: {
                return "POINTM";
            }
            case 3: {
                return "POLYLINE2D";
            }
            case 13: {
                return "POLYLINE3D";
            }
            case 23: {
                return "POLYLINEM";
            }
            case 5: {
                return "POLYGON2D";
            }
            case 15: {
                return "POLYGON3D";
            }
            case 25: {
                return "POLYGONM";
            }
            case 8: {
                return "MULTIPOINT2D";
            }
            case 18: {
                return "MULTIPOINT3D";
            }
            case 28: {
                return "MULTIPOINTM";
            }
        }
        return Integer.toString(type);
    }

    public static double[] getZMinMax(double[] zs) {
        if (zs == null) {
            return null;
        }
        double min = Double.MAX_VALUE;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < zs.length; ++i) {
            if (zs[i] > max) {
                max = zs[i];
            }
            if (!(zs[i] < min)) continue;
            min = zs[i];
        }
        return new double[]{min, max};
    }

    public static File getDbfFile(File shpFile) {
        String str = shpFile.getAbsolutePath();
        File directory = shpFile.getParentFile();
        File[] files = new File[]{};
        if (directory != null) {
            MyFileFilter myFileFilter = new MyFileFilter(str);
            files = directory.listFiles(myFileFilter);
        }
        String[] ends = new String[]{"dbf", "DBF", "Dbf", "dBf", "DBf", "dbF", "DbF", "dBF"};
        File dbfFile = SHP.findEnd(str, files, ends);
        return dbfFile;
    }

    public static File getShpFile(File dbfFile) {
        String str = dbfFile.getAbsolutePath();
        File directory = dbfFile.getParentFile();
        File[] files = new File[]{};
        if (directory != null) {
            MyFileFilter myFileFilter = new MyFileFilter(str);
            files = directory.listFiles(myFileFilter);
        }
        String[] ends = new String[]{"shp", "SHP", "Shp", "sHp", "SHp", "shP", "ShP", "sHP"};
        File shpFile = SHP.findEnd(str, files, ends);
        return shpFile;
    }

    public static File getShxFile(File shpFile) {
        String str = shpFile.getAbsolutePath();
        File directory = shpFile.getParentFile();
        File[] files = new File[]{};
        if (directory != null) {
            MyFileFilter myFileFilter = new MyFileFilter(str);
            files = directory.listFiles(myFileFilter);
        }
        String[] ends = new String[]{"shx", "SHX", "Shx", "sHx", "SHx", "shX", "ShX", "sHX"};
        File shxFile = SHP.findEnd(str, files, ends);
        return shxFile;
    }

    public static File getPrjFile(File shpFile) {
        String str = shpFile.getAbsolutePath();
        File directory = shpFile.getParentFile();
        File[] files = new File[]{};
        if (directory != null) {
            MyFileFilter myFileFilter = new MyFileFilter(str);
            files = directory.listFiles(myFileFilter);
        }
        String[] ends = new String[]{"prj", "PRJ", "Prj", "pRj", "PRj", "prJ", "PrJ", "pRJ"};
        File prjFile = SHP.findEnd(str, files, ends);
        return prjFile;
    }

    private static File findEnd(String str, File[] files, String[] ends) {
        if (files != null) {
            File dbfFile;
            int i;
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[0])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[1])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[2])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[3])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[4])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[5])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[6])) continue;
                return dbfFile;
            }
            for (i = 0; i < files.length; ++i) {
                dbfFile = files[i];
                if (!dbfFile.getAbsolutePath().endsWith(ends[7])) continue;
                return dbfFile;
            }
        }
        return new File(SHP.removeExtension(str) + "." + ends[0]);
    }

    private static String removeExtension(String fname) {
        int i = fname.lastIndexOf(".");
        if (i < 0) {
            return fname;
        }
        return fname.substring(0, i);
    }
}

