/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import org.gvsig.fmap.dal.store.shp.utils.SHP;
import org.gvsig.fmap.dal.store.shp.utils.SHPShape;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPMultiPoint
implements SHPShape {
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(SHPMultiPoint.class);
    private int m_type;
    private int numpoints;
    private Point2D[] points;
    private double[] zs;

    public SHPMultiPoint() {
        this.m_type = 8;
    }

    public SHPMultiPoint(int type) {
        if (type == 8 || type == 28 || type != 18) {
            // empty if block
        }
        this.m_type = type;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Override
    public Geometry read(MappedByteBuffer buffer, int type) {
        double minX = buffer.getDouble();
        double minY = buffer.getDouble();
        double maxX = buffer.getDouble();
        double maxY = buffer.getDouble();
        Rectangle2D.Double rec = new Rectangle2D.Double(minX, minY, maxX - minX, maxY - maxY);
        int numpoints = buffer.getInt();
        Point[] p = new Point[numpoints];
        for (int t = 0; t < numpoints; ++t) {
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            try {
                p[t] = geomManager.createPoint(x, y, 0);
                continue;
            }
            catch (CreateGeometryException e) {
                logger.error("Error creating a point", (Throwable)e);
            }
        }
        MultiPoint multipoint = null;
        try {
            multipoint = (MultiPoint)geomManager.create(7, 0);
            for (int i = 0; i < p.length; ++i) {
                multipoint.addPoint(p[i]);
            }
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the multipoint", (Throwable)e);
        }
        return multipoint;
    }

    @Override
    public void write(ByteBuffer buffer, Geometry geometry) {
        int t;
        Envelope env = geometry.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        buffer.putInt(this.numpoints);
        int tt = this.numpoints;
        for (t = 0; t < tt; ++t) {
            Point2D point = this.points[t];
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
        }
        if (this.m_type == 18) {
            double[] zExtreame = SHP.getZMinMax(this.zs);
            if (Double.isNaN(zExtreame[0])) {
                buffer.putDouble(0.0);
                buffer.putDouble(0.0);
            } else {
                buffer.putDouble(zExtreame[0]);
                buffer.putDouble(zExtreame[1]);
            }
            for (int t2 = 0; t2 < this.numpoints; ++t2) {
                double z = this.zs[t2];
                if (Double.isNaN(z)) {
                    buffer.putDouble(0.0);
                    continue;
                }
                buffer.putDouble(z);
            }
        }
        if (this.m_type == 28 || this.m_type == 18) {
            buffer.putDouble(-1.0E41);
            buffer.putDouble(-1.0E41);
            for (t = 0; t < this.numpoints; ++t) {
                buffer.putDouble(-1.0E41);
            }
        }
    }

    @Override
    public int getLength(Geometry fgeometry) {
        int length;
        if (this.m_type == 8) {
            length = this.numpoints * 16 + 40;
        } else if (this.m_type == 28) {
            length = this.numpoints * 16 + 40 + 16 + 8 * this.numpoints;
        } else if (this.m_type == 18) {
            length = this.numpoints * 16 + 40 + 16 + 8 * this.numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Arc, got " + this.m_type);
        }
        return length;
    }

    @Override
    public void obtainsPoints(Geometry g) {
        if (18 == this.m_type) {
            MultiPoint multipoint = (MultiPoint)g;
            this.zs = new double[multipoint.getPrimitivesNumber()];
            for (int i = 0; i < this.zs.length; ++i) {
                this.zs[i] = multipoint.getPointAt(i).getCoordinateAt(2);
            }
        }
        PathIterator theIterator = g.getPathIterator(null);
        double[] theData = new double[6];
        ArrayList<Point2D.Double> ps = new ArrayList<Point2D.Double>();
        while (!theIterator.isDone()) {
            theIterator.currentSegment(theData);
            ps.add(new Point2D.Double(theData[0], theData[1]));
            theIterator.next();
        }
        this.points = ps.toArray(new Point2D.Double[0]);
        this.numpoints = this.points.length;
    }
}

