/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.ArrayList;
import org.gvsig.fmap.dal.store.shp.utils.SHPShapeWriter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Point;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SHPMultiPointWriter
implements SHPShapeWriter {
    private static final Logger logger = LoggerFactory.getLogger(SHPMultiPointWriter.class);
    private int m_type;
    private MultiPoint multipoint;
    private int numpoints;

    public SHPMultiPointWriter(int type) {
        this.m_type = type;
    }

    @Override
    public int getShapeType() {
        return this.m_type;
    }

    @Deprecated
    public Geometry read(MappedByteBuffer buffer, int type) {
        return null;
    }

    @Override
    public void write(ByteBuffer buffer) {
        Envelope env = this.multipoint.getEnvelope();
        buffer.putDouble(env.getMinimum(0));
        buffer.putDouble(env.getMinimum(1));
        buffer.putDouble(env.getMaximum(0));
        buffer.putDouble(env.getMaximum(1));
        buffer.putInt(this.numpoints);
        for (int i = 0; i < this.numpoints; ++i) {
            Point point = (Point)this.multipoint.getPrimitiveAt(i);
            buffer.putDouble(point.getX());
            buffer.putDouble(point.getY());
        }
        if (this.m_type == 18) {
            this.putExtraCoordinateValuesInBuffer(buffer, 2);
            this.putExtraCoordinateValuesInBuffer(buffer, this.multipoint.getDimension() - 1);
        }
        if (this.m_type == 28) {
            this.putExtraCoordinateValuesInBuffer(buffer, this.multipoint.getDimension() - 1);
        }
    }

    private void putExtraCoordinateValuesInBuffer(ByteBuffer buffer, int coordinate) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < this.numpoints; ++i) {
            Point point = (Point)this.multipoint.getPrimitiveAt(i);
            double value = point.getCoordinateAt(coordinate);
            if (value < min) {
                min = value;
            }
            if (value > max) {
                max = value;
            }
            values.add(value);
        }
        buffer.putDouble(min);
        buffer.putDouble(max);
        for (Double value : values) {
            buffer.putDouble(value);
        }
    }

    @Override
    public int getLength() {
        int length;
        if (this.m_type == 8) {
            length = this.numpoints * 16 + 40;
        } else if (this.m_type == 28) {
            length = this.numpoints * 16 + 40 + 16 + 8 * this.numpoints;
        } else if (this.m_type == 18) {
            length = this.numpoints * 16 + 40 + 16 + 8 * this.numpoints + 16 + 8 * this.numpoints;
        } else {
            throw new IllegalStateException("Expected ShapeType of Multipoint, got " + this.m_type);
        }
        return length;
    }

    @Override
    public void initialize(Geometry geometry) throws GeometryException {
        this.multipoint = (MultiPoint)geometry;
        this.numpoints = this.multipoint.getPrimitivesNumber();
    }
}

