/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.shp.utils;

import java.nio.ByteOrder;
import org.gvsig.fmap.dal.store.shp.SHPStoreParameters;
import org.gvsig.fmap.dal.store.shp.utils.AbstractSHPReader;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPoint;
import org.gvsig.fmap.geom.aggregate.MultiPolygon;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Ring;
import org.gvsig.utils.bigfile.BigByteBuffer2;

public class SHPReader2D
extends AbstractSHPReader {
    public SHPReader2D(SHPStoreParameters params) {
        super(params);
    }

    @Override
    public Geometry readPoint(BigByteBuffer2 bb) throws CreateGeometryException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        bb.order(ByteOrder.LITTLE_ENDIAN);
        double x = bb.getDouble();
        double y = bb.getDouble();
        Point p = (Point)gManager.create(1, 0);
        p.setX(x);
        p.setY(y);
        return p;
    }

    @Override
    public Geometry readPoLyline(BigByteBuffer2 bb) throws CreateGeometryException {
        int i;
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        Point p = null;
        bb.position(bb.position() + 32L);
        int numParts = bb.getInt();
        int numPoints = bb.getInt();
        int[] tempParts = new int[numParts];
        MultiLine multiLine = null;
        Line line = null;
        if (numParts > 1) {
            multiLine = (MultiLine)gManager.create(21, 0);
        }
        for (i = 0; i < numParts; ++i) {
            tempParts[i] = bb.getInt();
        }
        int j = 0;
        for (i = 0; i < numPoints; ++i) {
            p = (Point)this.readPoint(bb);
            if (i == tempParts[j]) {
                if (multiLine != null && line != null) {
                    multiLine.addCurve(line);
                }
                line = (Line)gManager.create(18, 0);
                if (j < numParts - 1) {
                    ++j;
                }
            }
            line.addVertex(p);
        }
        this.checkNumVerticesOfLine(line);
        if (multiLine != null) {
            multiLine.addCurve(line);
            return multiLine;
        }
        return line;
    }

    @Override
    public Geometry readPoLygon(BigByteBuffer2 bb) throws CreateGeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        Point p = null;
        bb.position(bb.position() + 32L);
        int numParts = bb.getInt();
        int numPoints = bb.getInt();
        int[] tempParts = new int[numParts];
        for (int i = 0; i < numParts; ++i) {
            tempParts[i] = bb.getInt();
        }
        MultiPolygon multipolygon = null;
        Polygon polygon = null;
        Ring ring = null;
        int pointsCounter = 0;
        for (int part = 0; part < numParts; ++part) {
            int v;
            ring = (Ring)gManager.create(20, 0);
            int lastPoint = numPoints;
            if (part < numParts - 1) {
                lastPoint = tempParts[part + 1];
            }
            while (pointsCounter < lastPoint) {
                p = (Point)this.readPoint(bb);
                ring.addVertex(p);
                ++pointsCounter;
            }
            ring.closePrimitive();
            this.checkNumVerticesOfRing(ring);
            if (ring.isCCW() && polygon != null) {
                polygon.addInteriorRing(ring);
                continue;
            }
            if (polygon != null) {
                if (multipolygon == null) {
                    multipolygon = (MultiPolygon)gManager.create(22, 0);
                }
                multipolygon.addPrimitive(polygon);
            }
            polygon = (Polygon)gManager.create(19, 0);
            polygon.ensureCapacity(ring.getNumVertices());
            if (ring.isCCW()) {
                for (v = ring.getNumVertices() - 1; v >= 0; --v) {
                    polygon.addVertex(ring.getVertex(v));
                }
                continue;
            }
            for (v = 0; v < ring.getNumVertices(); ++v) {
                polygon.addVertex(ring.getVertex(v));
            }
        }
        if (multipolygon != null) {
            multipolygon.addPrimitive(polygon);
            return multipolygon;
        }
        return polygon;
    }

    @Override
    public Geometry readMultiPoint(BigByteBuffer2 bb) throws CreateGeometryException {
        GeometryManager gManager = GeometryLocator.getGeometryManager();
        bb.position(bb.position() + 32L);
        int numPoints = bb.getInt();
        MultiPoint multipoint = gManager.createMultiPoint(0);
        for (int i = 0; i < numPoints; ++i) {
            multipoint.addPoint((Point)this.readPoint(bb));
        }
        return multipoint;
    }
}

