/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc;

import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.store.db.AbstractDBNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;

public class JDBCNewStoreParametersBase
extends AbstractDBNewStoreParameters
implements JDBCNewStoreParameters {
    public JDBCNewStoreParametersBase() {
        super("JDBC2NewStoreParameters", "JDBC2");
    }

    protected JDBCNewStoreParametersBase(String parametersDefinitionName, String providerName) {
        super(parametersDefinitionName, providerName);
    }

    public void setJDBCDriverClassName(String className) {
        this.setDynValue("jdbcdriverclass", className);
    }

    public String getJDBCDriverClassName() {
        return (String)this.getDynValue("jdbcdriverclass");
    }

    public String getCatalog() {
        return (String)this.getDynValue("catalog");
    }

    public void setCatalog(String catalog) {
        this.setDynValue("catalog", catalog);
    }

    public String getSchema() {
        return (String)this.getDynValue("schema");
    }

    public void setSchema(String schema) {
        this.setDynValue("schema", schema);
    }

    public String getUrl() {
        return (String)this.getDynValue("url");
    }

    public int getBatchSize() {
        try {
            return (Integer)this.getDynValue("batchSize");
        }
        catch (Exception ex) {
            return 500;
        }
    }

    public void setUrl(String url) {
        this.setDynValue("url", url);
    }

    public String tableID() {
        if (this.getSchema() == null || this.getSchema() == "") {
            return this.escapeName(this.getTable());
        }
        return this.escapeName(this.getSchema()) + "." + this.escapeName(this.getTable());
    }

    protected String escapeName(String name) {
        return "\"".concat(name).concat("\"");
    }

    public String getSelectRole() {
        String value = (String)this.getDynValue("SelectRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getInsertRole() {
        String value = (String)this.getDynValue("InsertRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getUpdateRole() {
        String value = (String)this.getDynValue("UpdateRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getDeleteRole() {
        String value = (String)this.getDynValue("DeleteRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getTruncateRole() {
        String value = (String)this.getDynValue("TruncateRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getReferenceRole() {
        String value = (String)this.getDynValue("ReferenceRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getTriggerRole() {
        String value = (String)this.getDynValue("TriggerRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getAllRole() {
        String value = (String)this.getDynValue("AllRole");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public String getPostCreatingStatement() {
        String value = (String)this.getDynValue("PostCreatingStatement");
        return (String)StringUtils.defaultIfBlank((CharSequence)value, null);
    }

    public void setSelectRole(String role) {
        this.setDynValue("SelectRole", role);
    }

    public void setInsertRole(String role) {
        this.setDynValue("InsertRole", role);
    }

    public void setUpdateRole(String role) {
        this.setDynValue("UpdateRole", role);
    }

    public void setDeleteRole(String role) {
        this.setDynValue("DeleteRole", role);
    }

    public void setTruncateRole(String role) {
        this.setDynValue("TruncateRole", role);
    }

    public void setReferenceRole(String role) {
        this.setDynValue("ReferenceRole", role);
    }

    public void setTriggerRole(String role) {
        this.setDynValue("TriggerRole", role);
    }

    public void setAllRole(String role) {
        this.setDynValue("AllRole", role);
    }

    public void setPostCreatingStatement(String statement) {
        this.setDynValue("PostCreatingStatement", statement);
    }
}

