/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCUtils.class);

    private JDBCUtils() {
    }

    private static String getSQLInfo(PreparedStatement st, String sql) {
        try {
            return sql + " [[ " + Objects.toString(st) + " ]]";
        }
        catch (Throwable th) {
            return sql;
        }
    }

    public static String getConnId(Statement st) {
        if (st == null) {
            return "null";
        }
        try {
            return JDBCUtils.getHexId(st.getConnection());
        }
        catch (SQLException ex) {
            return "null";
        }
    }

    public static String getConnId(ResultSet resulSet) {
        if (resulSet == null) {
            return "null";
        }
        try {
            return JDBCUtils.getConnId(resulSet.getStatement());
        }
        catch (SQLException ex) {
            return "null";
        }
    }

    public static String getConnId(Connection conn) {
        return JDBCUtils.getHexId(conn);
    }

    public static String getHexId(Object obj) {
        if (obj == null) {
            return "null";
        }
        return Integer.toHexString(obj.hashCode()).toUpperCase();
    }

    public static ResultSet executeQuery(Statement st, String sql) throws SQLException {
        try {
            ResultSet rs;
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                rs = st.executeQuery(sql);
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] executeQuery(st) " + (t2 - t1) + "ms SQL= " + sql);
            } else {
                rs = st.executeQuery(sql);
            }
            return rs;
        }
        catch (Exception ex) {
            LOGGER.debug("execute SQL: " + sql, (Throwable)ex);
            throw ex;
        }
    }

    public static void execute(Statement st, String sql) throws SQLException {
        try {
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                st.execute(sql);
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] execute(st) " + (t2 - t1) + "ms SQL: " + sql);
            } else {
                st.execute(sql);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("execute SQL: " + sql, (Throwable)ex);
            throw ex;
        }
    }

    public static void execute(Connection connection, String sql) throws SQLException {
        try {
            Statement st = connection.createStatement();
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                st.execute(sql);
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(connection) + "] execute(conn) " + (t2 - t1) + "ms SQL: " + sql);
            } else {
                st.execute(sql);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("execute SQL: " + sql, (Throwable)ex);
            throw ex;
        }
    }

    public static void execute(Connection connection, List<String> sqls) throws SQLException {
        Statement st = null;
        String sql2 = null;
        try {
            st = connection.createStatement();
            for (String sql2 : sqls) {
                if (LOGGER.isDebugEnabled()) {
                    long t1 = System.currentTimeMillis();
                    st.execute(sql2);
                    long t2 = System.currentTimeMillis();
                    LOGGER.debug("[" + JDBCUtils.getConnId(connection) + "] execute(conn, sqls) " + (t2 - t1) + "ms SQLs: " + sql2);
                    continue;
                }
                st.execute(sql2);
            }
        }
        catch (SQLException ex) {
            LOGGER.debug("execute SQL: " + sql2, (Throwable)ex);
            throw ex;
        }
        finally {
            JDBCUtils.closeQuietly(st);
        }
    }

    public static ResultSet executeQuery(PreparedStatement st, String sql) throws SQLException {
        try {
            ResultSet rs;
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                rs = st.executeQuery();
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] executeQuery(pst) " + (t2 - t1) + "ms SQL= " + JDBCUtils.getSQLInfo(st, sql));
            } else {
                rs = st.executeQuery();
            }
            return rs;
        }
        catch (Exception ex) {
            LOGGER.debug("execute query SQL: " + JDBCUtils.getSQLInfo(st, sql), (Throwable)ex);
            throw new SQLException(ex.getMessage() + JDBCUtils.getSQLInfo(st, sql), ex);
        }
    }

    public static void execute(PreparedStatement st, String sql) throws SQLException {
        try {
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                st.execute();
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] execute(pst) " + (t2 - t1) + "ms SQL= " + JDBCUtils.getSQLInfo(st, sql));
            } else {
                st.execute();
            }
        }
        catch (Exception ex) {
            LOGGER.debug("execute SQL: " + JDBCUtils.getSQLInfo(st, sql), (Throwable)ex);
            throw new SQLException(ex.getMessage() + JDBCUtils.getSQLInfo(st, sql), ex);
        }
    }

    public static int executeUpdate(PreparedStatement st, String sql) throws SQLException {
        try {
            int r;
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                r = st.executeUpdate();
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] executeUpdate(pst) " + (t2 - t1) + "ms SQL= " + JDBCUtils.getSQLInfo(st, sql));
            } else {
                r = st.executeUpdate();
            }
            return r;
        }
        catch (Exception ex) {
            LOGGER.debug("execute update SQL: " + JDBCUtils.getSQLInfo(st, sql), (Throwable)ex);
            throw new SQLException(ex.getMessage() + JDBCUtils.getSQLInfo(st, sql), ex);
        }
    }

    public static int executeUpdate(Statement st, String sql) throws SQLException {
        try {
            int r;
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                r = st.executeUpdate(sql);
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] executeUpdate(st) " + (t2 - t1) + "ms SQL= " + sql);
            } else {
                r = st.executeUpdate(sql);
            }
            return r;
        }
        catch (Exception ex) {
            LOGGER.debug("execute update SQL: " + sql, (Throwable)ex);
            throw ex;
        }
    }

    public static int[] executeBatch(PreparedStatement st, String sql) throws SQLException {
        try {
            int[] r;
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                r = st.executeBatch();
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] executeBatch(pst) " + (t2 - t1) + "ms SQL= " + JDBCUtils.getSQLInfo(st, sql));
            } else {
                r = st.executeBatch();
            }
            return r;
        }
        catch (Exception ex) {
            LOGGER.debug("execute batch SQL: " + JDBCUtils.getSQLInfo(st, sql), (Throwable)ex);
            throw ex;
        }
    }

    public static void addBatch(PreparedStatement st, String sql) throws SQLException {
        try {
            if (LOGGER.isDebugEnabled()) {
                long t1 = System.currentTimeMillis();
                st.addBatch();
                long t2 = System.currentTimeMillis();
                LOGGER.debug("[" + JDBCUtils.getConnId(st) + "] addBatch(pst) " + (t2 - t1) + "ms SQL= " + JDBCUtils.getSQLInfo(st, sql));
            } else {
                st.addBatch();
            }
        }
        catch (Exception ex) {
            LOGGER.debug("add batch SQL: " + JDBCUtils.getSQLInfo(st, sql), (Throwable)ex);
            throw ex;
        }
    }

    public static void closeQuietly(Statement st) {
        if (st == null) {
            return;
        }
        try {
            st.close();
        }
        catch (Exception e) {
            LOGGER.debug("Problems closing " + st.getClass().getSimpleName() + " '" + st.toString() + "'.", (Throwable)e);
        }
    }

    public static void closeQuietly(ResultSet resulSet) {
        if (resulSet == null) {
            return;
        }
        try {
            resulSet.close();
        }
        catch (Exception e) {
            LOGGER.debug("Problems closing " + resulSet.getClass().getSimpleName() + " '" + resulSet.toString() + "'.", (Throwable)e);
        }
    }

    public static void closeQuietly(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            LOGGER.debug("Problems closing " + conn.getClass().getSimpleName() + " '" + conn.toString() + "'.", (Throwable)e);
        }
    }

    public static void close(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeQuietly(AutoCloseable obj) {
        if (obj == null) {
            return;
        }
        try {
            obj.close();
        }
        catch (Exception e) {
            LOGGER.debug("Problems closing " + obj.getClass().getSimpleName() + " '" + obj.toString() + "'.", (Throwable)e);
        }
    }
}

