/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCExecutePreparedSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.ResulSetControler;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.tools.dispose.Disposable;
import org.gvsig.tools.dispose.DisposeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResulSetControlerBase
implements ResulSetControler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResulSetControlerBase.class);
    private int nextid = 1;
    private final Map<Integer, ResultSetEntryBase> resulSets;
    private long mlsecondsToZombie = 600000L;
    private JDBCHelper helper = null;

    public ResulSetControlerBase(JDBCHelper helper) {
        this.helper = helper;
        this.resulSets = new HashMap<Integer, ResultSetEntryBase>();
        this.nextid = 1;
    }

    @Override
    public long getTimeToZombie() {
        return this.mlsecondsToZombie;
    }

    @Override
    public void setTimeToZombie(long mlSeconds) {
        this.mlsecondsToZombie = mlSeconds;
    }

    @Override
    public void close() throws Exception {
        this.closeAll();
        this.helper = null;
        this.resulSets.clear();
        this.nextid = -10;
    }

    @Override
    public ResultSetEntryBase create(String sql, int fetchSize, FeatureAttributeDescriptor[] columns, String[] extraValueNames) throws DataException {
        return this.create(sql, (List)null, fetchSize, columns, extraValueNames);
    }

    @Override
    public synchronized ResultSetEntryBase create(String sql, List<Object> values, int fetchSize, FeatureAttributeDescriptor[] columns, String[] extraValueNames) throws DataException {
        ResultSetEntryBase resultSetEntryBase;
        this.pack();
        ResultSet rs = null;
        JDBCConnection conn = null;
        PreparedStatement st = null;
        Disposable paramsDisposer = null;
        try {
            ResultSetEntryBase rsentry;
            conn = this.helper.getConnection();
            conn.begin();
            st = conn.prepareStatement(sql);
            JDBCSQLBuilderBase sqlbuilder = this.helper.createSQLBuilder();
            paramsDisposer = sqlbuilder.setStatementParameters(st, values, this.helper.getGeometrySupportType());
            if (fetchSize > 0) {
                st.setFetchSize(fetchSize);
            }
            rs = JDBCUtils.executeQuery(st, sql);
            if (fetchSize > 0) {
                rs.setFetchSize(fetchSize);
            }
            resultSetEntryBase = rsentry = new ResultSetEntryBase(conn, rs, sql, columns, extraValueNames);
        }
        catch (SQLException e) {
            try {
                JDBCUtils.closeQuietly(rs);
                JDBCUtils.closeQuietly(st);
                JDBCConnection.closeQuietly((JDBCConnection)conn);
                conn.closeQuietly();
                throw new JDBCExecutePreparedSQLException(sql, values, e);
            }
            catch (Throwable throwable) {
                DisposeUtils.disposeQuietly(paramsDisposer);
                throw throwable;
            }
        }
        DisposeUtils.disposeQuietly((Disposable)paramsDisposer);
        return resultSetEntryBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ResultSetEntryBase> getResultSetValues() {
        Map<Integer, ResultSetEntryBase> map = this.resulSets;
        synchronized (map) {
            ArrayList<ResultSetEntryBase> values = new ArrayList<ResultSetEntryBase>();
            values.addAll(this.resulSets.values());
            return values;
        }
    }

    @Override
    public synchronized void closeAll() {
        List<ResultSetEntryBase> values = this.getResultSetValues();
        for (ResultSetEntryBase entry : values) {
            JDBCUtils.closeQuietly(entry);
        }
    }

    @Override
    public synchronized void pack() {
        List<ResultSetEntryBase> values = this.getResultSetValues();
        int maxID = 0;
        for (ResultSetEntryBase entry : values) {
            if (entry.isZombie()) {
                JDBCUtils.closeQuietly(entry);
                continue;
            }
            if (entry.getID() <= maxID) continue;
            maxID = entry.getID();
        }
        this.nextid = maxID + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getOpenCount() {
        Map<Integer, ResultSetEntryBase> map = this.resulSets;
        synchronized (map) {
            return this.resulSets.size();
        }
    }

    public class ResultSetEntryBase
    implements ResulSetControler.ResultSetEntry {
        private ResultSet resultSet = null;
        private final int id;
        private long lastUse = 0L;
        private final String sql;
        private final FeatureAttributeDescriptor[] columns;
        private final String[] extraValueNames;
        private Throwable closeCause;
        private final String connId;
        private final String hexId;
        private final JDBCConnection conn;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResultSetEntryBase(JDBCConnection conn, ResultSet resulSet, String sql, FeatureAttributeDescriptor[] columns, String[] extraValueNames) {
            this.conn = conn;
            this.closeCause = null;
            this.resultSet = resulSet;
            this.connId = JDBCUtils.getConnId(this.resultSet);
            this.hexId = JDBCUtils.getHexId(this);
            this.id = ResulSetControlerBase.this.nextid++;
            this.sql = sql;
            this.columns = columns;
            this.extraValueNames = extraValueNames;
            this.used();
            Map map = ResulSetControlerBase.this.resulSets;
            synchronized (map) {
                ResulSetControlerBase.this.resulSets.put(this.getID(), this);
            }
        }

        private void used() {
            this.lastUse = System.currentTimeMillis();
        }

        @Override
        public ResultSet get() {
            this.used();
            return this.resultSet;
        }

        @Override
        public int getID() {
            return this.id;
        }

        @Override
        public boolean isZombie() {
            if (this.resultSet == null) {
                return true;
            }
            return System.currentTimeMillis() - this.lastUse > ResulSetControlerBase.this.mlsecondsToZombie;
        }

        @Override
        public String getSQL() {
            return this.sql;
        }

        @Override
        public String[] getExtraValueNames() {
            return this.extraValueNames;
        }

        @Override
        public FeatureAttributeDescriptor[] getColumns() {
            return this.columns;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            this.used();
            return this.resultSet.getObject(columnIndex);
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            this.used();
            return this.resultSet.getBytes(columnIndex);
        }

        @Override
        public boolean next() throws SQLException {
            if (this.closeCause != null) {
                LOGGER.debug("[" + this.connId + "] ResultSetEntryBase already closed " + this.hexId);
                throw new IllegalStateException("ResultSetEntryBase already closed, connId=" + this.connId + ", id=" + this.hexId + " (sql=" + this.sql + ")", this.closeCause);
            }
            return this.resultSet.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws Exception {
            if (this.resultSet == null) {
                return;
            }
            this.closeCause = new Throwable();
            Statement st = null;
            try {
                Map map = ResulSetControlerBase.this.resulSets;
                synchronized (map) {
                    ResulSetControlerBase.this.resulSets.remove(this.getID());
                }
                st = this.resultSet.getStatement();
            }
            catch (Exception ex) {
                LOGGER.warn("Problems closing ResulSetEntryBase.", (Throwable)ex);
            }
            JDBCUtils.closeQuietly(this.resultSet);
            JDBCUtils.closeQuietly(st);
            this.conn.closeQuietly();
            this.resultSet = null;
            ResulSetControlerBase.this.pack();
        }
    }
}

