/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.expressionbuilder.formatters;

import org.gvsig.expressionevaluator.Code;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.Formatter;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.expressionevaluator.FeatureAttributeEmulatorExpression;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureAttributeEmulator;
import org.gvsig.fmap.dal.feature.FeatureExtraColumns;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;

public class ComputedAttribute
implements Formatter<ExpressionBuilder.Value> {
    private final SQLBuilder sqlbuilder;
    private final Formatter<ExpressionBuilder.Value> formatter;

    public ComputedAttribute(SQLBuilder sqlbuilder, Formatter<ExpressionBuilder.Value> formatter) {
        this.sqlbuilder = sqlbuilder;
        this.formatter = formatter;
    }

    public boolean canApply(ExpressionBuilder.Value value) {
        if (value instanceof SQLBuilder.SelectColumnBuilder) {
            return false;
        }
        FeatureAttributeDescriptor attr = this.getFeatureAttributeDescriptor(value);
        if (attr == null) {
            return false;
        }
        if (!attr.isComputed()) {
            return false;
        }
        FeatureAttributeEmulator emulator = attr.getFeatureAttributeEmulator();
        return emulator instanceof FeatureAttributeEmulatorExpression;
    }

    private FeatureAttributeDescriptor getFeatureAttributeDescriptor(ExpressionBuilder.Value value) {
        FeatureAttributeDescriptor attr;
        FeatureType featureType;
        SQLBuilder.Column column;
        SQLBuilder.TableNameBuilder table;
        if (value instanceof SQLBuilder.Column && (table = (column = (SQLBuilder.Column)value).table()) != null && (featureType = table.featureType()) != null && (attr = featureType.getAttributeDescriptor(column.name())) != null) {
            return attr;
        }
        if (value instanceof ExpressionBuilder.Variable) {
            FeatureType featureType2 = (FeatureType)value.getProperty("FeatureType");
            if (featureType2 == null) {
                return null;
            }
            JDBCHelper jdbcHelper = (JDBCHelper)value.getProperty("JDBCHelper");
            if (jdbcHelper == null) {
                return null;
            }
            ExpressionBuilder.Variable variable = (ExpressionBuilder.Variable)value;
            attr = featureType2.getAttributeDescriptor(variable.name());
            if (attr != null) {
                return attr;
            }
            FeatureQuery query = (FeatureQuery)value.getProperty("Query");
            if (query == null) {
                return null;
            }
            FeatureExtraColumns extraColumn = query.getExtraColumn();
            if (extraColumn == null) {
                return null;
            }
            attr = extraColumn.get(variable.name());
            return attr;
        }
        return null;
    }

    public String format(ExpressionBuilder.Value value) {
        ExpressionBuilder.Value valueExpr = this.expandedValue(value);
        return "(" + this.formatter.format((Object)valueExpr) + ")";
    }

    public ExpressionBuilder.Value expandedValue(ExpressionBuilder.Value value) {
        FeatureAttributeDescriptor attr = this.getFeatureAttributeDescriptor(value);
        if (attr == null) {
            return value;
        }
        SQLBuilder.TableNameBuilder table = null;
        if (value instanceof SQLBuilder.Column) {
            table = ((SQLBuilder.Column)value).table();
        }
        FeatureAttributeEmulator emulator = attr.getFeatureAttributeEmulator();
        Expression expr = ((FeatureAttributeEmulatorExpression)emulator).getExpression();
        Code code = expr.getCode();
        GeometryExpressionBuilder builder = this.sqlbuilder.expression();
        ExpressionBuilder.Value valueExpr = this.setTableName(table, code.toValue((ExpressionBuilder)builder));
        return valueExpr;
    }

    private ExpressionBuilder.Value setTableName(final SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value value) {
        if (table == null) {
            return value;
        }
        value.accept(new ExpressionBuilder.Visitor(){

            public void visit(ExpressionBuilder.Visitable value) {
                if (value instanceof SQLBuilder.Column) {
                    SQLBuilder.Column c = (SQLBuilder.Column)value;
                    SQLBuilder.TableNameBuilder t = c.table();
                    if (t == null) {
                        c.table(table);
                        return;
                    }
                    if (t.equals(table)) {
                        t.setFeatureType(table.featureType());
                    }
                }
            }
        }, null);
        return value;
    }

    private ExpressionBuilder.Value replaceVariablesByColumns(SQLBuilder.TableNameBuilder table, ExpressionBuilder.Value value) {
        return value;
    }
}

