/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.cresques.cts.IProjection;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.spi.FeatureReferenceProviderServices;
import org.gvsig.fmap.dal.feature.spi.FeatureStoreProviderServices;
import org.gvsig.fmap.dal.store.jdbc.JDBCNewStoreParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCServerExplorerParameters;
import org.gvsig.fmap.dal.store.jdbc.JDBCStoreParameters;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AppendOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CalculateEnvelopeOfColumnOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CanCreateTablesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CanModifyTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CountOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.CreateTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.DeletePassThroughOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.DropTableOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ExecuteOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureProviderByReferenceOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.FetchFeatureTypeOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ListTablesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.PerformChangesOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ResultSetForSetProviderOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.RetrieveValueOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.TableIsEmptyOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.UpdatePassThroughOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.UpdateTableStatisticsOperation;
import org.gvsig.fmap.geom.primitive.Envelope;

public class OperationsFactoryBase
implements OperationsFactory {
    protected final JDBCHelper helper;

    public OperationsFactoryBase(JDBCHelper helper) {
        this.helper = helper;
    }

    @Override
    public OperationsFactory.TableReference createTableReference(JDBCStoreParameters params) {
        DefaultTableReference t = new DefaultTableReference(params.getDBName(), params.getSchema(), params.getTable(), params.getSQL());
        return t;
    }

    @Override
    public OperationsFactory.TableReference createTableReference(JDBCNewStoreParameters params) {
        DefaultTableReference t = new DefaultTableReference(params.getDBName(), params.getSchema(), params.getTable(), null);
        return t;
    }

    @Override
    public OperationsFactory.TableReference createTableReference(String database, String schema, String table, String subquery) {
        DefaultTableReference t = new DefaultTableReference(database, schema, table, subquery);
        return t;
    }

    @Override
    public FetchFeatureTypeOperation createFetchFeatureType(EditableFeatureType type, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryField, IProjection crs) {
        return this.createFetchFeatureType(type, table, primaryKeys, defaultGeometryField, crs, -1, -1);
    }

    @Override
    public FetchFeatureTypeOperation createFetchFeatureType(EditableFeatureType type, OperationsFactory.TableReference table, List<String> primaryKeys, String defaultGeometryField, IProjection crs, int geometryType, int geometrySubtype) {
        return new FetchFeatureTypeOperation(this.helper, type, table, primaryKeys, defaultGeometryField, crs, geometryType, geometrySubtype);
    }

    @Override
    public FetchFeatureProviderByReferenceOperation createFetchFeatureProviderByReference(FeatureReferenceProviderServices reference, FeatureType featureType, OperationsFactory.TableReference table) {
        return new FetchFeatureProviderByReferenceOperation(this.helper, reference, featureType, table);
    }

    @Override
    public CalculateEnvelopeOfColumnOperation createCalculateEnvelopeOfColumn(FeatureType featureType, OperationsFactory.TableReference table, String columnName, String baseFilter, Envelope workingArea, IProjection crs) {
        return new CalculateEnvelopeOfColumnOperation(this.helper, featureType, table, columnName, baseFilter, workingArea, crs);
    }

    @Override
    public PerformChangesOperation createPerformChanges(OperationsFactory.TableReference table, FeatureType type, Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged) {
        return this.createPerformChanges(table, type, deleteds, inserteds, updateds, featureTypesChanged, null);
    }

    @Override
    public PerformChangesOperation createPerformChanges(OperationsFactory.TableReference table, FeatureType type, Iterator deleteds, Iterator inserteds, Iterator updateds, Iterator featureTypesChanged, FeatureStoreProviderServices storeServices) {
        return new PerformChangesOperation(this.helper, table, type, deleteds, inserteds, updateds, featureTypesChanged, storeServices);
    }

    @Override
    public AppendOperation createAppend(OperationsFactory.TableReference table, FeatureType type) {
        return new AppendOperation(this.helper, table, type);
    }

    @Override
    public CountOperation createCount(FeatureType featureType, OperationsFactory.TableReference table, String baseFilter, FeatureQuery query) {
        return new CountOperation(this.helper, featureType, table, baseFilter, query);
    }

    @Override
    public TableIsEmptyOperation createTableIsEmpty(FeatureType featureType, OperationsFactory.TableReference table, String baseFilter, FeatureQuery query) {
        return new TableIsEmptyOperation(this.helper, featureType, table, baseFilter, query);
    }

    @Override
    public ResultSetForSetProviderOperation createResultSetForSetProvider(OperationsFactory.TableReference table, String baseFilter, String baseOrder, FeatureQuery query, FeatureType storeType, FeatureType setType, long limit, long offset, int fetchSize) {
        return new ResultSetForSetProviderOperation(this.helper, table, baseFilter, baseOrder, query, storeType, setType, limit, offset, fetchSize);
    }

    @Override
    public ListTablesOperation createListTables(int mode, JDBCServerExplorerParameters baseParameters, boolean informationTables, int tablesOrViews) {
        return new ListTablesOperation(this.helper, mode, baseParameters, informationTables, tablesOrViews);
    }

    @Override
    public DropTableOperation createDropTable(OperationsFactory.TableReference tableName) {
        return new DropTableOperation(this.helper, tableName);
    }

    @Override
    public CreateTableOperation createTable(OperationsFactory.TableReference table, FeatureType type, List<Pair<String, SQLBuilder.Privilege>> userAndPrivileges, List<String> additionalSQLs) throws DataException {
        return new CreateTableOperation(this.helper, table, type, userAndPrivileges, additionalSQLs);
    }

    @Override
    public List<String> createTableSQLs(String databaseName, String schemaName, String tableName, FeatureType type) throws DataException {
        CreateTableOperation op = new CreateTableOperation(this.helper, new DefaultTableReference(databaseName, schemaName, tableName, null), type, null, null);
        return op.getSQLs();
    }

    @Override
    public CanCreateTablesOperation createCanCreateTables() {
        return new CanCreateTablesOperation(this.helper);
    }

    @Override
    public UpdateTableStatisticsOperation createUpdateTableStatistics(OperationsFactory.TableReference table) {
        return new UpdateTableStatisticsOperation(this.helper, table);
    }

    @Override
    public CanModifyTableOperation createCanModifyTableOperation(OperationsFactory.TableReference table) {
        return new CanModifyTableOperation(this.helper, table);
    }

    @Override
    public ExecuteOperation createExecute(String sql) {
        return new ExecuteOperation(this.helper, sql);
    }

    @Override
    public UpdatePassThroughOperation createUpdatePassThroughOperation(OperationsFactory.TableReference table, Object[] parameters, Expression filter) {
        return new UpdatePassThroughOperation(this.helper, table, parameters, filter);
    }

    @Override
    public DeletePassThroughOperation createDeletePassThroughOperation(OperationsFactory.TableReference table, Expression filter) {
        return new DeletePassThroughOperation(this.helper, table, filter);
    }

    @Override
    public RetrieveValueOperation createRetrieveValue(OperationsFactory.TableReference createTableReference, String filter, String order, String fieldname) {
        return new RetrieveValueOperation(this.helper, createTableReference, filter, order, fieldname);
    }

    public static class DefaultTableReference
    implements OperationsFactory.TableReference {
        private final String database;
        private final String schema;
        private final String table;
        private final String subquery;

        public DefaultTableReference(String database, String schema, String table, String subquery) {
            this.database = (String)StringUtils.defaultIfBlank((CharSequence)database, null);
            this.schema = (String)StringUtils.defaultIfBlank((CharSequence)schema, null);
            this.table = (String)StringUtils.defaultIfBlank((CharSequence)table, null);
            this.subquery = (String)StringUtils.defaultIfBlank((CharSequence)subquery, null);
        }

        @Override
        public String getDatabase() {
            return this.database;
        }

        @Override
        public String getSchema() {
            return this.schema;
        }

        @Override
        public String getTable() {
            return this.table;
        }

        @Override
        public String getSubquery() {
            return this.subquery;
        }

        @Override
        public boolean hasDatabase() {
            return this.database != null;
        }

        @Override
        public boolean hasSchema() {
            return this.schema != null;
        }

        @Override
        public boolean hasTable() {
            return this.table != null;
        }

        @Override
        public boolean hasSubquery() {
            return this.subquery != null;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.hasDatabase()) {
                builder.append(this.database);
                builder.append(".");
            }
            if (this.hasSchema()) {
                builder.append(this.schema);
                builder.append(".");
            }
            builder.append(this.table);
            if (this.hasSubquery()) {
                builder.append("[");
                builder.append(this.subquery);
                builder.append("]");
            }
            return builder.toString();
        }
    }
}

