/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.io.IOException;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.io.IOUtils;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;

public class RetrieveValueOperation
extends AbstractConnectionOperation {
    private final OperationsFactory.TableReference table;
    private final String filter;
    private final String order;
    private final String fieldname;

    public RetrieveValueOperation(JDBCHelper helper) {
        this(helper, null, null, null, null);
    }

    public RetrieveValueOperation(JDBCHelper helper, OperationsFactory.TableReference table, String filter, String order, String fieldname) {
        super(helper);
        this.table = table;
        this.filter = filter;
        this.order = order;
        this.fieldname = fieldname;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.retrieveValue(conn);
    }

    public String getSQL() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        select.column().name(this.fieldname);
        select.where().set(expbuilder.toValue(this.filter));
        select.from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        String sql = select.toString();
        return sql;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object retrieveValue(JDBCConnection conn) throws DataException {
        Object object;
        ResultSet rs;
        Statement st;
        String sql;
        block9: {
            sql = this.getSQL();
            st = null;
            rs = null;
            st = conn.createStatement(sql);
            rs = JDBCUtils.executeQuery(st, sql);
            if (rs.next()) break block9;
            Object var5_5 = null;
            JDBCUtils.closeQuietly(st);
            JDBCUtils.closeQuietly(rs);
            return var5_5;
        }
        try {
            Object value = rs.getObject(1);
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                value = blob.getBytes(1L, (int)blob.length());
                blob.free();
            } else if (value instanceof Clob) {
                Clob clob = (Clob)value;
                value = new String(IOUtils.toCharArray((Reader)clob.getCharacterStream()));
                clob.free();
            }
            object = value;
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, sql);
                catch (IOException ex2) {
                    throw new JDBCSQLException(ex2, sql);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        JDBCUtils.closeQuietly(rs);
        return object;
    }
}

