/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.GeometryExpressionBuilder;
import org.gvsig.fmap.dal.SQLBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.store.jdbc.exception.JDBCSQLException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.ResultSetForSetProviderOperation;

public class TableIsEmptyOperation
extends AbstractConnectionOperation {
    private final OperationsFactory.TableReference table;
    private final String baseFilter;
    private final FeatureQuery query;
    private final FeatureType featureType;

    public TableIsEmptyOperation(JDBCHelper helper) {
        this(helper, null, null, null, null);
    }

    public TableIsEmptyOperation(JDBCHelper helper, FeatureType featureType, OperationsFactory.TableReference table, String baseFilter, FeatureQuery query) {
        super(helper);
        this.featureType = featureType;
        this.table = table;
        this.baseFilter = baseFilter;
        this.query = query;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.tableIsEmpty(conn);
    }

    public String getSQL() {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        GeometryExpressionBuilder expbuilder = sqlbuilder.expression();
        expbuilder.setProperty("FeatureType", (Object)this.featureType);
        expbuilder.setProperty("Table", (Object)this.table);
        expbuilder.setProperty("TableName", (Object)this.table.getTable());
        expbuilder.setProperty("SymbolTable", this.query == null ? null : this.query.getSymbolTable());
        expbuilder.setProperty("JDBCHelper", (Object)this.helper);
        expbuilder.setProperty("Query", (Object)this.query);
        SQLBuilder.SelectBuilder select = sqlbuilder.select();
        select.from().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        select.from().subquery(this.table.getSubquery());
        ResultSetForSetProviderOperation.process3_Where(this.helper, this.featureType, this.query, (SQLBuilder)sqlbuilder, select);
        if (!StringUtils.isEmpty((CharSequence)this.baseFilter)) {
            select.where().set((ExpressionBuilder.Value)expbuilder.custom((Object)this.baseFilter));
        }
        if (this.query != null && (this.query.hasAggregateFunctions() || this.query.hasGroupByColumns())) {
            ResultSetForSetProviderOperation.process4_Aggregates(this.table, this.featureType, this.query, ResultSetForSetProviderOperation.getAllExtraColumns(this.featureType, this.query), (SQLBuilder)sqlbuilder, select, null);
            ResultSetForSetProviderOperation.process5_GroupBys(this.table, this.featureType, this.query, ResultSetForSetProviderOperation.getAllExtraColumns(this.featureType, this.query), (SQLBuilder)sqlbuilder, select, null);
        }
        select.limit(1L);
        sqlbuilder.setProperties(null, new Object[]{"FeatureType", this.featureType, "Table", this.table, "SymbolTable", this.query == null ? null : this.query.getSymbolTable(), "JDBCHelper", this.helper, "Query", this.query});
        this.helper.expandCalculedColumns(sqlbuilder);
        this.helper.processSpecialFunctions((SQLBuilder)sqlbuilder, this.featureType, null, this.query);
        if (select.getColumns().isEmpty()) {
            select.column().value((ExpressionBuilder.Value)expbuilder.constant((Object)1));
        }
        String sql = sqlbuilder.select().toString();
        return sql;
    }

    public boolean tableIsEmpty(JDBCConnection conn) throws DataException {
        boolean bl;
        String sql = this.getSQL();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement(sql);
            rs = JDBCUtils.executeQuery(st, sql);
            bl = !rs.next();
        }
        catch (SQLException ex) {
            try {
                throw new JDBCSQLException(ex, sql);
            }
            catch (Throwable throwable) {
                JDBCUtils.closeQuietly(st);
                JDBCUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        JDBCUtils.closeQuietly(st);
        JDBCUtils.closeQuietly(rs);
        return bl;
    }
}

