/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.fmap.dal.store.jdbc2.spi.operations;

import java.sql.Statement;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.store.jdbc2.JDBCConnection;
import org.gvsig.fmap.dal.store.jdbc2.JDBCHelper;
import org.gvsig.fmap.dal.store.jdbc2.JDBCUtils;
import org.gvsig.fmap.dal.store.jdbc2.OperationsFactory;
import org.gvsig.fmap.dal.store.jdbc2.spi.JDBCSQLBuilderBase;
import org.gvsig.fmap.dal.store.jdbc2.spi.operations.AbstractConnectionOperation;

public class UpdatePassThroughOperation
extends AbstractConnectionOperation {
    private final Object[] parameters;
    private final Expression filter;
    private final OperationsFactory.TableReference table;

    public UpdatePassThroughOperation(JDBCHelper helper, OperationsFactory.TableReference table, Object[] parameters, Expression filter) {
        super(helper);
        this.table = table;
        this.parameters = parameters;
        this.filter = filter;
    }

    @Override
    public final Object perform(JDBCConnection conn) throws DataException {
        return this.execute(this.table, this.parameters, this.filter);
    }

    public Object execute(OperationsFactory.TableReference table, Object[] parameters, Expression filter) {
        Statement st = null;
        String sql = this.getSQL(table, parameters, filter);
        try {
            st = this.getConnection().createStatement(sql);
            JDBCUtils.executeUpdate(st, sql);
            JDBCUtils.closeQuietly(st);
            return null;
        }
        catch (Exception ex) {
            JDBCUtils.closeQuietly(st);
            throw new RuntimeException("Can't execute query [" + sql + "].", ex);
        }
    }

    public String getSQL(OperationsFactory.TableReference table, Object[] parameters, Expression filter) {
        JDBCSQLBuilderBase sqlbuilder = this.createSQLBuilder();
        sqlbuilder.update().table().database(this.table.getDatabase()).schema(this.table.getSchema()).name(this.table.getTable());
        for (int i = 0; i < parameters.length - 1; i += 2) {
            String field = (String)parameters[i];
            sqlbuilder.update().column().name(field).with_value((ExpressionBuilder.Value)sqlbuilder.expression().constant(parameters[i + 1]));
        }
        if (filter != null) {
            sqlbuilder.update().where().set(filter.getCode().toValue());
        }
        String sql = sqlbuilder.update().toString();
        return sql;
    }
}

