/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.symbology.gui.layerproperties;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.project.documents.view.legend.gui.ILegendPanel;
import org.gvsig.app.project.documents.view.legend.gui.MultipleAttributes;
import org.gvsig.app.project.documents.view.legend.gui.SymbolTable;
import org.gvsig.app.project.documents.view.legend.gui.VectorialInterval;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.IInterval;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.swing.GridBagLayoutPanel;
import org.gvsig.i18n.Messages;
import org.gvsig.symbology.fmap.mapcontext.rendering.legend.impl.VectorialIntervalLegend;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.fill.IFillSymbol;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.marker.IMarkerSymbol;
import org.gvsig.symbology.fmap.rendering.GraduatedSymbolsLegend;
import org.gvsig.symbology.fmap.rendering.QuantityByCategoryLegend;
import org.gvsig.symbology.gui.layerproperties.GraduatedSymbolsPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantityByCategoryPanel
extends JPanel
implements ILegendPanel,
ActionListener {
    private static final long serialVersionUID = 5098346573350040756L;
    private static final Logger logger = LoggerFactory.getLogger(QuantityByCategoryPanel.class);
    private JPanel pnlNorth;
    private JPanel pnlSouth;
    private JPanel pnlButtons;
    private GridBagLayoutPanel pnlFields;
    private JPanel pnlColorAndSymbol;
    private JComboBox cmbColorField;
    private JComboBox cmbGraduatedSymbolField;
    private JButton btnColor;
    private JButton btnSymbol;
    private QuantityByCategoryLegend legend;
    private QuantityByCategoryLegend oldLegend;
    private FLayer layer;
    private SymbolTable symbolTable;

    public QuantityByCategoryPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(490, 300);
        this.add((Component)this.getPnlNorth(), "North");
        this.add((Component)this.getPnlSouth(), "Center");
    }

    private JPanel getPnlSouth() {
        if (this.pnlSouth == null) {
            this.pnlSouth = new JPanel();
            this.pnlSouth.setLayout(new BorderLayout());
        }
        return this.pnlSouth;
    }

    private JPanel getPnlNorth() {
        if (this.pnlNorth == null) {
            this.pnlNorth = new JPanel(new GridLayout(1, 2));
            this.pnlNorth.add((Component)this.getPnlFields());
            this.pnlNorth.add(this.getPnlColorAndSymbol());
        }
        return this.pnlNorth;
    }

    private JPanel getPnlColorAndSymbol() {
        if (this.pnlColorAndSymbol == null) {
            this.pnlColorAndSymbol = new JPanel();
            this.pnlColorAndSymbol.setBorder(BorderFactory.createTitledBorder(null, Messages.getText((String)"variation_by")));
            this.pnlColorAndSymbol.add(this.getBtnColor());
            this.pnlColorAndSymbol.add(this.getBtnSymbol());
        }
        return this.pnlColorAndSymbol;
    }

    private JButton getBtnSymbol() {
        if (this.btnSymbol == null) {
            this.btnSymbol = new JButton(Messages.getText((String)"symbol"));
            this.btnSymbol.addActionListener(this);
        }
        return this.btnSymbol;
    }

    private JButton getBtnColor() {
        if (this.btnColor == null) {
            this.btnColor = new JButton(Messages.getText((String)"color_ramp"));
            this.btnColor.addActionListener(this);
        }
        return this.btnColor;
    }

    private GridBagLayoutPanel getPnlFields() {
        if (this.pnlFields == null) {
            this.pnlFields = new GridBagLayoutPanel();
            this.pnlFields.setBorder((Border)BorderFactory.createTitledBorder(null, Messages.getText((String)"value_fields")));
            this.pnlFields.addComponent(Messages.getText((String)"color_field"), (Component)this.getCmbColorField());
            this.pnlFields.addComponent(Messages.getText((String)"symbol_field"), (Component)this.getCmbGraduatedField());
        }
        return this.pnlFields;
    }

    private JComboBox getCmbGraduatedField() {
        if (this.cmbGraduatedSymbolField == null) {
            this.cmbGraduatedSymbolField = new JComboBox();
            this.cmbGraduatedSymbolField.addActionListener(this);
        }
        return this.cmbGraduatedSymbolField;
    }

    private JComboBox getCmbColorField() {
        if (this.cmbColorField == null) {
            this.cmbColorField = new JComboBox();
            this.cmbColorField.addActionListener(this);
        }
        return this.cmbColorField;
    }

    public void setData(FLayer lyr, ILegend legend) {
        this.layer = lyr;
        this.oldLegend = null;
        if (this.symbolTable != null) {
            this.pnlSouth.remove((Component)this.symbolTable);
        }
        this.symbolTable = new SymbolTable((Component)this, "intervals", 0);
        this.pnlSouth.add((Component)this.symbolTable, "Center");
        this.fillFieldNames();
        if (legend instanceof QuantityByCategoryLegend) {
            this.oldLegend = (QuantityByCategoryLegend)legend.cloneLegend();
            this.cmbColorField.setSelectedItem(this.oldLegend.getColorRampLegend().getClassifyingFieldNames()[0]);
            this.cmbGraduatedSymbolField.setSelectedItem(this.oldLegend.getGraduatedSymbolsLegend().getClassifyingFieldNames()[0]);
            this.symbolTable.removeAllItems();
            this.fillTableSkipDefault((IClassifiedLegend)this.oldLegend);
        } else {
            this.oldLegend = new QuantityByCategoryLegend();
            String[] fnn = new String[]{(String)this.getCmbColorField().getSelectedItem(), (String)this.getCmbGraduatedField().getSelectedItem()};
            this.oldLegend.setClassifyingFieldNames(fnn);
            try {
                FLyrVect lv = (FLyrVect)lyr;
                this.setFieldTypesFromFieldNames(lv, this.oldLegend, fnn);
                this.oldLegend.setShapeType(lv.getShapeType());
            }
            catch (Exception exc) {
                logger.info("Error while setting data in legend panel", (Throwable)exc);
                ApplicationLocator.getManager().messageDialog(Messages.getText((String)"error_trying_to_access_to_the_layer"), Messages.getText((String)"error"), 0);
            }
        }
    }

    private void setFieldTypesFromFieldNames(FLyrVect vect, QuantityByCategoryLegend leg, String[] nn) throws DataException {
        FeatureStore fsto = (FeatureStore)vect.getDataStore();
        FeatureType fty = fsto.getDefaultFeatureType();
        int[] fieldTypes = new int[nn.length];
        FeatureAttributeDescriptor attdesc = null;
        for (int i = 0; i < nn.length; ++i) {
            attdesc = fty.getAttributeDescriptor(nn[i]);
            fieldTypes[i] = attdesc.getDataType().getType();
        }
        leg.setClassifyingFieldTypes(fieldTypes);
    }

    private void fillSymbolListFromTable() {
        IInterval theInterval = null;
        this.oldLegend.clear();
        FLyrVect vect = (FLyrVect)this.layer;
        try {
            String[] fNames = this.oldLegend.getClassifyingFieldNames();
            if (fNames != null) {
                this.setFieldTypesFromFieldNames(vect, this.oldLegend, fNames);
            }
        }
        catch (DataException e) {
            logger.info("Error while fillSymbolListFromTablel", (Throwable)e);
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"could_not_setup_legend"), Messages.getText((String)"error"), 0);
            return;
        }
        for (int row = 0; row < this.symbolTable.getRowCount(); ++row) {
            theInterval = (IInterval)this.symbolTable.getFieldValue(row, 1);
            ISymbol theSymbol = (ISymbol)this.symbolTable.getFieldValue(row, 0);
            theSymbol.setDescription((String)this.symbolTable.getFieldValue(row, 2));
            if (theSymbol instanceof IFillSymbol) {
                this.oldLegend.getColorRampLegend().addSymbol((Object)theInterval, theSymbol);
                continue;
            }
            if (!(theSymbol instanceof IMarkerSymbol)) continue;
            this.oldLegend.getGraduatedSymbolsLegend().addSymbol((Object)theInterval, theSymbol);
        }
        if (this.oldLegend.getColorRampLegend().isUseDefaultSymbol()) {
            this.oldLegend.getColorRampLegend().addSymbol(null, this.oldLegend.getColorRampLegend().getDefaultSymbol());
        }
        if (this.oldLegend.getGraduatedSymbolsLegend().isUseDefaultSymbol()) {
            this.oldLegend.getGraduatedSymbolsLegend().addSymbol(null, this.oldLegend.getGraduatedSymbolsLegend().getDefaultSymbol());
        }
    }

    public ILegend getLegend() {
        this.fillSymbolListFromTable();
        this.legend = (QuantityByCategoryLegend)this.oldLegend.cloneLegend();
        return this.legend;
    }

    public String getDescription() {
        return Messages.getText((String)"draw_quantities_for_each_category");
    }

    public ImageIcon getIcon() {
        ImageIcon ii = IconThemeHelper.getImageIcon((String)"legend-overview-quantity-by-category");
        return ii;
    }

    public Class getParentClass() {
        return MultipleAttributes.class;
    }

    public String getTitle() {
        return Messages.getText((String)"quantity_by_category");
    }

    public JPanel getPanel() {
        return this;
    }

    public Class getLegendClass() {
        return QuantityByCategoryLegend.class;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JComponent c = (JComponent)e.getSource();
        if (c.equals(this.getBtnColor())) {
            VectorialIntervalLegend colorRamp = this.oldLegend.getColorRampLegend();
            String fieldName = (String)this.getCmbColorField().getSelectedItem();
            if (!fieldName.equals(colorRamp.getClassifyingFieldNames()[0])) {
                colorRamp.setClassifyingFieldNames(new String[]{fieldName});
                colorRamp.clear();
            }
            VectorialInterval legPanel = new VectorialInterval();
            legPanel.setData(this.layer, (ILegend)colorRamp);
            InnerWindow window = new InnerWindow((ILegendPanel)legPanel);
            ApplicationLocator.getManager().getUIManager().addWindow((IWindow)window);
            this.cmbColorField.setSelectedItem(colorRamp.getClassifyingFieldNames()[0].toString());
            ILegend newLegend = window.getLegend();
            if (newLegend != null) {
                if (newLegend instanceof VectorialIntervalLegend) {
                    this.oldLegend.getColorRampLegend().clear();
                    this.oldLegend.setColorRampLegend((VectorialIntervalLegend)newLegend);
                } else {
                    ApplicationLocator.getManager().messageDialog(Messages.getText((String)"could_not_setup_legend"), Messages.getText((String)"error"), 0);
                }
            }
            this.symbolTable.removeAllItems();
            this.fillTableSkipDefault((IClassifiedLegend)this.oldLegend);
        } else if (c.equals(this.getBtnSymbol())) {
            GraduatedSymbolsLegend graduatedSymbol = this.oldLegend.getGraduatedSymbolsLegend();
            String fieldName = (String)this.getCmbGraduatedField().getSelectedItem();
            if (!fieldName.equals(graduatedSymbol.getClassifyingFieldNames()[0])) {
                graduatedSymbol.setClassifyingFieldNames(new String[]{fieldName});
                ISymbol def = MapContextLocator.getSymbolManager().createSymbol(1);
                graduatedSymbol.setDefaultSymbol(def);
                graduatedSymbol.setMinSymbolSize(1.0);
                graduatedSymbol.setMaxSymbolSize(14.0);
                graduatedSymbol.clear();
            }
            GraduatedSymbolsPanel legPanel = new GraduatedSymbolsPanel(false);
            legPanel.setData(this.layer, (ILegend)graduatedSymbol);
            InnerWindow window = new InnerWindow((ILegendPanel)legPanel);
            ApplicationLocator.getManager().getUIManager().addWindow((IWindow)window);
            this.cmbGraduatedSymbolField.setSelectedItem(graduatedSymbol.getClassifyingFieldNames()[0].toString());
            ILegend newLegend = window.getLegend();
            if (newLegend != null) {
                if (newLegend instanceof GraduatedSymbolsLegend) {
                    this.oldLegend.getGraduatedSymbolsLegend().clear();
                    this.oldLegend.setGraduateSymbolLegend((GraduatedSymbolsLegend)newLegend);
                } else {
                    ApplicationLocator.getManager().messageDialog(Messages.getText((String)"could_not_setup_legend"), Messages.getText((String)"error"), 0);
                }
            }
            this.symbolTable.removeAllItems();
            this.fillTableSkipDefault((IClassifiedLegend)this.oldLegend);
        } else if (c.equals(this.getCmbColorField())) {
            this.symbolTable.removeAllItems();
            this.fillTableSkipDefault(this.oldLegend.getGraduatedSymbolsLegend().getSymbols(), this.oldLegend.getGraduatedSymbolsLegend().getValues(), this.oldLegend.getDescriptions());
        } else if (c.equals(this.getCmbGraduatedField())) {
            this.symbolTable.removeAllItems();
            this.fillTableSkipDefault(this.oldLegend.getColorRampLegend().getSymbols(), this.oldLegend.getColorRampLegend().getValues(), this.oldLegend.getDescriptions());
        }
    }

    protected void fillFieldNames() {
        ArrayList<String> nomFields = null;
        FLyrVect vect = null;
        try {
            FeatureStore fsto = null;
            FeatureType fty = null;
            FeatureAttributeDescriptor[] atts = null;
            if (!(this.layer instanceof FLyrVect)) {
                ApplicationLocator.getManager().messageDialog(Messages.getText((String)"error_trying_to_access_to_the_layer"), Messages.getText((String)"error"), 0);
                logger.info("Error while fillFieldNames, Unexpected layer class: " + this.layer);
                return;
            }
            vect = (FLyrVect)this.layer;
            fsto = (FeatureStore)vect.getDataStore();
            fty = fsto.getDefaultFeatureType();
            atts = fty.getAttributeDescriptors();
            nomFields = new ArrayList();
            for (int i = 0; i < atts.length; ++i) {
                if (!atts[i].getDataType().isNumeric()) continue;
                nomFields.add(atts[i].getName());
            }
        }
        catch (DataException e) {
            ApplicationLocator.getManager().messageDialog(Messages.getText((String)"error_trying_to_access_to_the_layer"), Messages.getText((String)"error"), 0);
            logger.info("Error while fillFieldNames", (Throwable)e);
            nomFields = new ArrayList<String>();
        }
        DefaultComboBoxModel<Object> cM = new DefaultComboBoxModel<Object>(nomFields.toArray());
        this.cmbColorField.setModel(cM);
        cM = new DefaultComboBoxModel<Object>(nomFields.toArray());
        this.cmbGraduatedSymbolField.setModel(cM);
        this.symbolTable.removeAllItems();
    }

    public boolean isSuitableFor(FLayer layer) {
        if (layer instanceof FLyrVect) {
            try {
                FLyrVect vect = (FLyrVect)layer;
                int shpt = vect.getGeometryType().getType();
                if (!QuantityByCategoryLegend.isPolygonal(shpt)) {
                    return false;
                }
                FeatureStore fsto = (FeatureStore)vect.getDataStore();
                FeatureType fty = fsto.getDefaultFeatureType();
                FeatureAttributeDescriptor[] atts = fty.getAttributeDescriptors();
                for (int i = 0; i < atts.length; ++i) {
                    if (!atts[i].getDataType().isNumeric()) continue;
                    return true;
                }
            }
            catch (Exception e) {
                logger.info("Error while isSuitableFor.", (Throwable)e);
                ApplicationLocator.getManager().message(Messages.getText((String)"error"), 0);
                return false;
            }
        }
        return false;
    }

    private void fillTableSkipDefault(IClassifiedLegend leg) {
        Object[] src_expr = leg.getValues();
        ISymbol[] src_syms = leg.getSymbols();
        String[] src_descs = leg.getDescriptions();
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<String> descs = new ArrayList<String>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (!(src_expr[i] instanceof IInterval)) continue;
            syms.add(src_syms[i]);
            vals.add(src_expr[i]);
            descs.add(src_descs[i]);
        }
        this.symbolTable.fillTableFromSymbolList(syms.toArray(new ISymbol[0]), vals.toArray(new Object[0]), descs.toArray(new String[0]));
    }

    private void fillTableSkipDefault(ISymbol[] src_syms, Object[] src_expr, String[] src_descs) {
        ArrayList<ISymbol> syms = new ArrayList<ISymbol>();
        ArrayList<Object> vals = new ArrayList<Object>();
        ArrayList<String> descs = new ArrayList<String>();
        for (int i = 0; i < src_expr.length; ++i) {
            if (!(src_expr[i] instanceof IInterval)) continue;
            syms.add(src_syms[i]);
            vals.add(src_expr[i]);
            descs.add(src_descs[i]);
        }
        this.symbolTable.fillTableFromSymbolList(syms.toArray(new ISymbol[0]), vals.toArray(new Object[0]), descs.toArray(new String[0]));
    }

    private class InnerWindow
    extends JPanel
    implements IWindow {
        private ActionListener okAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InnerWindow.this.legend = InnerWindow.this.panel.getLegend();
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)InnerWindow.this);
            }
        };
        private ActionListener cancelAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationLocator.getManager().getUIManager().closeWindow((IWindow)InnerWindow.this);
            }
        };
        private ILegend legend;
        private ILegendPanel panel;
        private WindowInfo wi;

        public InnerWindow(ILegendPanel panel) {
            this.panel = panel;
            this.setLayout(new BorderLayout());
            this.add((Component)((JComponent)panel), "North");
            this.add((Component)new AcceptCancelPanel(this.okAction, this.cancelAction), "South");
        }

        public ILegend getLegend() {
            return this.legend;
        }

        public WindowInfo getWindowInfo() {
            if (this.wi == null) {
                this.wi = new WindowInfo(9);
                JComponent c = (JComponent)this.panel;
                this.wi.setWidth(c.getWidth());
                this.wi.setHeight(c.getHeight());
                this.wi.setTitle(this.panel.getTitle());
            }
            return this.wi;
        }

        public Object getWindowProfile() {
            return WindowInfo.DIALOG_PROFILE;
        }
    }
}

