/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.ermapper.io;

import com.ermapper.ecw.JNCSException;
import com.ermapper.ecw.JNCSFile;
import com.ermapper.ecw.JNCSFileNotOpenException;
import com.ermapper.ecw.JNCSInvalidSetViewException;
import com.ermapper.ecw.JNCSProgressiveUpdate;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.net.URI;
import java.net.URISyntaxException;
import org.cresques.cts.ICoordTrans;
import org.gvsig.fmap.dal.DALFileLocator;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.dataset.Buffer;
import org.gvsig.fmap.dal.coverage.datastruct.BandList;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.BandAccessException;
import org.gvsig.fmap.dal.coverage.exception.FileNotOpenException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSetViewException;
import org.gvsig.fmap.dal.coverage.exception.InvalidSourceException;
import org.gvsig.fmap.dal.coverage.exception.NotSupportedExtensionException;
import org.gvsig.fmap.dal.coverage.exception.ParsingException;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.exception.RasterDriverException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterDataParameters;
import org.gvsig.fmap.dal.coverage.store.parameter.RasterFileStoreParameters;
import org.gvsig.fmap.dal.coverage.store.props.ColorInterpretation;
import org.gvsig.fmap.dal.coverage.store.props.Transparency;
import org.gvsig.fmap.dal.exception.OpenException;
import org.gvsig.fmap.dal.spi.DataManagerProviderServices;
import org.gvsig.fmap.dal.spi.DataStoreProviderServices;
import org.gvsig.metadata.MetadataLocator;
import org.gvsig.raster.cache.tile.provider.TileServer;
import org.gvsig.raster.ermapper.io.ErmapperDataParameters;
import org.gvsig.raster.ermapper.io.ErmapperFilesystemServerExplorer;
import org.gvsig.raster.impl.buffer.SpiRasterQuery;
import org.gvsig.raster.impl.datastruct.ExtentImpl;
import org.gvsig.raster.impl.process.RasterTask;
import org.gvsig.raster.impl.process.RasterTaskQueue;
import org.gvsig.raster.impl.provider.AbstractRasterProvider;
import org.gvsig.raster.impl.provider.RasterProvider;
import org.gvsig.raster.impl.provider.tile.FileTileServer;
import org.gvsig.raster.impl.store.AbstractRasterDataParameters;
import org.gvsig.raster.impl.store.DefaultRasterStore;
import org.gvsig.raster.impl.store.DefaultStoreFactory;
import org.gvsig.raster.impl.store.properties.DataStoreColorInterpretation;
import org.gvsig.raster.impl.store.properties.DataStoreTransparency;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.task.TaskStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErmapperProvider
extends AbstractRasterProvider
implements JNCSProgressiveUpdate {
    private static final Logger logger = LoggerFactory.getLogger(ErmapperProvider.class);
    public static String NAME = "Ermapper Store";
    public static String DESCRIPTION = "Ermapper Raster file";
    public static final String METADATA_DEFINITION_NAME = "ErmapperStore";
    private JNCSFile file = null;
    protected Transparency fileTransparency = null;
    private Extent viewRequest = null;
    private DataStoreColorInterpretation colorInterpr = null;
    private boolean open = false;
    protected static String[] formatList = null;

    public static void register() {
        RasterLocator.getManager().getProviderServices().registerFileProvidersTiled(ErmapperProvider.class);
        ErmapperProvider.registerFormats();
        DataManagerProviderServices dataman = (DataManagerProviderServices)DALLocator.getDataManager();
        if (dataman != null && !dataman.getStoreProviders().contains(NAME)) {
            dataman.registerStoreProvider(NAME, ErmapperProvider.class, ErmapperDataParameters.class);
        }
        if (DALFileLocator.getFilesystemServerExplorerManager() != null) {
            DALFileLocator.getFilesystemServerExplorerManager().registerProvider(NAME, DESCRIPTION, ErmapperFilesystemServerExplorer.class);
        }
        dataman.registerStoreFactory(NAME, DefaultStoreFactory.class);
    }

    private static void registerFormats() {
        formatList = new String[]{"ecw", "jp2"};
        for (int i = 0; i < formatList.length; ++i) {
            RasterLocator.getManager().getProviderServices().addFormat(formatList[i], ErmapperProvider.class);
        }
    }

    public String[] getFormatList() {
        return formatList;
    }

    public boolean isExtensionSupported(String ext) {
        if (ext.indexOf(".") != -1) {
            ext = ext.substring(ext.lastIndexOf(".") + 1, ext.length());
        }
        for (int i = 0; i < formatList.length; ++i) {
            if (formatList[i].compareTo(ext) != 0) continue;
            return true;
        }
        return false;
    }

    public ErmapperProvider() {
    }

    public ErmapperProvider(String params) throws NotSupportedExtensionException, OpenException {
        super(params);
        logger.info("Deprecated use of ErmapperProvider constructor");
        if (params instanceof String) {
            ErmapperDataParameters p = new ErmapperDataParameters();
            try {
                p.setURI(new URI(params));
            }
            catch (URISyntaxException e) {
                throw new OpenException("Can't create URI from" + params, (Throwable)e);
            }
            super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
            this.init((AbstractRasterDataParameters)p, null);
        }
    }

    public ErmapperProvider(URI uri) throws NotSupportedExtensionException {
        super(uri);
        ErmapperDataParameters p = new ErmapperDataParameters();
        p.setURI(uri);
        super.init((DataStoreParameters)p, null, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)p, null);
    }

    public ErmapperProvider(ErmapperDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        super((AbstractRasterDataParameters)params, storeServices, ToolsLocator.getDynObjectManager().createDynObject(MetadataLocator.getMetadataManager().getDefinition("DataProvider")));
        this.init((AbstractRasterDataParameters)params, storeServices);
    }

    public void init(AbstractRasterDataParameters params, DataStoreProviderServices storeServices) throws NotSupportedExtensionException {
        this.setParam(storeServices, (DataStoreParameters)params);
        if (!((RasterFileStoreParameters)this.param).getFile().exists() && !"ecwp".equalsIgnoreCase(((RasterDataParameters)this.param).getURI().getScheme())) {
            throw new NotSupportedExtensionException("Extension not supported");
        }
        try {
            String stringPath = ((RasterFileStoreParameters)this.param).getFile().getPath();
            this.file = new JNCSFile(stringPath, false);
        }
        catch (JNCSException e1) {
            throw new NotSupportedExtensionException("Error loading the ecw file", (Exception)((Object)e1));
        }
        this.load();
        this.bandCount = this.file.numBands;
        int[] dt = new int[this.bandCount];
        for (int i = 0; i < this.bandCount; ++i) {
            dt[i] = 0;
        }
        this.setDataType(dt);
        super.init();
        try {
            this.loadFromRmf(this.getRmfBlocksManager());
        }
        catch (ParsingException parsingException) {
            // empty catch block
        }
        this.open = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getWKTFromEcw_csFile(String identifier) {
        File file = new File("./");
        if ((file = new File(file.getAbsoluteFile() + File.separator + "data" + File.separator + "gdal" + File.separator + "ecw_cs.wkt")).exists()) {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                String line;
                fr = new FileReader(file);
                br = new BufferedReader(fr);
                while ((line = br.readLine()) != null) {
                    if (!line.startsWith(identifier + ",")) continue;
                    int index = line.indexOf(",") + 1;
                    String string = line.substring(index);
                    return string;
                }
            }
            catch (Exception e) {
                String string = null;
                return string;
            }
            finally {
                try {
                    if (fr != null) {
                        fr.close();
                    }
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
        return null;
    }

    public RasterProvider load() {
        this.ownTransformation = new AffineTransform(this.file.cellIncrementX, 0.0, 0.0, this.file.cellIncrementY, this.file.originX, this.file.originY);
        this.externalTransformation = (AffineTransform)this.ownTransformation.clone();
        return this;
    }

    public boolean isOpen() {
        return this.open;
    }

    public void close() {
        if (this.file != null) {
            this.open = false;
            this.file = null;
        }
    }

    public Transparency getTransparency() {
        if (this.fileTransparency == null) {
            this.fileTransparency = new DataStoreTransparency((ColorInterpretation)this.getColorInterpretation());
        }
        return this.fileTransparency;
    }

    public double getWidth() {
        return this.file.width;
    }

    public double getHeight() {
        return this.file.height;
    }

    public Extent getView() {
        return this.viewRequest;
    }

    public void setView(Extent e) {
        this.viewRequest = new ExtentImpl(e);
    }

    public void loadBuffer(SpiRasterQuery query) throws ProcessInterruptedException, RasterDriverException {
        this.setView(this.transformExternalGeorefToOwnGeoref(query.getAdjustedRequestBoundingBox()));
        int bufWidth = query.getAdjustedBufWidth();
        int bufHeight = query.getAdjustedBufHeight();
        int[] stpBuffer = new int[]{0, 0, bufWidth, bufHeight};
        this.loadBuffer(this.viewRequest, bufWidth, bufHeight, query.getBufferForProviders(), query.getBandList(), stpBuffer, query.getTaskStatus());
    }

    private Extent transformExternalGeorefToOwnGeoref(Extent ext) {
        if (this.externalTransformation.equals(this.ownTransformation)) {
            return ext;
        }
        Point2D ul = ext.getUL();
        Point2D lr = ext.getLR();
        Point2D.Double p1 = new Point2D.Double();
        Point2D.Double p2 = new Point2D.Double();
        try {
            this.externalTransformation.inverseTransform(ul, p1);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        this.ownTransformation.transform(p1, p1);
        try {
            this.externalTransformation.inverseTransform(lr, p2);
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        this.ownTransformation.transform(p2, p2);
        return RasterLocator.getManager().getDataStructFactory().createExtent((Point2D)p1, (Point2D)p2);
    }

    private void loadBuffer(Extent selectedExtent, int bufWidth, int bufHeight, Buffer rasterBuf, BandList bandList, int[] stpBuffer, TaskStatus status) throws ProcessInterruptedException, RasterDriverException {
        try {
            RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
            int[] readBandsFromECW = new int[Math.max(this.file.numBands, 3)];
            for (int i = 0; i < readBandsFromECW.length; ++i) {
                readBandsFromECW[i] = i;
            }
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            if (status != null && status.isCancelled()) {
                return;
            }
            if ((long)bufWidth > Math.round(Math.abs(selectedExtent.width() / this.file.cellIncrementX))) {
                bufWidth = (int)Math.round(Math.abs(selectedExtent.width() / this.file.cellIncrementX));
            }
            if ((long)bufHeight > Math.round(Math.abs(selectedExtent.height() / this.file.cellIncrementY))) {
                bufHeight = (int)Math.round(Math.abs(selectedExtent.height() / this.file.cellIncrementY));
            }
            this.file.setView(this.file.numBands, readBandsFromECW, selectedExtent.minX(), selectedExtent.maxY(), selectedExtent.maxX(), selectedExtent.minY(), bufWidth, bufHeight);
            int[] pRGBArray = new int[bufWidth];
            this.drawRGB2(rasterBuf, pRGBArray, bandList, status);
        }
        catch (JNCSInvalidSetViewException exc) {
            throw new RasterDriverException("Error setting coords");
        }
        catch (JNCSFileNotOpenException e) {
            throw new RasterDriverException("Error opening file");
        }
        catch (JNCSException ex) {
            throw new RasterDriverException("Error reading data");
        }
    }

    private void drawRGB2(Buffer rasterBuf, int[] pRGBArray, BandList bandList, TaskStatus status) throws JNCSException, ProcessInterruptedException {
        RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
        int[] drawableBands = null;
        String absolutePath = new File(this.getURIOfFirstProvider()).getAbsolutePath();
        for (int line = 0; line < rasterBuf.getHeight(); ++line) {
            try {
                this.file.readLineRGBA(pRGBArray);
                for (int col = 0; col < pRGBArray.length; ++col) {
                    int i;
                    drawableBands = bandList.getBufferBandToDraw(absolutePath, 0);
                    if (drawableBands != null) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            if (drawableBands[i] == -1) continue;
                            rasterBuf.setElem(line, col, drawableBands[i], (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                        }
                    }
                    if ((drawableBands = bandList.getBufferBandToDraw(absolutePath, 1)) != null) {
                        for (i = 0; i < drawableBands.length; ++i) {
                            if (drawableBands[i] == -1) continue;
                            rasterBuf.setElem(line, col, drawableBands[i], (byte)((pRGBArray[col] & 0xFF00) >> 8));
                        }
                    }
                    if ((drawableBands = bandList.getBufferBandToDraw(absolutePath, 2)) == null) continue;
                    for (i = 0; i < drawableBands.length; ++i) {
                        if (drawableBands[i] == -1) continue;
                        rasterBuf.setElem(line, col, drawableBands[i], (byte)(pRGBArray[col] & 0xFF));
                    }
                }
            }
            catch (JNCSException jNCSException) {
                // empty catch block
            }
            if (task.getEvent() != null) {
                task.manageEvent(task.getEvent());
            }
            if (status == null || !status.isCancelled()) continue;
            return;
        }
    }

    private void drawRGB(Buffer rasterBuf, int[] pRGBArray, int[] readBands, BandList bandList, RasterTask task) throws JNCSException, ProcessInterruptedException {
        int line;
        int[] b;
        int i;
        int bandB;
        int bandR = readBands[0];
        int bandG = readBands.length > 1 ? readBands[1] : -1;
        int n = bandB = readBands.length > 2 ? readBands[2] : -1;
        if (this.file.numBands == 3 && bandList.getDrawableBandsCount() < 3) {
            for (i = 0; i < 3; ++i) {
                b = bandList.getBand(i).getBufferBandListToDraw();
                if (b == null) continue;
                bandG = 1;
                bandR = 0;
                bandB = 2;
            }
        }
        if (this.file.numBands == 3 && bandR == bandG && bandG == bandB) {
            for (i = 0; i < 3; ++i) {
                b = bandList.getBand(i).getBufferBandListToDraw();
                if (b != null) {
                    if (i == 0) {
                        for (int line2 = 0; line2 < rasterBuf.getHeight(); ++line2) {
                            try {
                                this.file.readLineRGBA(pRGBArray);
                                for (int col = 0; col < pRGBArray.length; ++col) {
                                    rasterBuf.setElem(line2, col, bandR, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                                    rasterBuf.setElem(line2, col, bandG, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                                    rasterBuf.setElem(line2, col, bandB, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                                }
                                continue;
                            }
                            catch (JNCSException col) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (i == 1) {
                        for (int line3 = 0; line3 < rasterBuf.getHeight(); ++line3) {
                            try {
                                this.file.readLineRGBA(pRGBArray);
                                for (int col = 0; col < pRGBArray.length; ++col) {
                                    rasterBuf.setElem(line3, col, bandR, (byte)((pRGBArray[col] & 0xFF00) >> 8));
                                    rasterBuf.setElem(line3, col, bandG, (byte)((pRGBArray[col] & 0xFF00) >> 8));
                                    rasterBuf.setElem(line3, col, bandB, (byte)((pRGBArray[col] & 0xFF00) >> 8));
                                }
                                continue;
                            }
                            catch (JNCSException col) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                    if (i == 2) {
                        for (int line4 = 0; line4 < rasterBuf.getHeight(); ++line4) {
                            try {
                                this.file.readLineRGBA(pRGBArray);
                                for (int col = 0; col < pRGBArray.length; ++col) {
                                    rasterBuf.setElem(line4, col, bandR, (byte)(pRGBArray[col] & 0xFF));
                                    rasterBuf.setElem(line4, col, bandG, (byte)(pRGBArray[col] & 0xFF));
                                    rasterBuf.setElem(line4, col, bandB, (byte)(pRGBArray[col] & 0xFF));
                                }
                                continue;
                            }
                            catch (JNCSException jNCSException) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                if (task.getEvent() == null) continue;
                task.manageEvent(task.getEvent());
            }
        }
        if (bandR >= 0 && bandG >= 0 && bandB >= 0) {
            for (line = 0; line < rasterBuf.getHeight(); ++line) {
                try {
                    this.file.readLineRGBA(pRGBArray);
                    for (int col = 0; col < pRGBArray.length; ++col) {
                        rasterBuf.setElem(line, col, bandR, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                        rasterBuf.setElem(line, col, bandG, (byte)((pRGBArray[col] & 0xFF00) >> 8));
                        rasterBuf.setElem(line, col, bandB, (byte)(pRGBArray[col] & 0xFF));
                    }
                    continue;
                }
                catch (JNCSException col) {
                    // empty catch block
                }
            }
            return;
        }
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
        if (bandR >= 0 && bandG >= 0) {
            for (line = 0; line < rasterBuf.getHeight(); ++line) {
                try {
                    this.file.readLineRGBA(pRGBArray);
                    for (int col = 0; col < pRGBArray.length; ++col) {
                        rasterBuf.setElem(line, col, bandR, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                        rasterBuf.setElem(line, col, bandG, (byte)((pRGBArray[col] & 0xFF00) >> 8));
                    }
                    continue;
                }
                catch (JNCSException col) {
                    // empty catch block
                }
            }
            return;
        }
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
        if (bandR >= 0) {
            for (line = 0; line < rasterBuf.getHeight(); ++line) {
                try {
                    this.file.readLineRGBA(pRGBArray);
                    for (int col = 0; col < pRGBArray.length; ++col) {
                        rasterBuf.setElem(line, col, bandR, (byte)((pRGBArray[col] & 0xFF0000) >> 16));
                    }
                    continue;
                }
                catch (JNCSException jNCSException) {
                    // empty catch block
                }
            }
            return;
        }
        if (task.getEvent() != null) {
            task.manageEvent(task.getEvent());
        }
    }

    public void reProject(ICoordTrans rp) {
    }

    public int getBlockSize() {
        return 0;
    }

    public Object readCompleteLine(int line, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if (line < 0 || line >= this.file.height || band < 0 || band >= this.getBandCount()) {
            throw new InvalidSetViewException("Request out of grid");
        }
        Point2D begin = this.rasterToWorld(new Point2D.Double(0.0, line));
        Point2D end = this.rasterToWorld(new Point2D.Double(this.file.width, line + 1));
        int[] readBandsFromECW = new int[this.file.numBands];
        if (this.file.numBands <= 3) {
            for (int i = 0; i < this.file.numBands; ++i) {
                readBandsFromECW[i] = i;
            }
        } else {
            readBandsFromECW[0] = band;
        }
        ExtentImpl e = new ExtentImpl(begin.getX(), begin.getY(), end.getX(), end.getY());
        try {
            int[] value = new int[this.file.width];
            this.file.setView(this.file.numBands, readBandsFromECW, e.minX(), e.maxY(), e.maxX(), e.minY(), this.file.width, 1);
            this.file.readLineRGBA(value);
            if (this.file.numBands <= 3) {
                switch (this.getDataType()[0]) {
                    case 0: {
                        byte[] b = new byte[this.file.width];
                        switch (band) {
                            case 0: {
                                for (int i = 0; i < this.file.width; ++i) {
                                    b[i] = (byte)((value[i] & 0xFF0000) >> 16 & 0xFF);
                                }
                                break;
                            }
                            case 1: {
                                for (int i = 0; i < this.file.width; ++i) {
                                    b[i] = (byte)((value[i] & 0xFF00) >> 8 & 0xFF);
                                }
                                break;
                            }
                            case 2: {
                                for (int i = 0; i < this.file.width; ++i) {
                                    b[i] = (byte)(value[i] & 0xFF & 0xFF);
                                }
                                break;
                            }
                        }
                        return b;
                    }
                }
            } else {
                switch (this.getDataType()[0]) {
                    case 0: {
                        byte[] b = new byte[this.file.width];
                        for (int i = 0; i < this.file.width; ++i) {
                            b[i] = (byte)((value[i] & 0xFF0000) >> 16 & 0xFF);
                        }
                        break;
                    }
                }
            }
        }
        catch (JNCSFileNotOpenException e1) {
            throw new FileNotOpenException("Error en jecw: JNCSFileNotOpenException");
        }
        catch (JNCSInvalidSetViewException e1) {
            throw new FileNotOpenException("Error en jecw: JNCSInvalidSetViewException");
        }
        catch (JNCSException e1) {
            throw new RasterDriverException("Error la lectura de datos ecw");
        }
        return null;
    }

    public Object readBlock(int pos, int blockHeight, double scale) throws InvalidSetViewException, FileNotOpenException, RasterDriverException, ProcessInterruptedException {
        byte[][][] buf;
        block15: {
            RasterTask task = RasterTaskQueue.get((String)(Thread.currentThread().getId() + ""));
            if (pos < 0) {
                throw new InvalidSetViewException("Request out of grid");
            }
            if (pos + blockHeight > this.file.height) {
                blockHeight = Math.abs(this.file.height - pos);
            }
            Point2D begin = this.rasterToWorld(new Point2D.Double(0.0, pos));
            Point2D end = this.rasterToWorld(new Point2D.Double(this.file.width, pos + blockHeight));
            int[] readBandsFromECW = new int[this.file.numBands];
            for (int i = 0; i < this.file.numBands; ++i) {
                readBandsFromECW[i] = i;
            }
            buf = new byte[this.file.numBands][blockHeight][this.file.width];
            ExtentImpl e = new ExtentImpl(begin.getX(), begin.getY(), end.getX(), end.getY());
            e = this.rasterUtil.calculateAdjustedView(this.getExtent(), (Extent)e);
            try {
                int[] value = new int[this.file.width];
                this.file.setView(this.file.numBands, readBandsFromECW, e.minX(), e.maxY(), e.maxX(), e.minY(), this.file.width, blockHeight);
                if (this.file.numBands > 3) break block15;
                block8: for (int row = 0; row < blockHeight; ++row) {
                    this.file.readLineRGBA(value);
                    switch (this.getDataType()[0]) {
                        case 0: {
                            int col;
                            if (buf.length >= 3) {
                                for (col = 0; col < this.file.width; ++col) {
                                    buf[0][row][col] = (byte)((value[col] & 0xFF0000) >> 16 & 0xFF);
                                    buf[1][row][col] = (byte)((value[col] & 0xFF00) >> 8 & 0xFF);
                                    buf[2][row][col] = (byte)(value[col] & 0xFF & 0xFF);
                                }
                                continue block8;
                            }
                            for (col = 0; col < this.file.width; ++col) {
                                buf[0][row][col] = (byte)((value[col] & 0xFF0000) >> 16 & 0xFF);
                            }
                            continue block8;
                        }
                    }
                }
                if (task.getEvent() != null) {
                    task.manageEvent(task.getEvent());
                }
            }
            catch (JNCSFileNotOpenException e1) {
                throw new FileNotOpenException("Error en jecw: JNCSFileNotOpenException");
            }
            catch (JNCSInvalidSetViewException e1) {
                throw new FileNotOpenException("Error en jecw: JNCSInvalidSetViewException");
            }
            catch (JNCSException e1) {
                throw new RasterDriverException("Error la lectura de datos ecw");
            }
        }
        return buf;
    }

    public Object getData(int x, int y, int band) throws InvalidSetViewException, FileNotOpenException, RasterDriverException {
        if (x < 0 || y < 0 || x >= this.file.width || y >= this.file.height) {
            throw new InvalidSetViewException("Request out of grid");
        }
        Point2D.Double begin = new Point2D.Double(x, y);
        Point2D.Double end = new Point2D.Double(x + 1, y + 1);
        this.ownTransformation.transform(begin, begin);
        this.ownTransformation.transform(end, end);
        int[] readBandsFromECW = new int[this.file.numBands];
        if (this.file.numBands <= 3) {
            for (int i = 0; i < this.file.numBands; ++i) {
                readBandsFromECW[i] = i;
            }
        } else {
            readBandsFromECW[0] = band;
        }
        ExtentImpl e = new ExtentImpl(((Point2D)begin).getX(), ((Point2D)begin).getY(), ((Point2D)end).getX(), ((Point2D)end).getY());
        try {
            int[] value = new int[1];
            this.file.setView(this.file.numBands, readBandsFromECW, e.minX(), e.maxY(), e.maxX(), e.minY(), 1, 1);
            this.file.readLineRGBA(value);
            if (this.file.numBands <= 3) {
                switch (band) {
                    case 0: {
                        return new Integer((value[0] & 0xFF0000) >> 16 & 0xFFFFFFFF);
                    }
                    case 1: {
                        return new Integer((value[0] & 0xFF00) >> 8 & 0xFFFFFFFF);
                    }
                    case 2: {
                        return new Integer(value[0] & 0xFF & 0xFFFFFFFF);
                    }
                }
            }
            return new Integer((value[0] & 0xFF0000) >> 16 & 0xFFFFFFFF);
        }
        catch (JNCSFileNotOpenException e1) {
            throw new FileNotOpenException("Error en jecw: JNCSFileNotOpenException");
        }
        catch (JNCSInvalidSetViewException e1) {
            throw new FileNotOpenException("Error en jecw: JNCSInvalidSetViewException");
        }
        catch (JNCSException e1) {
            throw new RasterDriverException("Error reading ecw data");
        }
    }

    public void refreshUpdate(int arg0, int arg1, double arg2, double arg3, double arg4, double arg5) {
    }

    public void refreshUpdate(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5) {
    }

    public DataStoreColorInterpretation getColorInterpretation() {
        if (this.colorInterpr == null) {
            this.colorInterpr = new DataStoreColorInterpretation();
            this.colorInterpr.initColorInterpretation(this.getBandCount());
            if (this.getBandCount() == 1) {
                this.colorInterpr = DataStoreColorInterpretation.createGrayInterpretation();
            }
            if (this.getBandCount() == 3) {
                this.colorInterpr = DataStoreColorInterpretation.createRGBInterpretation();
            }
            if (this.getBandCount() >= 4) {
                this.colorInterpr = DataStoreColorInterpretation.createRGBAInterpretation();
            }
        }
        return this.colorInterpr;
    }

    public int getOverviewCount(int band) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewWidth(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public int getOverviewHeight(int band, int overview) throws BandAccessException, RasterDriverException {
        if (band >= this.getBandCount()) {
            throw new BandAccessException("Wrong band");
        }
        return 0;
    }

    public boolean isOverviewsSupported() {
        return false;
    }

    public String getStringProjection() throws RasterDriverException {
        return this.file.projection;
    }

    public String getWktProjection() {
        return null;
    }

    public String getProviderName() {
        return NAME;
    }

    public void setStatus(RasterProvider provider) {
        if (provider instanceof ErmapperProvider) {
            // empty if block
        }
    }

    public boolean isSupersamplingSupported() {
        return false;
    }

    public TileServer getTileServer() {
        if (this.tileServer == null) {
            DefaultRasterStore store = new DefaultRasterStore();
            store.setProvider((RasterProvider)this);
            this.tileServer = new FileTileServer((RasterDataStore)store);
        }
        return this.tileServer;
    }

    public void addFile(File file) throws InvalidSourceException {
    }

    public void removeFile(File file) {
    }
}

