/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import org.gvsig.fmap.mapcontrol.MapControl;
import org.gvsig.fmap.mapcontrol.MapControlDrawer;
import org.gvsig.fmap.mapcontrol.tools.Behavior.Behavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.IBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.MouseWheelBehavior;
import org.gvsig.fmap.mapcontrol.tools.Behavior.PointBehavior;
import org.gvsig.fmap.mapcontrol.tools.BehaviorException;
import org.gvsig.fmap.mapcontrol.tools.CompoundBehavior;
import org.gvsig.fmap.mapcontrol.tools.Listeners.PointListener;
import org.gvsig.fmap.mapcontrol.tools.Listeners.ToolListener;
import org.gvsig.fmap.mapcontrol.tools.PointSelectionListener;
import org.gvsig.vectorediting.swing.api.EditingContext;
import org.gvsig.vectorediting.swing.api.EditingSwingLocator;
import org.gvsig.vectorediting.swing.api.EditingSwingManager;

public class EditingCompoundBehavior
extends CompoundBehavior {
    private Mode mode = Mode.EDITING;
    private IBehavior editing;
    private IBehavior selection;
    public static final int EDITING_INDEX = 0;
    public static final int SELECTION_INDEX = 1;

    public EditingCompoundBehavior(IBehavior editing) {
        super(new Behavior[0]);
        this.editing = editing;
        this.selection = null;
    }

    public void addMapBehavior(Behavior mt, boolean draw) {
        if (mt instanceof MouseWheelBehavior) {
            return;
        }
        throw new UnsupportedOperationException();
    }

    public void removeMapBehavior(Behavior mt) {
        throw new UnsupportedOperationException();
    }

    public boolean containsBehavior(Behavior mt) {
        return mt == this.editing || mt == this.selection;
    }

    public Behavior getBehavior(int index) {
        switch (index) {
            case 0: {
                return (Behavior)this.editing;
            }
            case 1: {
                return (Behavior)this.selection;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    public boolean isDrawnBehavior(int index) {
        switch (this.mode) {
            case EDITING: {
                return index == 0;
            }
            case SELECTION: {
                return index == 1;
            }
        }
        return false;
    }

    public void setDrawnBehavior(int index, boolean draw) {
        switch (index) {
            case 0: {
                if (draw) {
                    this.mode = Mode.EDITING;
                    break;
                }
                this.mode = Mode.SELECTION;
                break;
            }
            case 1: {
                if (draw) {
                    this.mode = Mode.SELECTION;
                    break;
                }
                this.mode = Mode.EDITING;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }

    public int size() {
        return 2;
    }

    public Image getImageCursor() {
        switch (this.mode) {
            default: {
                return this.editing.getImageCursor();
            }
            case SELECTION: 
        }
        return this.selection.getImageCursor();
    }

    private EditingContext getEditingContext() {
        EditingSwingManager swingManager = EditingSwingLocator.getSwingManager();
        EditingContext editingContext = swingManager.getEditingContext(this.getMapControl());
        return editingContext;
    }

    public void mouseClicked(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseClicked(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseClicked(e);
            }
        }
    }

    public void mouseDragged(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseDragged(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseDragged(e);
            }
        }
    }

    public void mouseEntered(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseEntered(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseEntered(e);
            }
        }
    }

    public void mouseExited(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseExited(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseExited(e);
            }
        }
    }

    public void mouseMoved(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseMoved(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseMoved(e);
            }
        }
    }

    public void mousePressed(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mousePressed(e);
                break;
            }
            case SELECTION: {
                this.selection.mousePressed(e);
            }
        }
    }

    public void mouseReleased(MouseEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseReleased(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseReleased(e);
            }
        }
    }

    public void mouseWheelMoved(MouseWheelEvent e) throws BehaviorException {
        switch (this.mode) {
            default: {
                this.editing.mouseWheelMoved(e);
                break;
            }
            case SELECTION: {
                this.selection.mouseWheelMoved(e);
            }
        }
    }

    public void paintComponent(MapControlDrawer renderer, boolean clean) {
        if (clean) {
            this.clean(renderer);
        }
        this.paintComponent(renderer);
    }

    public void paintComponent(MapControlDrawer renderer) {
        switch (this.mode) {
            default: {
                this.editing.paintComponent(renderer);
                break;
            }
            case SELECTION: {
                this.selection.paintComponent(renderer);
            }
        }
    }

    public void setListener(ToolListener listener) {
        if (listener != null) {
            throw new UnsupportedOperationException("CompoundBehavior does not have listeners");
        }
    }

    public ToolListener getListener() {
        return null;
    }

    public void setMapControl(MapControl mc) {
        this.editing.setMapControl(mc);
        if (this.selection == null) {
            if (mc != null) {
                PointSelectionListener psl = new PointSelectionListener(mc);
                this.selection = new CompoundBehavior(new Behavior[]{new PointBehavior((PointListener)psl)});
                this.selection.setMapControl(mc);
            }
        } else {
            this.selection.setMapControl(mc);
        }
    }

    private static enum Mode {
        EDITING,
        SELECTION;

    }
}

