/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.swing.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.temporarystorage.TemporaryStorageGroup;
import org.gvsig.temporarystorage.TemporaryStorageLocator;
import org.gvsig.temporarystorage.TemporaryStorageManager;

public class EditingContextSymbolTable
extends AbstractSymbolTable {
    private final List<Point> lastPoints = new ListWithMaximumSize<Point>(100);
    private final TemporaryStorageGroup globalPointsStorage;

    public EditingContextSymbolTable() {
        TemporaryStorageManager manager = TemporaryStorageLocator.getTemporaryStorageManager();
        this.globalPointsStorage = manager.create("Points", Point.class);
        this.addSymbolTable((SymbolTable)ExpressionUtils.createSymbolTable());
        this.addSymbolTable(ExpressionUtils.createBookmarksSymbolTable((String)"VectorEditingInsertPoints"));
    }

    public void addPoint(Point point) {
        this.lastPoints.add(point);
    }

    public boolean exists(String name) {
        if (this.globalPointsStorage.contains(name)) {
            return true;
        }
        if (this.globalPointsStorage.contains(name + "$x")) {
            return true;
        }
        if (this.globalPointsStorage.contains(name + "$y")) {
            return true;
        }
        if (this.lastPoints.isEmpty() || StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        name = name.toLowerCase();
        int index = -1;
        if (name.length() == 2) {
            index = this.lastPoints.size() - 1;
        } else {
            if (name.length() < 3) {
                return false;
            }
            try {
                index = Integer.parseUnsignedInt(name.substring(2));
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        if (index < 0 || index >= this.lastPoints.size()) {
            return false;
        }
        return name.startsWith("$p") || name.startsWith("$x") || name.startsWith("$y");
    }

    public Object value(String name) {
        if (this.globalPointsStorage.contains(name)) {
            return this.globalPointsStorage.get(name);
        }
        if (this.globalPointsStorage.contains(name + "$x")) {
            Point point = (Point)this.globalPointsStorage.get(name + "$x");
            return point.getX();
        }
        if (this.globalPointsStorage.contains(name + "$y")) {
            Point point = (Point)this.globalPointsStorage.get(name + "$y");
            return point.getY();
        }
        if (this.lastPoints.isEmpty() || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        name = name.toLowerCase();
        int index = -1;
        if (name.length() == 2) {
            index = 0;
        } else {
            if (name.length() < 3) {
                return null;
            }
            try {
                index = Integer.parseUnsignedInt(name.substring(2));
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        if (index < 0 || index >= this.lastPoints.size()) {
            return false;
        }
        index = this.lastPoints.size() - index - 1;
        if (name.startsWith("$p")) {
            Point point = this.lastPoints.get(index);
            return point;
        }
        if (name.startsWith("$x")) {
            Point point = this.lastPoints.get(index);
            return point.getX();
        }
        if (name.startsWith("$y")) {
            Point point = this.lastPoints.get(index);
            return point.getY();
        }
        return null;
    }

    public Collection<String> localvariables() {
        if (this.lastPoints.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> names = new ArrayList<String>();
        names.add("$p");
        names.add("$x");
        names.add("$y");
        for (int i = 0; i < this.lastPoints.size(); ++i) {
            names.add("$p" + i);
            names.add("$x" + i);
            names.add("$y" + i);
        }
        return names;
    }

    private static class ListWithMaximumSize<T>
    extends ArrayList<T> {
        private final int maximumSize;

        public ListWithMaximumSize(int maximumSize) {
            this.maximumSize = maximumSize;
        }

        @Override
        public boolean add(T e) {
            if (this.size() > this.maximumSize) {
                this.remove(0);
            }
            return super.add(e);
        }

        @Override
        public void add(int index, T element) {
            if (this.size() > this.maximumSize) {
                this.remove(0);
            }
            super.add(index, element);
        }
    }
}

