/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.tools.swing.api;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.FocusTraversalPolicy;
import java.awt.GraphicsEnvironment;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.InitComponentsListener;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.icontheme.IconTheme;
import org.gvsig.tools.swing.icontheme.IconThemeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToolsSwingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolsSwingUtils.class);
    private static double pixelsXrow = -1.0;
    private static double pixelsXcolumn = -1.0;
    public static final int ICON_GROUP = 0;
    public static final int ICON_NAME = 1;
    public static final int ICON_SUBGROUP = 2;
    public static final int ICON_DESCRIPTION = 3;
    public static final int RELATIVE_TO_SCREEN = 0;
    public static final int RELATIVE_TO_DESKTOPPANE = 1;

    private ToolsSwingUtils() {
    }

    private static void calculateRowsCols2Pixels() {
        String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPRSTUVWXYZ[]()!?|_/@";
        JLabel label = new JLabel(s);
        Dimension dim = label.getPreferredSize();
        pixelsXrow = dim.height;
        pixelsXcolumn = dim.width / s.length();
    }

    public static int rows2px(int rows) {
        if (pixelsXrow == -1.0) {
            ToolsSwingUtils.calculateRowsCols2Pixels();
        }
        return (int)((double)rows * pixelsXrow);
    }

    public static int cols2px(int cols) {
        if (pixelsXcolumn == -1.0) {
            ToolsSwingUtils.calculateRowsCols2Pixels();
        }
        return (int)((double)cols * pixelsXcolumn);
    }

    public static Dimension rowscols2dimension(int rows, int cols) {
        return new Dimension(ToolsSwingUtils.cols2px(cols), ToolsSwingUtils.rows2px(rows));
    }

    public static Dimension ensureRowsCols(JComponent comp, int rows, int cols) {
        Dimension dim = comp.getPreferredSize();
        dim = ToolsSwingUtils.ensureRowsCols(dim, rows, cols);
        comp.setPreferredSize(dim);
        return dim;
    }

    public static Dimension ensureRowsCols(Dimension dim, int rows, int cols) {
        int w;
        int h = ToolsSwingUtils.rows2px(rows);
        if (dim.height < h) {
            dim.height = h;
        }
        if (dim.width < (w = ToolsSwingUtils.cols2px(cols))) {
            dim.width = w;
        }
        return dim;
    }

    public static Dimension ensureMaxRows(JComponent comp, int rows) {
        Dimension dim = comp.getPreferredSize();
        int h = ToolsSwingUtils.rows2px(rows);
        if (dim.height > h) {
            dim.height = h;
            comp.setPreferredSize(dim);
        }
        return dim;
    }

    public static Dimension ensureMaxRows(Dimension dim, int rows) {
        int h = ToolsSwingUtils.rows2px(rows);
        if (dim.height > h) {
            dim.height = h;
        }
        return dim;
    }

    public static Dimension ensureRows(JComponent comp, int rows) {
        Dimension dim = comp.getPreferredSize();
        comp.setPreferredSize(dim);
        int h = ToolsSwingUtils.rows2px(rows);
        if (dim.height < h) {
            dim.height = h;
            comp.setPreferredSize(dim);
        }
        return dim;
    }

    public static Dimension ensureRows(Dimension dim, int rows) {
        int h = ToolsSwingUtils.rows2px(rows);
        if (dim.height < h) {
            dim.height = h;
        }
        return dim;
    }

    public static Dimension ensureCols(JComponent comp, int cols) {
        Dimension dim = comp.getPreferredSize();
        comp.setPreferredSize(dim);
        int w = ToolsSwingUtils.cols2px(cols);
        if (dim.width < w) {
            dim.width = w;
            comp.setPreferredSize(dim);
        }
        return dim;
    }

    public static Dimension ensureCols(Dimension dim, int cols) {
        int w = ToolsSwingUtils.cols2px(cols);
        if (dim.width < w) {
            dim.width = w;
        }
        return dim;
    }

    public static Dimension ensureRowsCols(Dimension dim, int minRows, int minCols, int maxRows, int maxCols) {
        int maxw;
        int maxh;
        int minw;
        int minh;
        if (minRows > 0 && dim.height < (minh = ToolsSwingUtils.rows2px(minRows))) {
            dim.height = minh;
        }
        if (minCols > 0 && dim.width < (minw = ToolsSwingUtils.cols2px(minCols))) {
            dim.width = minw;
        }
        if (maxRows > 0 && dim.height > (maxh = ToolsSwingUtils.rows2px(maxRows))) {
            dim.height = maxh;
        }
        if (maxCols > 0 && dim.width > (maxw = ToolsSwingUtils.cols2px(maxCols))) {
            dim.width = maxw;
        }
        return dim;
    }

    public static Dimension ensureRowsCols(JComponent comp, int minRows, int minCols, int maxRows, int maxCols) {
        Dimension dim = comp.getPreferredSize();
        comp.setPreferredSize(ToolsSwingUtils.ensureRowsCols(dim, minRows, minCols, maxRows, maxCols));
        return dim;
    }

    public static Dimension ensureHeightWitdh(Dimension dim, int minHeigh, int minWitdh, int maxHeigh, int maxWitdh) {
        if (minHeigh > 0 && dim.height < minHeigh) {
            dim.height = minHeigh;
        }
        if (minWitdh > 0 && dim.width < minWitdh) {
            dim.width = minWitdh;
        }
        if (maxHeigh > 0 && dim.height > maxHeigh) {
            dim.height = maxHeigh;
        }
        if (maxWitdh > 0 && dim.width > maxWitdh) {
            dim.width = maxWitdh;
        }
        return dim;
    }

    public static Dimension ensureHeightWitdh(JComponent comp, int minHeigh, int minWitdh, int maxHeigh, int maxWitdh) {
        Dimension dim = comp.getPreferredSize();
        comp.setPreferredSize(ToolsSwingUtils.ensureHeightWitdh(dim, minHeigh, minWitdh, maxHeigh, maxWitdh));
        return dim;
    }

    public static JSplitPane createVerticalSplit(JPanel container, JPanel top, boolean scrolltop, JPanel bottom, boolean scrollbottom) {
        JComponent compTop = top;
        JComponent compBottom = bottom;
        if (scrolltop) {
            compTop = new JScrollPane(top, 20, 31);
            compTop.setBorder(null);
        }
        if (scrollbottom) {
            compBottom = new JScrollPane(bottom, 20, 31);
            compBottom.setBorder(null);
        }
        JSplitPane split = new JSplitPane(0, false, compTop, compBottom);
        split.setBorder(null);
        split.setOneTouchExpandable(true);
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add((java.awt.Component)split, "Center");
        return split;
    }

    public static JSplitPane createHorizontalSplit(JPanel container, JPanel left, boolean scrollleft, JPanel right, boolean scrollright) {
        JComponent compLeft = left;
        JComponent compRight = right;
        if (scrollleft) {
            compLeft = new JScrollPane(left, 20, 31);
        }
        if (scrollright) {
            compRight = new JScrollPane(right, 20, 31);
        }
        JSplitPane split = new JSplitPane(1, false, compLeft, compRight);
        split.setOneTouchExpandable(true);
        container.removeAll();
        container.setLayout(new BorderLayout());
        container.add((java.awt.Component)split, "Center");
        return split;
    }

    public static ImageIcon loadImage(Object obj, String imagepath) {
        String name = FilenameUtils.getBaseName((String)imagepath);
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        if (theme.exists(name)) {
            return theme.get(name);
        }
        URL url = obj.getClass().getResource("images/" + name + ".png");
        if (url == null && (url = obj.getClass().getResource(name + ".png")) == null) {
            return null;
        }
        return new ImageIcon(url);
    }

    public static void waitCursor(java.awt.Component component, Runnable action) {
        Cursor saved_cursor = component.getCursor();
        try {
            component.setCursor(Cursor.getPredefinedCursor(3));
            action.run();
        }
        finally {
            component.setCursor(saved_cursor);
        }
    }

    public static void addWindowClosedListener(final JComponent c, final ActionListener listener) {
        final WindowAdapter windowListener = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    listener.actionPerformed(new ActionEvent(c, 0, "windowclosing"));
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't perform on window closing action.", (Throwable)ex);
                }
            }

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    listener.actionPerformed(new ActionEvent(c, 0, "windowclosing"));
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't perform on window closing action.", (Throwable)ex);
                }
            }
        };
        final ComponentAdapter componentListener = new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                try {
                    listener.actionPerformed(new ActionEvent(c, 0, "windowclosing"));
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't perform on window closing action.", (Throwable)ex);
                }
            }
        };
        final InternalFrameAdapter internalFrameListener = new InternalFrameAdapter(){

            @Override
            public void internalFrameClosing(InternalFrameEvent e) {
                try {
                    listener.actionPerformed(new ActionEvent(c, 0, "windowclosing"));
                }
                catch (Exception ex) {
                    LOGGER.debug("Can't perform on window closing action.", (Throwable)ex);
                }
            }
        };
        final ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        c.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                Container cont = toolsSwingManager.findRootContainer(c);
                if (cont instanceof Window) {
                    Window win = (Window)cont;
                    Object[] lsn = (WindowListener[])win.getListeners(WindowListener.class);
                    if (ArrayUtils.contains((Object[])lsn, (Object)windowListener)) {
                        return;
                    }
                    win.addWindowListener(windowListener);
                    win.addComponentListener(componentListener);
                } else if (cont instanceof JInternalFrame) {
                    JInternalFrame frame = (JInternalFrame)cont;
                    Object[] lsn = (InternalFrameListener[])frame.getListeners(InternalFrameListener.class);
                    if (ArrayUtils.contains((Object[])lsn, (Object)internalFrameListener)) {
                        return;
                    }
                    frame.addInternalFrameListener(internalFrameListener);
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public static java.awt.Component findNextFocus() {
        java.awt.Component c = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        Container root = c.getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = root.getFocusTraversalPolicy();
        java.awt.Component nextFocus = policy.getComponentAfter(root, c);
        if (nextFocus == null) {
            nextFocus = policy.getDefaultComponent(root);
        }
        return nextFocus;
    }

    public static AbstractButton configurePickersButton(AbstractButton button, String tip, String image, ActionListener actionListener, FocusListener focusListener) {
        if (button.getIcon() == null && image != null) {
            IconThemeManager iconThemeManager = ToolsSwingLocator.getIconThemeManager();
            IconTheme theme = iconThemeManager.getCurrent();
            ImageIcon icon = theme.get(image);
            button.setIcon(icon);
        }
        if (button.getText().trim().equals("...")) {
            button.setText("");
        }
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setBorderPainted(false);
        button.setFocusPainted(true);
        button.setContentAreaFilled(true);
        button.setCursor(new Cursor(12));
        if (StringUtils.isNotBlank((CharSequence)tip)) {
            if (tip.startsWith("_")) {
                tip = ToolsLocator.getI18nManager().getTranslation(tip);
            }
            button.setToolTipText(tip);
        }
        if (actionListener != null) {
            button.addActionListener(actionListener);
        }
        if (focusListener != null) {
            button.addFocusListener(focusListener);
        }
        return button;
    }

    public static boolean registerIcons(Class klass, String resourcePrefix, String provider, String[] ... iconsInfo) {
        boolean r = true;
        String group = null;
        String subgroup = null;
        String icon = null;
        String description = null;
        IconTheme theme = null;
        String iconName = null;
        String resourceName = null;
        URL url = null;
        IconTheme.Icon themeIcon = null;
        try {
            if (klass == null) {
                throw new IllegalArgumentException("Can't load icons, class is null");
            }
            if (StringUtils.isBlank((CharSequence)provider)) {
                throw new IllegalArgumentException("Can't load icons, provider is blank");
            }
            if (StringUtils.isBlank((CharSequence)resourcePrefix)) {
                resourcePrefix = "";
            } else if (!resourcePrefix.endsWith("/")) {
                resourcePrefix = resourcePrefix + "/";
            }
            theme = ToolsSwingLocator.getIconThemeManager().getDefault();
            for (String[] iconInfo : iconsInfo) {
                group = null;
                subgroup = null;
                icon = null;
                description = null;
                switch (iconInfo.length) {
                    case 4: {
                        description = iconInfo[3];
                    }
                    case 3: {
                        subgroup = iconInfo[2];
                    }
                }
                group = iconInfo[0];
                icon = iconInfo[1];
                try {
                    if (StringUtils.isBlank((CharSequence)icon)) {
                        throw new IllegalArgumentException("Can't load icon from '" + klass.getName() + "', icon name is blank");
                    }
                    if (StringUtils.isBlank((CharSequence)provider)) {
                        throw new IllegalArgumentException("Can't load icon '" + icon + "', provider is blank");
                    }
                    if (StringUtils.isBlank((CharSequence)group)) {
                        throw new IllegalArgumentException("Can't load icon '" + icon + "', group is blank");
                    }
                    iconName = FilenameUtils.getBaseName((String)icon);
                    resourceName = resourcePrefix + icon + ".png";
                    url = klass.getResource(resourceName);
                    if (url == null && (url = klass.getResource(resourceName = resourcePrefix + icon + ".gif")) == null) {
                        throw new IllegalArgumentException("Can't load icon '" + icon + "' from resource '" + resourcePrefix + icon + ".png/gif" + "' with class '" + klass.getSimpleName() + "'.");
                    }
                    themeIcon = theme.registerDefault(provider, group, subgroup, iconName, null, url);
                    if (!StringUtils.isNotBlank((CharSequence)description)) continue;
                    themeIcon.setDescription(description);
                }
                catch (Throwable t) {
                    LOGGER.warn("Can't load icon '" + icon + "'.", t);
                    r = false;
                }
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Can't load icons.", t);
            r = false;
        }
        return r;
    }

    public static void registerGroupIconDescription(String group, String description) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        theme.setGroupDescription(group, description);
    }

    public static void registerGroupIconScreenshot(Class klass, String group, String path) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        URL resource = klass.getResource(path);
        if (resource == null) {
            LOGGER.warn("Can't load screenshot for '" + group + "' from '" + path + "'.");
            return;
        }
        theme.addGroupImage(group, resource);
    }

    public static void registerSubgroupIconScreenshot(Class klass, String group, String subgroup, String path) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        URL resource = klass.getResource(path);
        if (resource == null) {
            LOGGER.warn("Can't load screenshot for '" + group + "/" + subgroup + "' from '" + path + "'.");
            return;
        }
        theme.addSubgroupImage(group, subgroup, resource);
    }

    public static void registerSubgroupIconDescription(String group, String subgroup, String description) {
        IconTheme theme = ToolsSwingLocator.getIconThemeManager().getDefault();
        theme.setSubgroupDescription(group, subgroup, description);
    }

    public static Dimension getCurrentScreenSize() {
        GraphicsEnvironment lge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        DisplayMode dm = lge.getDefaultScreenDevice().getDisplayMode();
        Rectangle maxWindowBounds = lge.getMaximumWindowBounds();
        Dimension screensize = new Dimension(Math.min(dm.getWidth(), (int)maxWindowBounds.getWidth()), Math.min(dm.getHeight(), (int)maxWindowBounds.getHeight()));
        return screensize;
    }

    public static Dimension getDesktopPanelSize() {
        return ToolsSwingLocator.getToolsSwingManager().getDesktopPanelSize();
    }

    public static Dimension ensureHeightWitdh(Component comp, int relativeto, float minHeighPercent, float minWidthPercent, float maxHeighPercent, float maxWidthPercent, int minHeigh, int minWitdh) {
        return ToolsSwingUtils.ensureHeightWitdh(comp.asJComponent(), relativeto, minHeighPercent, minWidthPercent, maxHeighPercent, maxWidthPercent, minHeigh, minWitdh);
    }

    public static Dimension ensureHeightWitdh(Component comp, int relativeto, float minHeighPercent, float minWidthPercent, float maxHeighPercent, float maxWidthPercent) {
        return ToolsSwingUtils.ensureHeightWitdh(comp.asJComponent(), relativeto, minHeighPercent, minWidthPercent, maxHeighPercent, maxWidthPercent, -1, -1);
    }

    public static Dimension ensureHeightWitdh(JComponent comp, int relativeto, float minHeighPercent, float minWidthPercent, float maxHeighPercent, float maxWidthPercent) {
        return ToolsSwingUtils.ensureHeightWitdh(comp, relativeto, minHeighPercent, minWidthPercent, maxHeighPercent, maxWidthPercent, -1, -1);
    }

    public static Dimension ensureHeightWitdh(JComponent comp, int relativeto, float minHeighPercent, float minWidthPercent, float maxHeighPercent, float maxWidthPercent, int minHeigh, int minWitdh) {
        Dimension screensize;
        switch (relativeto) {
            case 1: {
                screensize = ToolsSwingUtils.getDesktopPanelSize();
                break;
            }
            default: {
                screensize = ToolsSwingUtils.getCurrentScreenSize();
            }
        }
        if (minHeigh < 1 || minWitdh < 1) {
            Dimension prefsize = comp.getPreferredSize();
            if (minHeigh < 1) {
                minHeigh = prefsize.height;
            }
            if (minWitdh < 1) {
                minWitdh = prefsize.width;
            }
        }
        Dimension dim = ToolsSwingUtils.ensureHeightWitdh(comp, (int)Math.max(minHeighPercent * (float)screensize.height, (float)minHeigh), (int)Math.max(minWidthPercent * (float)screensize.width, (float)minWitdh), (int)maxHeighPercent * screensize.height, (int)maxHeighPercent * screensize.width);
        return dim;
    }

    public static void addInitComponentsListener(JComponent c, final InitComponentsListener l) {
        ToolsSwingUtils.addWindowClosedListener(c, e -> l.doDisposeComponents());
        c.addAncestorListener(new AncestorListener(){
            private boolean initialized = false;

            @Override
            public void ancestorAdded(AncestorEvent event) {
                if (!this.initialized) {
                    l.doInitComponents();
                    this.initialized = true;
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    public static String makeTitle(String base, String docname, String docname2) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        base = i18n.getTranslation(base);
        String title = base + ": " + docname;
        if (StringUtils.isNotBlank((CharSequence)docname2) && !StringUtils.equals((CharSequence)docname, (CharSequence)docname2)) {
            title = title + " (" + docname2 + ")";
        }
        return title;
    }

    public static final String toHTML(String s) {
        s = StringEscapeUtils.escapeHtml3((String)s);
        s = StringUtils.replace((String)s, (String)"\n", (String)"\n<br>");
        s = StringUtils.replace((String)s, (String)"\u00e1", (String)"&#225;");
        s = StringUtils.replace((String)s, (String)"\u00e9", (String)"&#233;");
        s = StringUtils.replace((String)s, (String)"\u00ed", (String)"&#237;");
        s = StringUtils.replace((String)s, (String)"\u00f3", (String)"&#243;");
        s = StringUtils.replace((String)s, (String)"\u00fa", (String)"&#250;");
        s = StringUtils.replace((String)s, (String)"\u00f1", (String)"&#241;");
        s = StringUtils.replace((String)s, (String)"\u00d1", (String)"&#209;");
        s = StringUtils.replace((String)s, (String)"\u00e7", (String)"&#231;");
        s = StringUtils.replace((String)s, (String)"\u00c7", (String)"&#199;");
        return s;
    }
}

