/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import com.vividsolutions.jts.geom.Geometry;
import java.util.HashMap;
import java.util.Iterator;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;
import org.gvsig.tools.util.CompareUtils;

public class DissolveRule
implements IDissolveRule {
    protected String nameField = null;
    private HashMap<String, String> funcMap = null;

    public DissolveRule(String nameField, HashMap<String, String> funcMap) {
        this.nameField = nameField;
        this.funcMap = funcMap;
    }

    @Override
    public boolean verifyIfDissolve(Geometry g1, Geometry g2, Feature f1, Feature f2) {
        Object obj1 = f1.get(this.nameField);
        Object obj2 = f2.get(this.nameField);
        return this.compareTo(obj1, obj2);
    }

    @Override
    public boolean isFunctionIncluded(String func) {
        Iterator<String> it = this.funcMap.values().iterator();
        while (it.hasNext()) {
            if (it.next().compareTo(func) != 0) continue;
            return true;
        }
        return false;
    }

    private boolean compareTo(Object obj1, Object obj2) {
        if (obj1 instanceof Comparable && obj2 instanceof Comparable) {
            return CompareUtils.compare((Comparable)((Comparable)obj1), (Comparable)((Comparable)obj2)) == 0;
        }
        return false;
    }

    @Override
    public String getFieldName(String func) {
        return this.funcMap.get(func);
    }

    @Override
    public String getFieldName() {
        return this.nameField;
    }
}

