/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.text.ParseException;
import java.util.Date;
import net.jcip.annotations.ThreadSafe;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionManager;
import thredds.inventory.FeatureCollectionConfig;

@ThreadSafe
public enum CollectionUpdater {
    INSTANCE;

    private static final Logger logger;
    private static final String FC_NAME = "fc";
    private static final long startupWait = 30000L;
    private Scheduler scheduler = null;
    private boolean failed = false;

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTasks(FeatureCollectionConfig config, CollectionManager manager) {
        if (this.failed) {
            return;
        }
        FeatureCollectionConfig.UpdateConfig update = config.updateConfig;
        if (!update.startup && update.rescan == null && config.protoConfig.change == null) {
            return;
        }
        CollectionUpdater collectionUpdater = this;
        synchronized (collectionUpdater) {
            if (!this.failed && this.scheduler == null) {
                StdSchedulerFactory schedFact = new StdSchedulerFactory();
                try {
                    this.scheduler = schedFact.getScheduler();
                    this.scheduler.start();
                }
                catch (SchedulerException e) {
                    this.failed = true;
                    throw new RuntimeException("quartz scheduler failed to initialize", e);
                }
            }
        }
        JobDetail updateJob = new JobDetail(config.spec, "UpdateCollection", UpdateCollectionJob.class);
        JobDataMap map = new JobDataMap();
        map.put((Object)FC_NAME, (Object)manager);
        updateJob.setJobDataMap(map);
        if (update.startup) {
            Date runTime = new Date(new Date().getTime() + 30000L);
            SimpleTrigger trigger0 = new SimpleTrigger(config.spec, "startup", runTime);
            try {
                this.scheduler.scheduleJob(updateJob, (Trigger)trigger0);
                logger.info("Schedule startup scan for " + config.spec + " at " + runTime);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule startup Job", e);
            }
        }
        if (update.rescan != null) {
            try {
                CronTrigger trigger1 = new CronTrigger(config.spec, "rescan", update.rescan);
                if (update.startup) {
                    trigger1.setJobName(updateJob.getName());
                    trigger1.setJobGroup(updateJob.getGroup());
                    this.scheduler.scheduleJob((Trigger)trigger1);
                } else {
                    this.scheduler.scheduleJob(updateJob, (Trigger)trigger1);
                }
                logger.info("Schedule recurring scan for " + config.spec + " cronExpr=" + update.rescan);
            }
            catch (ParseException e) {
                logger.error("cronExecutor failed: bad cron expression= " + update.rescan, e);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule cron Job", e);
            }
        }
        FeatureCollectionConfig.ProtoConfig pconfig = config.protoConfig;
        if (pconfig.change != null) {
            JobDetail protoJob = new JobDetail(config.spec, "UpdateProto", ChangeProtoJob.class);
            JobDataMap pmap = new JobDataMap();
            pmap.put((Object)FC_NAME, (Object)manager);
            protoJob.setJobDataMap(pmap);
            try {
                CronTrigger trigger2 = new CronTrigger(config.spec, "rereadProto", pconfig.change);
                this.scheduler.scheduleJob(protoJob, (Trigger)trigger2);
                logger.info("Schedule Reread Proto for " + config.spec);
            }
            catch (ParseException e) {
                logger.error("cronExecutor failed: RereadProto has bad cron expression= " + pconfig.change, e);
            }
            catch (SchedulerException e) {
                logger.error("cronExecutor failed to schedule RereadProtoJob", e);
            }
        }
    }

    public void shutdown() {
        if (this.scheduler == null) {
            return;
        }
        try {
            this.scheduler.shutdown(true);
            Logger logServerStartup = LoggerFactory.getLogger("serverStartup");
            logServerStartup.info("Scheduler shutdown");
        }
        catch (SchedulerException e) {
            logger.error("Scheduler failed to shutdown", e);
            this.scheduler = null;
        }
    }

    static {
        logger = LoggerFactory.getLogger(CollectionUpdater.class);
    }

    public static class ChangeProtoJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.FC_NAME);
                logger.info("Trigger resetProto for " + manager.getCollectionName());
                manager.resetProto();
            }
            catch (Throwable e) {
                logger.error("RereadProtoJob failed", e);
            }
        }
    }

    public static class UpdateCollectionJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            try {
                CollectionManager manager = (CollectionManager)context.getJobDetail().getJobDataMap().get((Object)CollectionUpdater.FC_NAME);
                logger.info("Trigger rescan for " + manager.getCollectionName());
                manager.rescan();
            }
            catch (Throwable e) {
                logger.error("InitFmrcJob failed", e);
            }
        }
    }
}

