/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import java.awt.Dimension;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.JComponent;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.AddLayer;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.fmap.dal.EditingNotificationManager;
import org.gvsig.fmap.dal.swing.DALSwingLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.arguments.Arguments;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observer;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.swing.api.threadsafedialogs.ThreadSafeDialogsManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vcsgis.app.EditingNotificationObserver;
import org.gvsig.vcsgis.app.VCSGisDialogsHelper;
import org.gvsig.vcsgis.app.VCSGisSwingServicesImpl;
import org.gvsig.vcsgis.app.addlayer.WizardVCSGisTabular;
import org.gvsig.vcsgis.app.addlayer.WizardVCSGisVectorial;
import org.gvsig.vcsgis.app.preferencespages.VCSGisPage;
import org.gvsig.vcsgis.lib.VCSGisEntity;
import org.gvsig.vcsgis.lib.VCSGisLocator;
import org.gvsig.vcsgis.lib.VCSGisManager;
import org.gvsig.vcsgis.lib.workspace.VCSGisWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJAddToWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJBackupHistory;
import org.gvsig.vcsgis.swing.VCSGisJCheckout;
import org.gvsig.vcsgis.swing.VCSGisJCheckoutDataModel;
import org.gvsig.vcsgis.swing.VCSGisJCreateResourceTable;
import org.gvsig.vcsgis.swing.VCSGisJDownloadWorkingcopy;
import org.gvsig.vcsgis.swing.VCSGisJExport;
import org.gvsig.vcsgis.swing.VCSGisJImportHistory;
import org.gvsig.vcsgis.swing.VCSGisJInitServer;
import org.gvsig.vcsgis.swing.VCSGisJInitWorkspace;
import org.gvsig.vcsgis.swing.VCSGisJLogout;
import org.gvsig.vcsgis.swing.VCSGisJPrepareWorkingcopy;
import org.gvsig.vcsgis.swing.VCSGisJRestoreHistory;
import org.gvsig.vcsgis.swing.VCSGisJSetWorkingCopyOffline;
import org.gvsig.vcsgis.swing.VCSGisJShowServerTableForm;
import org.gvsig.vcsgis.swing.VCSGisPanel;
import org.gvsig.vcsgis.swing.VCSGisSwingLocator;
import org.gvsig.vcsgis.swing.VCSGisSwingManager;
import org.gvsig.vcsgis.swing.VCSGisSwingServices;

public class VCSGisExtension
extends Extension
implements IPreferenceExtension {
    private VCSGisDialogsHelper dialogsHelper;

    public void initialize() {
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/action", (String)"vcsgis", (String[][])new String[][]{{"action", "tools-vcsgis-init-server", "vcsgis"}, {"action", "tools-vcsgis-init-workspace", "vcsgis"}, {"action", "tools-vcsgis-add-to-workspace", "vcsgis"}, {"action", "tools-vcsgis-export", "vcsgis"}, {"action", "tools-vcsgis-checkout", "vcsgis"}, {"action", "tools-vcsgis-showchanges", "vcsgis"}, {"action", "tools-vcsgis-register-workspace", "vcsgis"}, {"action", "tools-vcsgis-show-revisions", "vcsgis"}, {"action", "tools-vcsgis-checkout-datamodel", "vcsgis"}, {"action", "tools-vcsgis-download-workingcopy", "vcsgis"}});
        ToolsSwingUtils.registerSubgroupIconDescription((String)"action", (String)"vcsgis", (String)"Acciones asociadas a VCSGis.\nSe encuentran en el menu 'Heramientas/VCSGis'");
        this.dialogsHelper = new VCSGisDialogsHelper();
    }

    public void postInitialize() {
        super.postInitialize();
        ToolsSwingUtils.registerIcons(((Object)((Object)this)).getClass(), (String)"/images/preferences", (String)"vcsgis", (String[][])new String[][]{{"preferences", "vcsgis-preferences", "vcsgis"}});
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        VCSGisManager manager = VCSGisLocator.getVCSGisManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        swingManager.setDefaultServices((VCSGisSwingServices)new VCSGisSwingServicesImpl());
        DynObject pluginProperties = this.getPlugin().getPluginProperties();
        Map workspaces = (Map)pluginProperties.getDynValue("workspaces");
        manager.restoreWorkspaces(workspaces);
        swingManager.setEmptyEffectiveDateAllowed(((Boolean)pluginProperties.getDynValue("EmptyEffectiveDateAllowedInCommitPanel")).booleanValue());
        swingManager.setCurrentDateAsEffectiveDateByDefault(((Boolean)pluginProperties.getDynValue("CurrentDateAsEffectiveDateByDefaultInCommitPanel")).booleanValue());
        swingManager.setRepositoryEntityFeatureTypeEditorMode(((Integer)pluginProperties.getDynValue("RepositoryEntityFeatureTypeEditorMode")).intValue());
        PluginsLocator.getPluginsManager().addShutdownTask("VCSGisSave", () -> {
            DynObject pluginProps = this.getPlugin().getPluginProperties();
            pluginProps.setDynValue("workspaces", (Object)manager.getWorkspaces());
            pluginProps.setDynValue("EmptyEffectiveDateAllowedInCommitPanel", (Object)swingManager.isEmptyEffectiveDateAllowed());
            pluginProps.setDynValue("CurrentDateAsEffectiveDateByDefaultInCommitPanel", (Object)swingManager.useCurrentDateAsEffectiveDateByDefault());
            pluginProps.setDynValue("RepositoryEntityFeatureTypeEditorMode", (Object)swingManager.getRepositoryEntityFeatureTypeEditorMode());
        }, false, 100);
        ApplicationLocator.getManager().registerAddTableWizard("VCSGis", "VCSGis", WizardVCSGisTabular.class);
        AddLayer.addWizard(WizardVCSGisVectorial.class);
        application.getProjectManager().addProjectListener(e -> {
            if (e instanceof ProjectManager.ProjectEvent) {
                ProjectManager.ProjectEvent pe = (ProjectManager.ProjectEvent)e;
                switch (pe.getId()) {
                    case 14: {
                        VCSGisSwingServicesImpl services = (VCSGisSwingServicesImpl)VCSGisSwingLocator.getVCSGisSwingManager().getDefaultServices();
                        services.projectLoaded(pe.getProject());
                        break;
                    }
                }
            }
        });
        EditingNotificationManager editingNotificationManager = DALSwingLocator.getEditingNotificationManager();
        editingNotificationManager.addObserver((Observer)new EditingNotificationObserver());
    }

    public void execute(String actionCommand) {
        this.execute(actionCommand, null);
    }

    public void execute(String actionCommand, Object[] args) {
        Arguments arguments = Arguments.create((Object[])args);
        switch (actionCommand) {
            case "tools-vcsgis-showchanges": {
                this.showChangesDialog((VCSGisWorkspace)arguments.get("workspace", VCSGisWorkspace.class, null), arguments.getListOf("tablenames", String.class), (Timestamp)arguments.get("efectivedate", Timestamp.class, null), (String)arguments.get("comment", String.class, null));
                break;
            }
            case "tools-vcsgis-init-server": {
                this.showInitializaRepositoryDialog();
                break;
            }
            case "tools-vcsgis-init-workspace": {
                this.showInitWorkspaceDialog();
                break;
            }
            case "tools-vcsgis-add-to-workspace": {
                this.showAddToWorkspaceDialog();
                break;
            }
            case "tools-vcsgis-checkout": {
                this.showCheckoutDialog((VCSGisWorkspace)arguments.get("workspace", VCSGisWorkspace.class, null), arguments.getListOf("tablenames", String.class), (Boolean)arguments.get("overwrite", Boolean.class, null));
                break;
            }
            case "tools-vcsgis-export": {
                this.showExportDialog();
                break;
            }
            case "tools-vcsgis-register-workspace": {
                this.showRegistrationWorkspaceDialog();
                break;
            }
            case "tools-vcsgis-show_server-entities": {
                this.showServerEntitiesDialog();
                break;
            }
            case "tools-vcsgis-show_server-hooks": {
                this.showServerHooksDialog();
                break;
            }
            case "tools-vcsgis-show-revisions": {
                this.showHistory();
                break;
            }
            case "tools-vcsgis-import-history": {
                this.showImportHistoryDialog();
                break;
            }
            case "tools-vcsgis-create-resource-table": {
                this.showCreateResourceTableDialog();
                break;
            }
            case "tools-vcsgis-logout": {
                this.showLogoutDialog();
                break;
            }
            case "tools-vcsgis-checkout-datamodel": {
                this.showCheckoutDataModelDialog((VCSGisWorkspace)arguments.get("workspace", VCSGisWorkspace.class, null), (String)arguments.get("model", String.class, null));
                break;
            }
            case "tools-vcsgis-download-workingcopy": {
                this.showDownloadWorkingcopyDialog();
                break;
            }
            case "tools-vcsgis-prepare-workingcopy": {
                this.showPrepareWorkingcopyDialog();
                break;
            }
            case "tools-vcsgis-backup-history": {
                this.showBackupHistoryDialog();
                break;
            }
            case "tools-vcsgis-restore-history": {
                this.showRestoreHistoryDialog();
                break;
            }
            case "tools-vcsgis-registrationeditingstores": {
                this.showRegistrationOfEditingStoresDialog();
                break;
            }
            case "tools-vcsgis-repositoryentityfeaturetypeeditor": {
                this.showRepositoryEntityFeatureTypeEditorImplDialog();
                break;
            }
            case "tools-vcsgis-setworkingcopyoffline": {
                this.showSetWorkingCopyOfflineDialog();
            }
        }
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }

    private void showAddToWorkspaceDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("AddToWorkingCopy", (VCSGisPanel)swingManager.createAddToWorkspacePanel(), "_VCS_Add_to_workingcopy", "_VCS_Add_to_workingcopy", "_VCS_Add_to_workingcopy", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJAddToWorkspace addToWorkspacePanel = (VCSGisJAddToWorkspace)this.dialogsHelper.getDialog("AddToWorkingCopy").getPanel();
            int r = addToWorkspacePanel.add();
            if (r != 0) {
                dialogsManager.messageDialog(addToWorkspacePanel.getLastErrorMessage(), i18n.getTranslation("_VCS_Add_to_workingcopy"), 2);
            }
        });
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        Dimension panelsize = dialog.getPanel().asJComponent().getPreferredSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)dialog.getPanel().asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showImportHistoryDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("ImportHistory", (VCSGisPanel)swingManager.createImportHistoryPanel(), "_VCS_Import_history", "_VCS_Import_history", "_VCS_Import_history", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJImportHistory importHistoryPanel = (VCSGisJImportHistory)this.dialogsHelper.getDialog("ImportHistory").getPanel();
            int r = importHistoryPanel.importHistory();
            if (r != 0) {
                VCSGisWorkspace workspace = importHistoryPanel.getWorkspace();
                String errmsg = workspace.getErrorMessage(r);
                if (errmsg == null) {
                    errmsg = "";
                }
                dialogsManager.messageDialog(i18n.getTranslation("_Cant_import_history") + "\n" + errmsg + "\n" + i18n.getTranslation("_see_error_log_for_more_information") + "\n" + "(" + Objects.toString(importHistoryPanel.getLastLogFile()) + ")", i18n.getTranslation("_VCS_Import_history"), 2);
            }
        });
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showInitWorkspaceDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("InitializeWorkingCopy", (VCSGisPanel)swingManager.createInitWorkspacePanel(), "_VCS_Initialize_workingcopy", "_VCS_Initialize_workingcopy", "_VCS_Initialize_workingcopy", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJInitWorkspace panelInitWorkspace = (VCSGisJInitWorkspace)this.dialogsHelper.getDialog("InitializeWorkingCopy").getPanel();
            int r = panelInitWorkspace.initializeWorkspace();
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Cant_initialize_workingcopy_{0}", new String[]{panelInitWorkspace.getWorkspaceName()}), i18n.getTranslation("_VCS_Initialize_workingcopy"), 2);
            }
        });
        dialog.setAutoclose(true);
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showInitializaRepositoryDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("InitializeRepository", (VCSGisPanel)swingManager.createInitRepositoryPanel(), "_VCS_Initialize_repository", "_VCS_Initialize_repository", "_VCS_Initialize_repository", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJInitServer panel = (VCSGisJInitServer)this.dialogsHelper.getDialog("InitializeRepository").getPanel();
            int r = panel.initialize();
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Cant_initialize_server_{0}", new String[]{panel.getConnectionLabel()}), i18n.getTranslation("_VCS_Initialize_repository"), 2);
            }
        });
        dialog.setAutoclose(true);
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showCheckoutDialog(VCSGisWorkspace workspace, List<String> tableNames, Boolean overwrite) {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Checkout", (VCSGisPanel)swingManager.createCheckoutPanel(workspace, tableNames, overwrite), "_VCS_Checkout", "_VCS_Checkout", "_VCS_Checkout", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJCheckout checkoutPanel = (VCSGisJCheckout)this.dialogsHelper.getDialog("Checkout").getPanel();
            int r = checkoutPanel.checkout();
            if (r != 0) {
                VCSGisEntity entity = checkoutPanel.getTable();
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_checkout_of_{0}", new String[]{entity.toString()}), i18n.getTranslation("_VCS_Checkout"), 2);
            }
        });
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        Dimension panelsize = dialog.getPanel().asJComponent().getPreferredSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)dialog.getPanel().asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showExportDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Export", (VCSGisPanel)swingManager.createExportPanel(), "_VCS_Export", "_Export_to_a_local_table_a_table_of_the_repository", "_VCS_Export", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJExport exportPanel = (VCSGisJExport)this.dialogsHelper.getDialog("Export").getPanel();
            int r = exportPanel.export();
            if (r != 0) {
                VCSGisEntity entity = exportPanel.getTable();
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_export_of_{0}", new String[]{entity.toString()}), i18n.getTranslation("_VCSGis_Export"), 2);
            }
        });
        dialog.show();
    }

    private void showChangesDialog(VCSGisWorkspace workspace, List<String> tableNames, Timestamp efectivedate, String comment) {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Changes", (VCSGisPanel)swingManager.createChangesPanel(workspace, tableNames, efectivedate, comment), "_VCS_Changes");
        Dimension screensize = ApplicationLocator.getApplicationManager().getUIManager().getInternalSize();
        Dimension panelsize = dialog.getPanel().asJComponent().getPreferredSize();
        ToolsSwingUtils.ensureHeightWitdh((JComponent)dialog.getPanel().asJComponent(), (int)Math.max(3 * (screensize.height / 4), panelsize.height), (int)Math.max(2 * (screensize.width / 4), panelsize.width), (int)(7 * (screensize.height / 8)), (int)(3 * (screensize.width / 4)));
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showHistory() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Revisions", (VCSGisPanel)swingManager.createRevisionsPanel(), "_VCS_Revisions");
        dialog.show();
    }

    private void showRegistrationWorkspaceDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("RegisterWorkingCopies", (VCSGisPanel)swingManager.createRegisterWorkspacePanel(), "_VCS_Registration_workingcopies");
        dialog.show();
    }

    private void showRegistrationOfEditingStoresDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("RegistrationOfEditingStores", swingManager.createRegistrationOfEditingStoresPanel(), "_VCS_Registration_of_editing_stores");
        dialog.show();
    }

    private void showServerEntitiesDialog() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisJShowServerTableForm panel = swingManager.createShowTableServerFormPanel("VCSGIS_ENTITIES");
        winManager.showWindow(panel.asJComponent(), i18nManager.getTranslation("_VCS_Server_entities"), WindowManager.MODE.WINDOW);
    }

    private void showServerHooksDialog() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisJShowServerTableForm panel = swingManager.createShowTableServerFormPanel("VCSGIS_HOOKS");
        winManager.showWindow(panel.asJComponent(), i18nManager.getTranslation("_VCS_Server_hooks"), WindowManager.MODE.WINDOW);
    }

    private void showCreateResourceTableDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("CreateResourceTable", (VCSGisPanel)swingManager.createResourceTablePanel(), "_VCS_Create_resource_table", "_Create_resource_table_parameters", "_VCS_Create_resource_table", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            VCSGisJCreateResourceTable panel = (VCSGisJCreateResourceTable)this.dialogsHelper.getDialog("CreateResourceTable").getPanel();
            panel.createResourceTable();
        });
        dialog.setAutoclose(true);
        dialog.show();
    }

    private void showLogoutDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("Logout", (VCSGisPanel)swingManager.createLogoutPanel(), "_VCS_Logout", "_Logout_the_current_user_from_a_VCSGis_working_copy", "_VCS_Logout", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            VCSGisJLogout panel = (VCSGisJLogout)this.dialogsHelper.getDialog("Logout").getPanel();
            panel.logout();
        });
        dialog.setAutoclose(true);
        dialog.show();
    }

    private void showCheckoutDataModelDialog(VCSGisWorkspace workspace, String model) {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("ConnectDataModel", (VCSGisPanel)swingManager.createCheckoutDataModelPanel(workspace, model), "_VCS_Connect_to_datamodel", "_VCS_Connect_to_datamodel", "_VCS_Connect_to_datamodel", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJCheckoutDataModel checkoutDataModelPanel = (VCSGisJCheckoutDataModel)this.dialogsHelper.getDialog("ConnectDataModel").getPanel();
            int r = checkoutDataModelPanel.connectToModel();
            if (r != 0 && r != 10000) {
                String dataModel = checkoutDataModelPanel.getDataModel();
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_connect_to_{0}", new String[]{dataModel}), i18n.getTranslation("_VCS_Connect_to_datamodel"), 2);
            }
        });
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showDownloadWorkingcopyDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("DownloadWorkingcopy", (VCSGisPanel)swingManager.createDownloadWorkingcopyPanel(), "_VCS_Download_workingcopy", "_VCS_Download_workingcopy", "_VCS_Download_workingcopy", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJDownloadWorkingcopy downloadWorkingcopyPanel = (VCSGisJDownloadWorkingcopy)this.dialogsHelper.getDialog("DownloadWorkingcopy").getPanel();
            int r = downloadWorkingcopyPanel.download(false);
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_dowloading_working_copy"), i18n.getTranslation("_VCS_Download_working_copy"), 2);
            }
        });
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showPrepareWorkingcopyDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("PrepareWorkingcopy", (VCSGisPanel)swingManager.createPrepareWorkingcopyPanel(), "_VCS_Prepare_workingcopy", "_VCS_Prepare_workingcopy", "_VCS_Prepare_workingcopy", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJPrepareWorkingcopy prepareWorkingcopyPanel = (VCSGisJPrepareWorkingcopy)this.dialogsHelper.getDialog("PrepareWorkingcopy").getPanel();
            int r = prepareWorkingcopyPanel.prepare();
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_prepare_working_copy"), i18n.getTranslation("_VCS_Prepare_working_copy"), 2);
            }
        });
        dialog.setAutoclose(true);
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showBackupHistoryDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("BackupHistory", (VCSGisPanel)swingManager.createBackupHistoryPanel(), "_VCS_Backup_history", "_VCS_Backup_history", "_VCS_Backup_history", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJBackupHistory backupHistoryPanel = (VCSGisJBackupHistory)this.dialogsHelper.getDialog("BackupHistory").getPanel();
            int r = backupHistoryPanel.backupHistory();
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_doing_backup_history"), i18n.getTranslation("_VCS_Backup_history"), 2);
            }
        });
        dialog.show();
    }

    private void showRestoreHistoryDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("RestoreHistory", (VCSGisPanel)swingManager.createRestoreHistoryPanel(), "_VCS_Restore_history", "_VCS_Restore_history", "_VCS_Restore_history", () -> {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ThreadSafeDialogsManager dialogsManager = ToolsSwingLocator.getThreadSafeDialogsManager();
            VCSGisJRestoreHistory restoreHistoryPanel = (VCSGisJRestoreHistory)this.dialogsHelper.getDialog("RestoreHistory").getPanel();
            int r = restoreHistoryPanel.restoreHistory();
            if (r != 0) {
                dialogsManager.messageDialog(i18n.getTranslation("_Failed_restoring_history"), i18n.getTranslation("_VCS_Restore_history"), 2);
            }
        });
        dialog.show(Collections.singletonMap("align", 10));
    }

    private void showRepositoryEntityFeatureTypeEditorImplDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("RepositoryEntityFeatureTypeEditor", swingManager.createRepositoryEntityFeatureTypeEditor(), "_VCS_Repository_entity_feature_type_editor");
        dialog.show();
    }

    private void showSetWorkingCopyOfflineDialog() {
        VCSGisSwingManager swingManager = VCSGisSwingLocator.getVCSGisSwingManager();
        VCSGisDialogsHelper.VCSGisDialogInfo dialog = this.dialogsHelper.getOrCreateDialog("SetWorkingCopyOffline", (VCSGisPanel)swingManager.createSetWorkingCopyOfflinePanel(), "_VCS_Set_Working_copy_offline", "_VCS_Set_Working_copy_offline", "_VCS_Set_Working_copy_offline", () -> {
            VCSGisJSetWorkingCopyOffline setWorkingCopyOffline = (VCSGisJSetWorkingCopyOffline)this.dialogsHelper.getDialog("SetWorkingCopyOffline").getPanel();
            setWorkingCopyOffline.setOffline();
        });
        dialog.show(Collections.singletonMap("align", 10));
    }

    public IPreference[] getPreferencesPages() {
        ArrayList<VCSGisPage> prefs = new ArrayList<VCSGisPage>();
        prefs.add(new VCSGisPage());
        return prefs.toArray(new IPreference[prefs.size()]);
    }
}

