/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.panel.animation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.animation.TimeAnimation;
import org.gvsig.timesupport.swing.api.panel.AnimationBarPanel;
import org.gvsig.timesupport.swing.impl.panel.animation.AnimationBarPanelImplLayout;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;

public class AnimationBarPanelImpl
extends AnimationBarPanelImplLayout
implements AnimationBarPanel,
Observer {
    private static final long serialVersionUID = 1L;
    private final String pattern = "dd/MM/yyyy HH:mm:ss:SSS";
    private final TimeAnimation animation;

    public AnimationBarPanelImpl(TimeAnimation animation) {
        this.animation = animation;
        this.initComponents();
        this.updateComponents(animation);
        animation.addObserver((Observer)this);
    }

    private void initComponents() {
        this.sliderSpeed.setMinimum(0);
        this.sliderSpeed.setMaximum(100);
        this.sliderSpeed.setValue(0);
        this.sliderSpeed.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AnimationBarPanelImpl.this.doSliderChanged();
            }
        });
        URL playUrl = this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/play.png");
        if (playUrl != null) {
            ImageIcon playIcon = new ImageIcon(playUrl);
            this.buttonPlay.setIcon(playIcon);
        }
        this.buttonPlay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationBarPanelImpl.this.animation.play();
            }
        });
        this.buttonPlay.setEnabled(true);
        URL stopUrl = this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/stop.png");
        if (stopUrl != null) {
            ImageIcon stopIcon = new ImageIcon(stopUrl);
            this.buttonStop.setIcon(stopIcon);
        }
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationBarPanelImpl.this.animation.stop();
            }
        });
        this.buttonStop.setEnabled(false);
        URL pauseUrl = this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/pause.png");
        if (pauseUrl != null) {
            ImageIcon pauseIcon = new ImageIcon(pauseUrl);
            this.buttonPause.setIcon(pauseIcon);
        }
        this.buttonPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationBarPanelImpl.this.animation.pause();
            }
        });
        this.buttonPause.setEnabled(false);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.timeStep.setText(i18nManager.getTranslation("timestep"));
        this.speedOfProgress.setText(i18nManager.getTranslation("speedofprogress"));
    }

    private void updateComponents(TimeAnimation animation) {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.sliderSpeed.setMinimum(0);
        this.sliderSpeed.setMaximum(animation.getStepCount());
        RelativeInterval window = animation.getCurrentTime();
        this.textWindowTime.setText(window.getStart().toString("dd/MM/yyyy HH:mm:ss:SSS") + " to " + window.getEnd().toString("dd/MM/yyyy HH:mm:ss:SSS"));
        RelativeInterval interval = animation.getInterval();
        this.labelMinInterval.setText(interval.getStart().toString("dd/MM/yyyy HH:mm:ss:SSS"));
        this.labelMaxInterval.setText(interval.getEnd().toString("dd/MM/yyyy HH:mm:ss:SSS"));
        this.textTimeStep.setText(animation.getStep(animation.getStepScale()) + " " + i18n.getTranslation(this.animation.getScaleLabel(animation.getStepScale())));
        this.textTimeSpeed.setText(String.format("%.3f fps", animation.getFramesPerSecond()));
        switch (animation.getStatus()) {
            case 0: {
                this.buttonPlay.setEnabled(true);
                this.buttonStop.setEnabled(false);
                this.buttonPause.setEnabled(false);
                break;
            }
            case 1: {
                this.buttonPlay.setEnabled(false);
                this.buttonStop.setEnabled(true);
                this.buttonPause.setEnabled(true);
                break;
            }
            case 2: {
                this.buttonPlay.setEnabled(true);
                this.buttonStop.setEnabled(true);
                this.buttonPause.setEnabled(false);
            }
        }
        this.sliderSpeed.setValue(animation.getCurrentPosition());
    }

    private void doSliderChanged() {
        this.animation.setCurrentPosition(this.sliderSpeed.getValue());
    }

    public void update(Observable o, Object animation) {
        if (o instanceof TimeAnimation) {
            this.updateComponents((TimeAnimation)o);
        }
    }

    public JComponent asJComponent() {
        return this;
    }

    public TimeAnimation getAnimation() {
        return this.animation;
    }
}

