/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.panel.animation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInterval;
import org.gvsig.timesupport.animation.TimeAnimation;
import org.gvsig.timesupport.swing.api.panel.AnimationPreferencesPanel;
import org.gvsig.timesupport.swing.impl.panel.TimePanel;
import org.gvsig.timesupport.swing.impl.panel.animation.AnimationPreferencesPanelImplLayout;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ListElement;

public class AnimationPreferencesPanelImpl
extends AnimationPreferencesPanelImplLayout
implements AnimationPreferencesPanel {
    private static final long serialVersionUID = -2490295024250846833L;
    private final TimeAnimation animation;
    private TimePanel timePanel;
    private final int[] scales = new int[]{7, 6, 5, 4, 3, 2, 1, 0};

    public AnimationPreferencesPanelImpl(TimeAnimation animation) {
        this.animation = animation;
        this.initComponents();
        this.updateComponents(animation);
    }

    private void initComponents() {
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.timePanel = new TimePanel();
        this.pnlTimeSelector.setLayout(new BorderLayout());
        this.pnlTimeSelector.add((Component)this.timePanel, "Center");
        SpinnerNumberModel fpsModel = new SpinnerNumberModel(Float.valueOf(0.3f), null, null, Float.valueOf(1.0f));
        this.spnFps.setModel(fpsModel);
        this.cboStepScale.removeAllItems();
        for (int scale : this.scales) {
            this.cboStepScale.addItem(new ListElement(this.animation.getScaleLabel(scale), (Object)scale));
        }
        this.cboRepeatMode.removeAllItems();
        this.cboRepeatMode.addItem(i18n.getTranslation("_Without_repetition"));
        this.cboRepeatMode.addItem(i18n.getTranslation("_Infinite"));
        this.cboRepeatMode.addItem(i18n.getTranslation("_repeat_N_times"));
        this.cboRepeatMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnimationPreferencesPanelImpl.this.doRepeatModeChanged();
            }
        });
        this.setPreferredSize(new Dimension(430, 170));
    }

    private void updateComponents(TimeAnimation animation) {
        this.timePanel.initialize((Instant)this.animation.getInterval().getStart(), (Instant)this.animation.getInterval().getEnd());
        this.txtStep.setText(String.valueOf(this.animation.getStep(animation.getStepScale())));
        for (int i = 0; i < this.scales.length; ++i) {
            ListElement element = (ListElement)this.cboStepScale.getItemAt(i);
            if (element == null || ((Integer)element.getValue()).intValue() != animation.getStepScale()) continue;
            this.cboStepScale.setSelectedIndex(i);
            break;
        }
        this.spnFps.setValue(animation.getFramesPerSecond());
        switch (animation.getIterations()) {
            case 1: {
                this.cboRepeatMode.setSelectedIndex(0);
                this.txtIterations.setText("1");
                break;
            }
            case 0x7FFFFFFF: {
                this.cboRepeatMode.setSelectedIndex(1);
                this.txtIterations.setText(String.valueOf(Integer.MAX_VALUE));
                break;
            }
            default: {
                this.cboRepeatMode.setSelectedIndex(2);
                this.txtIterations.setText(String.valueOf(animation.getIterations()));
            }
        }
    }

    private void updateAnimation(TimeAnimation animation) {
        animation.setInterval((RelativeInterval)this.timePanel.getInterval());
        animation.setStep(NumberUtils.toLong((String)this.txtStep.getText(), (long)animation.getStep()), ((Integer)((ListElement)this.cboStepScale.getSelectedItem()).getValue()).intValue());
        animation.setFramesPerSecond(((Number)this.spnFps.getValue()).doubleValue());
        switch (this.cboRepeatMode.getSelectedIndex()) {
            case 0: {
                animation.setIterations(1);
                break;
            }
            case 1: {
                animation.setIterations(Integer.MAX_VALUE);
                break;
            }
            case 2: {
                animation.setIterations(NumberUtils.toInt((String)this.txtIterations.getText(), (int)1));
            }
        }
    }

    public TimeAnimation getAnimation() {
        this.updateAnimation(this.animation);
        return this.animation;
    }

    public JComponent asJComponent() {
        return this;
    }

    private void doRepeatModeChanged() {
        switch (this.cboRepeatMode.getSelectedIndex()) {
            case -1: {
                return;
            }
            case 0: 
            case 1: {
                this.txtIterations.setEnabled(false);
            }
            case 2: {
                this.txtIterations.setEnabled(true);
            }
        }
    }
}

