/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.timesupport.swing.impl.rdv;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.gvsig.timesupport.AbsoluteInstant;
import org.gvsig.timesupport.AbsoluteInstantTypeNotRegisteredException;
import org.gvsig.timesupport.Instant;
import org.gvsig.timesupport.RelativeInstant;
import org.gvsig.timesupport.TimeSupportLocator;
import org.gvsig.timesupport.TimeSupportManager;
import org.gvsig.timesupport.swing.impl.rdv.TimeAdjustmentListener;
import org.gvsig.timesupport.swing.impl.rdv.TimeEvent;
import org.gvsig.timesupport.swing.impl.rdv.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeSlider
extends JComponent
implements MouseListener,
MouseMotionListener {
    public static final long MILLIS_BY_SECOND = 1000L;
    public static final long MILLIS_BY_MINUTE = 60000L;
    public static final long MILLIS_BY_HOUR = 3600000L;
    public static final long MILLIS_BY_DAY = 86400000L;
    public static final long MILLIS_BY_WEEK = 604800000L;
    public static final long MILLIS_BY_MONTH = 2592000000L;
    public static final long MILLIS_BY_YEAR = 31536000000L;
    private static final Logger LOG = LoggerFactory.getLogger(TimeSlider.class);
    private static TimeSupportManager timeSupportManager = TimeSupportLocator.getManager();
    boolean isAbsolute = false;
    private static final long serialVersionUID = 2429052022677466231L;
    protected double minimum;
    protected double start;
    protected double value;
    protected double end;
    protected double maximum;
    private boolean valueChangeable;
    private boolean rangeChangeable;
    private boolean isAdjusting;
    private int clickStart;
    protected final List<TimeRange> timeRanges;
    protected final List<TimeRange> actualTimeRanges;
    private final List<TimeAdjustmentListener> adjustmentListeners;
    protected final JButton startButton;
    protected final JButton valueButton;
    protected final JButton endButton;
    protected boolean right;
    protected boolean left;

    public TimeSlider(boolean isAbsolute) {
        BufferedImage bufferedImage;
        this.isAbsolute = isAbsolute;
        this.minimum = 0.0;
        this.start = 0.0;
        this.value = 0.0;
        this.end = Double.MAX_VALUE;
        this.maximum = Double.MAX_VALUE;
        this.right = true;
        this.left = true;
        this.rangeChangeable = true;
        this.isAdjusting = false;
        this.timeRanges = new ArrayList<TimeRange>();
        this.actualTimeRanges = new ArrayList<TimeRange>();
        this.calculateActualTimeRanges();
        this.adjustmentListeners = new ArrayList<TimeAdjustmentListener>();
        this.setBorder(null);
        this.setLayout(null);
        this.setToolTipText("");
        this.addMouseListener(this);
        this.valueButton = new JButton(){
            private static final long serialVersionUID = 8729851598067678522L;

            @Override
            public JToolTip createToolTip() {
                return TimeSlider.this.createToolTip();
            }

            @Override
            public String getToolTipText(MouseEvent me) {
                return TimeSlider.this.getToolTipText(me);
            }
        };
        this.valueButton.setToolTipText("");
        this.valueButton.setCursor(Cursor.getPredefinedCursor(12));
        this.valueButton.setBorder(null);
        this.valueButton.addMouseMotionListener(this);
        this.valueButton.addMouseListener(this);
        try {
            bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/time.png"));
            this.valueButton.setIcon(new ImageIcon(this.getScaledImage(bufferedImage, 7, 7)));
        }
        catch (IOException e) {
            this.valueButton.setBackground(Color.BLACK);
        }
        this.add(this.valueButton);
        this.startButton = new JButton();
        this.startButton.setBorder(null);
        this.startButton.addMouseListener(this);
        this.startButton.addMouseMotionListener(this);
        try {
            bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/left_bound.png"));
            this.startButton.setIcon(new ImageIcon(this.getScaledImage(bufferedImage, 6, 11)));
        }
        catch (IOException e) {
            this.startButton.setBackground(Color.BLACK);
        }
        this.add(this.startButton);
        this.endButton = new JButton();
        this.endButton.setBorder(null);
        this.endButton.addMouseListener(this);
        this.endButton.addMouseMotionListener(this);
        try {
            bufferedImage = ImageIO.read(this.getClass().getClassLoader().getResource("org/gvsig/timesupport/swing/impl/images/right_bound.png"));
            this.endButton.setIcon(new ImageIcon(this.getScaledImage(bufferedImage, 6, 11)));
        }
        catch (IOException e) {
            this.endButton.setBackground(Color.BLACK);
        }
        this.add(this.endButton);
        this.setValueChangeable(true);
    }

    private Image getScaledImage(BufferedImage image, int w, int h) {
        double scaleW = w / image.getWidth();
        double scaleH = h / image.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 2);
        Graphics2D g2 = bi.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        AffineTransform at = AffineTransform.getScaleInstance(scaleW, scaleH);
        g2.drawRenderedImage(image, at);
        g2.dispose();
        return bi;
    }

    public void setValueChangeable(boolean changeable) {
        if (this.valueChangeable == changeable) {
            return;
        }
        this.valueChangeable = changeable;
        this.valueButton.setEnabled(this.valueChangeable);
        if (this.valueChangeable) {
            this.addMouseListener(this);
            this.valueButton.addMouseListener(this);
            this.valueButton.addMouseMotionListener(this);
            this.valueButton.setVisible(true);
            this.startButton.setCursor(null);
            this.endButton.setCursor(null);
        } else {
            this.removeMouseListener(this);
            this.valueButton.removeMouseListener(this);
            this.valueButton.removeMouseMotionListener(this);
            this.valueButton.setVisible(false);
            this.startButton.setCursor(Cursor.getPredefinedCursor(12));
            this.endButton.setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public boolean getValueChangeable() {
        return this.valueChangeable;
    }

    public void setValueVisible(boolean visible) {
        if (this.valueButton.isVisible() == visible) {
            return;
        }
        this.valueButton.setVisible(visible);
    }

    public void setRangeChangeable(boolean changeable) {
        if (this.rangeChangeable == changeable) {
            return;
        }
        this.rangeChangeable = changeable;
        this.startButton.setEnabled(this.rangeChangeable);
        this.endButton.setEnabled(this.rangeChangeable);
        if (this.rangeChangeable) {
            this.startButton.addMouseMotionListener(this);
            this.endButton.addMouseMotionListener(this);
        } else {
            this.startButton.removeMouseMotionListener(this);
            this.endButton.removeMouseMotionListener(this);
        }
    }

    private double getValue() {
        return this.value;
    }

    private void setValue(double value) {
        if (this.value != value) {
            this.value = value;
            this.doLayout();
            this.fireValueChanged();
        }
    }

    public void moveRight(boolean right) {
        this.right = right;
    }

    public void moveLeft(boolean left) {
        this.left = left;
    }

    public void setCurrentInstant(Instant currentInstant) {
        long millis = this.toMillis(currentInstant);
        if ((double)millis >= this.minimum && (double)millis <= this.maximum) {
            this.setValue(millis);
        } else if ((double)millis < this.minimum) {
            this.setValue(this.minimum);
        } else {
            this.setValue(this.maximum);
        }
    }

    public void setStartInstant(Instant startInstant) {
        double millis = this.toMillis(startInstant);
        if (millis > this.minimum && millis <= this.end) {
            this.setStart(millis);
        } else if (millis > this.end) {
            this.setStart(this.end);
        } else {
            this.setStart(this.minimum);
        }
    }

    public void setEndInstant(Instant endInstant) {
        double millis = this.toMillis(endInstant);
        if (millis < this.maximum && millis >= this.start) {
            this.setEnd(millis);
        } else if (millis < this.start) {
            this.setEnd(this.start);
        } else {
            this.setEnd(this.maximum);
        }
    }

    public void setValues(Instant minimunInstant, Instant maximumInstant) {
        this.setValues(this.toMillis(minimunInstant), this.toMillis(maximumInstant));
    }

    private void setValues(long minimum, long maximum) {
        this.setMinimum(minimum);
        this.setMaximum(maximum);
        this.setValue(this.minimum);
    }

    private double getStart() {
        return this.start;
    }

    private void setStart(double start) {
        if (this.start != start) {
            this.start = start;
            this.doLayout();
            this.fireRangeChanged();
        }
    }

    private double getEnd() {
        return this.end;
    }

    private void setEnd(double end) {
        if (this.end != end) {
            this.end = end;
            this.doLayout();
            this.fireRangeChanged();
        }
    }

    public double getMinimum() {
        return this.minimum;
    }

    private void setMinimum(double minimum) {
        if (this.minimum != minimum) {
            this.minimum = minimum;
            this.calculateActualTimeRanges();
            if (this.rangeChangeable) {
                if (minimum > this.start) {
                    this.setStart(minimum);
                    this.fireRangeChanged();
                }
                if (minimum > this.end) {
                    this.setEnd(minimum);
                    this.fireRangeChanged();
                }
            } else {
                this.setStart(minimum);
            }
            this.fireBoundsChanged();
            this.doLayout();
        }
    }

    public double getMaximum() {
        return this.maximum;
    }

    private void setMaximum(double maximum) {
        if (this.maximum != maximum) {
            this.maximum = maximum;
            this.calculateActualTimeRanges();
            if (this.rangeChangeable) {
                if (maximum < this.end) {
                    this.setEnd(maximum);
                    this.fireRangeChanged();
                }
                if (maximum < this.start) {
                    this.setStart(maximum);
                    this.fireRangeChanged();
                }
            } else {
                this.setEnd(maximum);
            }
            this.fireBoundsChanged();
            this.doLayout();
        }
    }

    public void resetMinimumBound() {
        this.setStart(this.minimum);
    }

    public void resetMaximumBound() {
        this.setEnd(this.maximum);
    }

    public void resetValue() {
        this.setValue(this.minimum);
    }

    public void resetAllDates() {
        this.resetMinimumBound();
        this.resetMaximumBound();
        this.resetValue();
    }

    public void setTimeRanges(List<TimeRange> newTimeRanges) {
        this.timeRanges.clear();
        this.timeRanges.addAll(newTimeRanges);
        this.calculateActualTimeRanges();
        double newValue = this.getClosestValidTime(this.value);
        if (this.value != newValue) {
            this.value = newValue;
            this.fireValueChanged();
        }
        double newStart = this.getClosestValidTime(this.start);
        double newEnd = this.getClosestValidTime(this.end);
        if (this.start != newStart || this.end != newEnd) {
            this.setStart(newStart);
            this.setEnd(newEnd);
            this.fireRangeChanged();
        }
        this.doLayout();
    }

    public boolean isTimeValid(double time) {
        for (TimeRange timeRange : this.actualTimeRanges) {
            if (!timeRange.contains(time)) continue;
            return true;
        }
        return false;
    }

    public double getNextValidTime(double time) {
        for (TimeRange tr : this.actualTimeRanges) {
            if (tr.contains(time)) {
                return time;
            }
            if (!(tr.start > time)) continue;
            return tr.start;
        }
        return -1.0;
    }

    private double getClosestValidTime(double time) {
        double possibleTime = 0.0;
        for (int i = 0; i < this.actualTimeRanges.size(); ++i) {
            TimeRange tr = this.actualTimeRanges.get(i);
            if (i == 0 && time < tr.start) {
                return tr.start;
            }
            if (i == this.actualTimeRanges.size() - 1 && time > tr.end) {
                return tr.end;
            }
            if (tr.contains(time)) {
                return time;
            }
            if (!(time > tr.end)) {
                if (time - possibleTime < tr.start - time) {
                    return possibleTime;
                }
                return tr.start;
            }
            possibleTime = tr.end;
        }
        return time;
    }

    public void clearTimeRanges() {
        this.timeRanges.clear();
        this.calculateActualTimeRanges();
        this.doLayout();
    }

    public boolean isValueAdjusting() {
        return this.isAdjusting;
    }

    private void calculateActualTimeRanges() {
        this.actualTimeRanges.clear();
        if (this.timeRanges.size() == 0) {
            this.actualTimeRanges.add(new TimeRange(this.minimum, this.maximum));
        } else {
            for (TimeRange t : this.timeRanges) {
                if (t.start > this.maximum) break;
                if (t.end < this.minimum) continue;
                double rangeStart = t.start >= this.minimum ? t.start : this.minimum;
                double rangeEnd = t.end <= this.maximum ? t.end : this.maximum;
                this.actualTimeRanges.add(new TimeRange(rangeStart, rangeEnd));
            }
        }
    }

    public double getActualMinimum() {
        if (this.actualTimeRanges.size() == 0) {
            return this.minimum;
        }
        return this.actualTimeRanges.get((int)0).start;
    }

    public double getActualMaximum() {
        if (this.actualTimeRanges.size() == 0) {
            return this.maximum;
        }
        return this.actualTimeRanges.get((int)(this.actualTimeRanges.size() - 1)).end;
    }

    private double getTimeLength() {
        double length = 0.0;
        for (TimeRange t : this.actualTimeRanges) {
            length += t.length();
        }
        return length;
    }

    private int getTimeWidth() {
        Insets insets = this.getInsets();
        return this.getWidth() - 13 - insets.left - insets.right;
    }

    private double getTimeFromX(int x) {
        x = x - 6 - this.getInsets().left;
        int width = this.getTimeWidth();
        if (x < 0) {
            return this.getActualMinimum();
        }
        if (x > width) {
            return this.getActualMaximum();
        }
        double factor = (double)x / (double)width;
        double length = this.getTimeLength();
        double value = factor * length;
        double position = 0.0;
        for (TimeRange t : this.actualTimeRanges) {
            double startPosition = position;
            if (!(value <= (position += t.length()))) continue;
            double startFactor = startPosition / length;
            double endFactor = position / length;
            factor = (factor - startFactor) / (endFactor - startFactor);
            return t.length() * factor + t.start;
        }
        return 0.0;
    }

    private int getXFromTime(double time) {
        boolean timeVisible = false;
        double position = 0.0;
        for (TimeRange t : this.actualTimeRanges) {
            if (t.contains(time)) {
                timeVisible = true;
                position += time - t.start;
                break;
            }
            position += t.length();
        }
        if (!timeVisible) {
            return -1;
        }
        double factor = position / this.getTimeLength();
        int width = this.getTimeWidth();
        return (int)Math.round(factor * (double)width) + this.getInsets().left + 6;
    }

    private double getPixelTime() {
        return this.getTimeLength() / (double)this.getTimeWidth();
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        if (this.maximum == this.minimum) {
            this.startButton.setVisible(false);
            this.endButton.setVisible(false);
        } else {
            this.startButton.setVisible(true);
            this.endButton.setVisible(true);
        }
        this.startButton.setBounds(this.getXFromTime(this.start) - 6, insets.top, 6, 11);
        this.endButton.setBounds(this.getXFromTime(this.end) + 1, insets.top, 6, 11);
        this.valueButton.setBounds(this.getXFromTime(this.value) - 3, insets.top + 2, 7, 7);
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Insets insets = this.getInsets();
        g.setColor(Color.lightGray);
        g.fillRect(insets.left + 6, insets.top + 4, this.getWidth() - insets.left - 12 - insets.right, 3);
        if (this.isEnabled()) {
            g.setColor(Color.gray);
            int startX = this.getXFromTime(this.start);
            int endX = this.getXFromTime(this.end);
            g.fillRect(startX, insets.top + 4, endX - startX, 3);
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + 6 + 6 + 1 + insets.right, insets.top + 11 + insets.bottom);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public JToolTip createToolTip() {
        JToolTip toolTip = super.createToolTip();
        toolTip.setBackground(Color.decode("#FFFFFC"));
        toolTip.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        return toolTip;
    }

    public Instant getStartInstant() {
        return this.toInstant((long)this.getStart());
    }

    public Instant getEndInstant() {
        return this.toInstant((long)this.getEnd());
    }

    public Instant getCurrentInstant() {
        if (this.valueChangeable) {
            return this.toInstant((long)this.getValue());
        }
        return null;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (!this.isEnabled()) {
            return;
        }
        JButton button = (JButton)me.getSource();
        int x = me.getX();
        if (button == this.startButton) {
            x += this.endButton.getWidth() - this.clickStart;
        } else if (button == this.valueButton) {
            x = (int)((long)x + (Math.round((double)this.valueButton.getWidth() / 2.0) - (long)this.clickStart));
        } else if (button == this.endButton) {
            x -= this.clickStart;
        }
        double time = this.getTimeFromX(button.getX() + x);
        if (button == this.startButton) {
            if (this.left && !this.valueChangeable) {
                if (time < this.minimum) {
                    time = this.minimum;
                } else if (time >= this.end) {
                    time = this.end;
                }
                this.setStart(time);
            }
        } else if (button == this.valueButton) {
            if (this.rangeChangeable) {
                if (time < this.start) {
                    time = this.start;
                } else if (time > this.end) {
                    time = this.end;
                }
            } else if (time < this.minimum) {
                time = this.minimum;
            } else if (time > this.maximum) {
                time = this.maximum;
            }
            this.setValue(time);
        } else if (button == this.endButton && this.right && !this.valueChangeable) {
            if (time < this.start) {
                time = this.start;
            } else if (time > this.maximum) {
                time = this.maximum;
            }
            this.setEnd(time);
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
        this.clickStart = me.getX();
        if (me.getSource() == this.valueButton) {
            this.isAdjusting = true;
        }
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        if (me.getSource() == this.valueButton) {
            this.isAdjusting = false;
            TimeEvent event = new TimeEvent(this);
            for (TimeAdjustmentListener l : this.adjustmentListeners) {
                l.timeChanged(event);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        double time;
        if (me.getSource() == this) {
            time = this.getTimeFromX(me.getX());
        } else if (me.getSource() == this.valueButton) {
            time = this.getTimeFromX(this.valueButton.getX() + me.getX());
        } else {
            return;
        }
        if (me.getButton() == 1) {
            this.setValue(time);
        }
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }

    public void addTimeAdjustmentListener(TimeAdjustmentListener l) {
        this.adjustmentListeners.add(l);
    }

    public void removeTimeAdjustmentListener(TimeAdjustmentListener l) {
        this.adjustmentListeners.remove(l);
    }

    public void fireValueChanged() {
        TimeEvent event = new TimeEvent(this);
        for (TimeAdjustmentListener l : this.adjustmentListeners) {
            l.timeChanged(event);
        }
    }

    public void fireRangeChanged() {
        TimeEvent event = new TimeEvent(this);
        for (TimeAdjustmentListener l : this.adjustmentListeners) {
            l.rangeChanged(event);
        }
    }

    protected void fireBoundsChanged() {
        TimeEvent event = new TimeEvent(this);
        for (TimeAdjustmentListener l : this.adjustmentListeners) {
            l.boundsChanged(event);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.valueButton.setEnabled(enabled && this.valueChangeable);
        this.startButton.setEnabled(enabled && this.rangeChangeable);
        this.endButton.setEnabled(enabled && this.rangeChangeable);
        this.repaint();
    }

    private long toMillis(Instant instant) {
        if (instant.isAbsolute()) {
            AbsoluteInstant absoluteInstant = (AbsoluteInstant)instant;
            long millis = 0L;
            millis += (long)absoluteInstant.getYears() * 31536000000L;
            millis += (long)absoluteInstant.getMonths() * 2592000000L;
            millis += (long)absoluteInstant.getDays() * 31536000000L;
            millis += (long)absoluteInstant.getHours() * 3600000L;
            millis += (long)absoluteInstant.getMinutes() * 60000L;
            millis += (long)absoluteInstant.getSeconds() * 1000L;
            return millis += (long)absoluteInstant.getMillis();
        }
        return ((RelativeInstant)instant).toMillis();
    }

    private Instant toInstant(long millis) {
        if (this.isAbsolute) {
            ArrayList<Integer> types = new ArrayList<Integer>();
            ArrayList<Integer> values = new ArrayList<Integer>();
            long mod = millis % 31536000000L;
            if (millis / 31536000000L > 0L) {
                types.add(5);
                values.add((int)(millis / 31536000000L));
                millis = mod;
            }
            mod = millis % 2592000000L;
            if (millis / 2592000000L > 0L) {
                if ((int)(millis / 2592000000L) > 0) {
                    types.add(7);
                    values.add((int)(millis / 2592000000L));
                }
                millis = mod;
            }
            mod = millis % 604800000L;
            if (millis / 604800000L > 0L) {
                if ((int)(millis / 604800000L) > 0) {
                    types.add(11);
                    values.add((int)(millis / 604800000L));
                }
                millis = mod;
            }
            mod = millis % 86400000L;
            if (millis / 86400000L > 0L) {
                if ((int)(millis / 86400000L) > 0) {
                    types.add(8);
                    values.add((int)(millis / 86400000L));
                }
                millis = mod;
            }
            mod = millis % 3600000L;
            if (millis / 3600000L > 0L) {
                types.add(17);
                values.add((int)(millis / 3600000L));
                millis = mod;
            }
            mod = millis % 60000L;
            if (millis / 60000L > 0L) {
                types.add(19);
                values.add((int)(millis / 60000L));
                millis = mod;
            }
            mod = millis % 1000L;
            if (millis / 1000L > 0L) {
                types.add(21);
                values.add((int)(millis / 1000L));
                millis = mod;
            }
            if ((mod = (long)((int)millis)) > 0L) {
                types.add(23);
                values.add((int)millis);
                millis = mod;
            }
            try {
                int[] intTypes = new int[types.size()];
                int[] intValues = new int[types.size()];
                for (int i = 0; i < types.size(); ++i) {
                    intTypes[i] = (Integer)types.get(i);
                    intValues[i] = (Integer)values.get(i);
                }
                return timeSupportManager.createAbsoluteInstant(intTypes, intValues);
            }
            catch (AbsoluteInstantTypeNotRegisteredException e) {
                LOG.error("Error creating an absolute instants");
                return null;
            }
        }
        return timeSupportManager.createRelativeInstant(millis);
    }
}

