/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.basicformats.CPGFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.gvsig.basicformats.impl.DefaultPRJFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCPGFile
extends AbstractFormatFile
implements CPGFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPRJFile.class);
    private File source = null;
    private String charsetName = null;
    private static final short[] codePages = new short[]{1, 2, 3, 4, 8, 9, 10, 11, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 31, 34, 35, 36, 37, 38, 55, 64, 77, 78, 79, 80, 87, 88, 89, 100, 101, 102, 103, 104, 105, 106, 107, 108, 120, 121, 122, 123, 124, 125, 125, 134, 135, 136, 200, 201, 202, 203, 204};
    private static final String[] charsetNames = new String[]{"IBM437", "IBM850", "windows-1252", "x-MacRoman", "IBM865", "IBM437", "IBM850", "IBM437", "IBM437", "IBM850", "IBM437", "IBM850", "IBM437", "IBM850", "x-IBM943", "IBM850", "IBM437", "IBM850", "IBM865", "IBM437", "IBM437", "IBM850", "IBM437", "IBM863", "IBM850", "IBM852", "IBM852", "IBM852", "IBM860", "IBM850", "IBM866", "IBM850", "IBM852", "x-mswin-936", "x-IBM949", "IBM950", "x-IBM874", "windows-1252", "windows-1252", "windows-1252", "IBM852", "IBM866", "IBM865", "IBM861", "IBM437", "IBM437", "x-IBM737", "IBM857", "IBM863", "x-IBM950", "x-IBM949", "x-mswin-936", "x-IBM942", "x-IBM874", "windows-1255", "windows-1256", "x-IBM737", "IBM852", "IBM857", "windows-1250", "windows-1251", "windows-1254", "windows-1253", "windows-1257"};

    @Override
    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "cpg");
        return f;
    }

    @Override
    public File getFile() {
        return this.source;
    }

    @Override
    public String getCharsetName() {
        return this.charsetName;
    }

    @Override
    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    @Override
    public String toCharsetName(String codePageName) {
        if (codePageName.equals("UTF8")) {
            return "UTF-8";
        }
        if (codePageName.equals("SJIS")) {
            return "Shift_JIS";
        }
        if (StringUtils.isNumeric((CharSequence)codePageName)) {
            if (codePageName.startsWith("8859") && codePageName.length() > 4) {
                return "ISO-8859-" + codePageName.substring(4);
            }
            if (codePageName.startsWith("125") && codePageName.length() == 4) {
                return "windows-" + codePageName;
            }
            if (codePageName.length() == 3) {
                return "IBM-" + codePageName;
            }
            for (int i = 0; i < charsetNames.length; ++i) {
                if (!charsetNames[i].contains(codePageName)) continue;
                return codePageName;
            }
        }
        if (codePageName.equals("65001")) {
            return "UTF-8";
        }
        return codePageName;
    }

    @Override
    public String toCharsetName(int codePage) {
        if (codePage != 0) {
            for (int i = 0; i < codePages.length; ++i) {
                if (codePages[i] != codePage) continue;
                return charsetNames[i];
            }
        }
        return null;
    }

    @Override
    public String toCPGName(String charsetName) {
        if (charsetName.startsWith("windows-") || charsetName.startsWith("ISO-8859") || charsetName.startsWith("IBM-") || charsetName.startsWith("x-IBM") || charsetName.startsWith("x-mswin-")) {
            return charsetName.replaceAll("[^\\d]", "");
        }
        if (charsetName.equals("Shift_JIS")) {
            return "SJIS";
        }
        return charsetName;
    }

    @Override
    public int toCPG(String charsetName) {
        for (int i = 0; i < charsetNames.length; ++i) {
            if (!charsetNames[i].equals(charsetName)) continue;
            return codePages[i];
        }
        return 0;
    }

    @Override
    public void read(File file) throws IOException {
        File f = this.getFile(file);
        if (f.exists()) {
            try {
                String theContents = FileUtils.readFileToString((File)f);
                theContents = StringUtils.trim((String)theContents);
                if (StringUtils.isNotEmpty((CharSequence)theContents)) {
                    String theCharset;
                    this.charsetName = theCharset = this.toCharsetName(theContents);
                    this.source = f.getAbsoluteFile();
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read cpg file (" + f.getAbsolutePath() + ").", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws IOException {
        File f = this.getFile(file);
        try {
            String contents = this.toCPGName(this.charsetName) + "\n";
            BufferedOutputStream os = null;
            try {
                os = new BufferedOutputStream(FileUtils.openOutputStream((File)f));
                IOUtils.write((String)contents, (OutputStream)os, (String)"ISO-8859-1");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(os);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)os);
            this.source = f;
        }
        catch (Exception e) {
            logger.warn("Couldn't write cpg file (" + f.getAbsolutePath() + ").", (Throwable)e);
            throw e;
        }
    }
}

