/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.cresques.cts.IProjection;
import org.gvsig.basicformats.PRJFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.gvsig.fmap.crs.CRSFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPRJFile
extends AbstractFormatFile
implements PRJFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPRJFile.class);
    private File source = null;
    private IProjection crs = null;

    @Override
    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "prj");
        return f;
    }

    @Override
    public File getFile() {
        return this.source;
    }

    @Override
    public IProjection getCRS() {
        return this.crs;
    }

    @Override
    public void setCRS(IProjection crs) {
        this.crs = crs;
    }

    @Override
    public void read(File file) throws IOException {
        File f = this.getFile(file);
        if (f.exists()) {
            try {
                String theContents = FileUtils.readFileToString((File)f);
                if (StringUtils.isNotEmpty((CharSequence)theContents)) {
                    IProjection theCrs;
                    this.crs = theCrs = CRSFactory.getCRSFactory().get("wkt_esri", theContents);
                    this.source = f.getAbsoluteFile();
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read prj file (" + f.getAbsolutePath() + ").", (Throwable)e);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(File file) throws IOException {
        block4: {
            File f = this.getFile(file);
            try {
                String contents = this.crs.export("wkt_esri");
                if (contents == null) break block4;
                BufferedOutputStream os = null;
                try {
                    os = new BufferedOutputStream(FileUtils.openOutputStream((File)f));
                    IOUtils.write((String)contents, (OutputStream)os, (Charset)StandardCharsets.UTF_8);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
                IOUtils.closeQuietly((OutputStream)os);
                this.source = f;
            }
            catch (Exception e) {
                logger.warn("Couldn't write prj file (" + f.getAbsolutePath() + ").", (Throwable)e);
                throw e;
            }
        }
    }
}

