/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.basicformats.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.gvsig.basicformats.WLDFile;
import org.gvsig.basicformats.impl.AbstractFormatFile;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWLDFile
extends AbstractFormatFile
implements WLDFile {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWLDFile.class);
    private File source = null;
    private double pixelSizeX;
    private double rotationAxisY;
    private double rotationAxisX;
    private double pixelSizeY;
    private double upperLeftPixelCenterCoordX;
    private double upperLeftPixelCenterCoordY;

    @Override
    public File getFile(File file) {
        File f = new File(FilenameUtils.removeExtension((String)file.getAbsolutePath()) + "." + "wld");
        return f;
    }

    @Override
    public File getFile() {
        return this.source;
    }

    @Override
    public void read(File file) throws IOException {
        File f = this.getFile(file);
        if (f.exists()) {
            try {
                List lines = FileUtils.readLines((File)f);
                if (lines != null) {
                    this.source = f.getAbsoluteFile();
                    int lineno = 0;
                    for (String line : lines) {
                        line = line.trim();
                        char ch = line.charAt(0);
                        if (lineno > 5 || Character.isLetter(ch) || ch == ';' || ch == '#') continue;
                        try {
                            double value = Double.parseDouble(line);
                            switch (lineno) {
                                case 0: {
                                    this.pixelSizeX = value;
                                    break;
                                }
                                case 1: {
                                    this.rotationAxisY = value;
                                    break;
                                }
                                case 2: {
                                    this.rotationAxisX = value;
                                    break;
                                }
                                case 3: {
                                    this.pixelSizeY = value;
                                    break;
                                }
                                case 4: {
                                    this.upperLeftPixelCenterCoordX = value;
                                    break;
                                }
                                case 5: {
                                    this.upperLeftPixelCenterCoordY = value;
                                }
                            }
                            ++lineno;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            catch (IOException e) {
                logger.warn("Couldn't read wld file (" + f.getAbsolutePath() + ").", (Throwable)e);
                throw e;
            }
        }
    }

    @Override
    public Envelope getEnvelope(int rows, int columns) {
        Envelope envelope = null;
        if (0.0 != this.getRotationAxisX() || 0.0 != this.getRotationAxisY()) {
            logger.warn("Rotation in wld file not implemented yet. It will be ignored");
        }
        double leftMostX = 0.0;
        double upperMostY = 0.0;
        double height = 0.0;
        double width = 0.0;
        try {
            leftMostX = this.getUpperLeftPixelCenterCoordX() - this.getPixelSizeX() * 0.5;
            upperMostY = this.getUpperLeftPixelCenterCoordY() - this.getPixelSizeY() * 0.5;
            height = (double)rows * this.getPixelSizeY();
            width = (double)columns * this.getPixelSizeX();
            envelope = GeometryLocator.getGeometryManager().createEnvelope(Math.min(leftMostX, leftMostX + width), Math.min(upperMostY, upperMostY + height), Math.max(leftMostX, leftMostX + width), Math.max(upperMostY, upperMostY + height), 0);
        }
        catch (Exception e) {
            logger.warn("Failed to create envelope from wld file with coords: minx:" + leftMostX + ", miny:" + upperMostY + ", maxX: " + leftMostX + width + ", maxY: " + upperMostY + height, (Throwable)e);
        }
        return envelope;
    }

    @Override
    public void write(File file) {
        File f = this.getFile(file);
    }

    @Override
    public void setValue(Envelope envelope, int rows, int columns) {
    }

    @Override
    public double getPixelSizeX() {
        return this.pixelSizeX;
    }

    @Override
    public double getRotationAxisY() {
        return this.rotationAxisY;
    }

    @Override
    public double getRotationAxisX() {
        return this.rotationAxisX;
    }

    @Override
    public double getPixelSizeY() {
        return this.pixelSizeY;
    }

    @Override
    public double getUpperLeftPixelCenterCoordX() {
        return this.upperLeftPixelCenterCoordX;
    }

    @Override
    public double getUpperLeftPixelCenterCoordY() {
        return this.upperLeftPixelCenterCoordY;
    }
}

