/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.grid;

import java.awt.Color;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageFunction;
import javax.units.Unit;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.spatialschema.geometry.Envelope;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class GridCoverageFactory {
    public GridCoverage create(CharSequence name, ImageFunction function, CoordinateReferenceSystem crs, GridGeometry2D gridGeometry, GridSampleDimension[] bands, Map properties) throws MismatchedDimensionException {
        return new GridCoverage2D(name, function, crs, gridGeometry, bands, properties);
    }

    public GridCoverage create(CharSequence name, WritableRaster raster, Envelope envelope) throws MismatchedDimensionException {
        return new GridCoverage2D(name, raster, envelope);
    }

    public GridCoverage create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, Envelope envelope, double[] minValues, double[] maxValues, Unit units, Color[][] colors, RenderingHints hints) throws MismatchedDimensionException, IllegalArgumentException {
        return new GridCoverage2D(name, raster, crs, envelope, minValues, maxValues, units, colors, hints);
    }

    public GridCoverage create(CharSequence name, WritableRaster raster, CoordinateReferenceSystem crs, MathTransform gridToCRS, double[] minValues, double[] maxValues, Unit units, Color[][] colors, RenderingHints hints) throws MismatchedDimensionException, IllegalArgumentException {
        return new GridCoverage2D(name, raster, crs, gridToCRS, minValues, maxValues, units, colors, hints);
    }

    public GridCoverage create(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, Envelope envelope) throws MismatchedDimensionException {
        return new GridCoverage2D(name, image, crs, envelope);
    }

    public GridCoverage create(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, Envelope envelope, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) throws MismatchedDimensionException, IllegalArgumentException {
        return new GridCoverage2D(name, image, crs, envelope, bands, sources, properties);
    }

    public GridCoverage create(CharSequence name, RenderedImage image, CoordinateReferenceSystem crs, MathTransform gridToCRS, GridSampleDimension[] bands, GridCoverage[] sources, Map properties) throws MismatchedDimensionException, IllegalArgumentException {
        return new GridCoverage2D(name, image, crs, gridToCRS, bands, sources, properties);
    }
}

