/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.operation;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GeneralGridRange;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.coverage.processing.AbstractGridCoverageProcessor;
import org.geotools.coverage.processing.CannotReprojectException;
import org.geotools.coverage.processing.Operation2D;
import org.geotools.factory.Hints;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.operation.LinearTransform;
import org.geotools.referencing.operation.transform.DimensionFilter;
import org.geotools.referencing.operation.transform.IdentityTransform;
import org.geotools.referencing.operation.transform.WarpTransform2D;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.GCSUtilities;
import org.geotools.resources.XArray;
import org.geotools.resources.gcs.Resources;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.coverage.grid.GridRange;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;
import org.opengis.spatialschema.geometry.Envelope;

public final class Resampler2D
extends GridCoverage2D {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$opengis$referencing$crs$CoordinateReferenceSystem;
    static /* synthetic */ Class class$org$geotools$coverage$grid$GridGeometry2D;

    private Resampler2D(GridCoverage2D source, RenderedImage image, CoordinateReferenceSystem crs, MathTransform gridToCRS) {
        super((CharSequence)source.getName(), image, crs, gridToCRS, source.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{source}, null);
    }

    private Resampler2D(GridCoverage2D source, RenderedImage image, CoordinateReferenceSystem crs, Envelope envelope) {
        super((CharSequence)source.getName(), image, crs, envelope, source.getSampleDimensions(), (GridCoverage[])new GridCoverage2D[]{source}, null);
    }

    public static GridCoverage2D reproject(GridCoverage2D sourceCoverage, CoordinateReferenceSystem targetCRS, GridGeometry2D targetGG, Interpolation interpolation, Hints hints) throws FactoryException, TransformException {
        ImageLayout layout;
        MathTransform step3;
        MathTransform2D step1;
        LinearTransform transform;
        LinearTransform step2;
        MathTransform step2x;
        Vector<RenderedImage> sources;
        GridCoverage2D candidate;
        boolean sameCRS;
        CoordinateReferenceSystem sourceCRS;
        GridGeometry2D sourceGG;
        Object property = hints != null ? hints.get(Hints.JAI_INSTANCE) : null;
        JAI processor = property instanceof JAI ? (JAI)property : JAI.getDefaultInstance();
        CoordinateOperationFactory factory = FactoryFinder.getCoordinateOperationFactory(hints);
        MathTransformFactory mtFactory = FactoryFinder.getMathTransformFactory(hints);
        while (true) {
            sourceGG = (GridGeometry2D)sourceCoverage.getGridGeometry();
            sourceCRS = sourceCoverage.getCoordinateReferenceSystem();
            boolean sameGG = targetGG == null || Resampler2D.equivalent(targetGG, sourceGG);
            boolean bl = sameCRS = targetCRS == null || CRSUtilities.equalsIgnoreMetadata(targetCRS, sourceCRS);
            if (sameGG && sameCRS) {
                return sourceCoverage;
            }
            if (!(sourceCoverage instanceof Resampler2D)) break;
            List sources2 = sourceCoverage.getSources();
            if (sources2.size() != 1) {
                throw new AssertionError(sources2);
            }
            sourceCoverage = (GridCoverage2D)sources2.get(0);
        }
        Boolean targetGeophysics = null;
        if (interpolation instanceof InterpolationNearest && (candidate = sourceCoverage.geophysics(false)) != sourceCoverage && (sources = sourceCoverage.getRenderedImage().getSources()) != null && sources.contains(candidate.getRenderedImage())) {
            sourceCoverage = candidate;
            targetGeophysics = Boolean.TRUE;
        }
        PlanarImage sourceImage = PlanarImage.wrapRenderedImage((RenderedImage)sourceCoverage.getRenderedImage());
        ParameterBlock paramBlk = new ParameterBlock().addSource(sourceImage);
        RenderingHints targetHints = ImageUtilities.getRenderingHints((RenderedImage)sourceImage);
        if (targetHints == null) {
            targetHints = hints;
        } else if (hints != null) {
            targetHints.add(hints);
        }
        RenderedOp targetImage = processor.createNS("Null", paramBlk, targetHints);
        GridCoverage2D targetCoverage = null;
        if (sameCRS) {
            step2x = null;
            step2 = IdentityTransform.create(2);
            if (!GCSUtilities.hasTransform(targetGG)) {
                targetGG = new GridGeometry2D(targetGG.getGridRange(), sourceGG.getGridToCoordinateSystem());
            }
        } else {
            if (sourceCRS == null || targetCRS == null) {
                throw new CannotReprojectException(Resources.format(78));
            }
            step2x = factory.createOperation(sourceCRS, targetCRS).getMathTransform();
            MathTransform2D step2r = Resampler2D.getMathTransform2D(step2x, mtFactory, sourceGG.axisDimensionX, sourceGG.axisDimensionY);
            Envelope sourceEnvelope = sourceCoverage.getEnvelope();
            Envelope2D sourceEnvelope2D = sourceCoverage.getEnvelope2D();
            GeneralEnvelope targetEnvelope = CRSUtilities.transform(step2x, sourceEnvelope);
            GeneralEnvelope targetEnvelope2D = CRSUtilities.transform((MathTransform)step2r, sourceEnvelope2D);
            if (!new Envelope2D(targetEnvelope2D).boundsEquals(targetEnvelope, sourceGG.axisDimensionX, sourceGG.axisDimensionY, 1.0E-8)) {
                throw new TransformException(Resources.format(64));
            }
            if (targetGG == null) {
                targetCoverage = new Resampler2D(sourceCoverage, (RenderedImage)targetImage, targetCRS, (Envelope)targetEnvelope);
                targetGG = (GridGeometry2D)targetCoverage.getGridGeometry();
            } else if (!GCSUtilities.hasTransform(targetGG)) {
                targetGG = new GridGeometry2D(targetGG.getGridRange(), targetEnvelope, null);
            } else if (!GCSUtilities.hasGridRange(targetGG)) {
                MathTransform step3x = targetGG.getGridToCoordinateSystem();
                GeneralEnvelope gridRange = CRSUtilities.transform(step3x.inverse(), targetEnvelope);
                int i = gridRange.getDimension();
                while (--i >= 0) {
                    gridRange.setRange(i, gridRange.getMinimum(i) + 0.5, gridRange.getMaximum(i) + 0.5);
                }
                targetGG = new GridGeometry2D(GCSUtilities.toGridRange(gridRange), step3x);
            }
            step2 = step2r.inverse();
        }
        if (!((transform = (step1 = targetGG.getGridToCoordinateSystem2D()).equals((step3 = sourceGG.getGridToCoordinateSystem2D().inverse()).inverse()) ? step2 : mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform((MathTransform)step1, (MathTransform)step2), step3)) instanceof MathTransform2D)) {
            throw new TransformException(Resources.format(64));
        }
        if (!GCSUtilities.hasGridRange(targetGG)) {
            MathTransform step3x;
            MathTransform step1x = targetGG.getGridToCoordinateSystem();
            MathTransform xtr = step1x.equals((step3x = sourceGG.getGridToCoordinateSystem().inverse()).inverse()) ? step2x : (step2x == null ? mtFactory.createConcatenatedTransform(step1x, step3x) : mtFactory.createConcatenatedTransform(mtFactory.createConcatenatedTransform(step1x, step2x), step3x));
            if (xtr != null) {
                if (!$assertionsDisabled && !Resampler2D.getMathTransform2D(xtr, mtFactory, sourceGG.gridDimensionX, sourceGG.gridDimensionY).equals(transform)) {
                    throw new AssertionError(xtr);
                }
                Envelope envelope = GCSUtilities.toEnvelope(sourceGG.getGridRange());
                envelope = CRSUtilities.transform(xtr.inverse(), envelope);
                targetGG = new GridGeometry2D(GCSUtilities.toGridRange(envelope), step1x);
            } else {
                if (!$assertionsDisabled && !transform.isIdentity()) {
                    throw new AssertionError(transform);
                }
                targetGG = sourceGG;
            }
        }
        GridRange gridRange = (targetCoverage != null ? targetCoverage.getGridGeometry() : targetGG).getGridRange();
        int layoutMask = 0;
        if (hints != null && (layout = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            layoutMask = layout.getValidMask();
        }
        layout = (layout = (ImageLayout)targetImage.getRenderingHint(JAI.KEY_IMAGE_LAYOUT)) != null ? (ImageLayout)layout.clone() : new ImageLayout();
        if (0 == (layoutMask & 0xF)) {
            layout.setMinX(gridRange.getLower(0));
            layout.setMinY(gridRange.getLower(1));
            layout.setWidth(gridRange.getLength(0));
            layout.setHeight(gridRange.getLength(1));
            targetImage.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
        }
        if (0 == (layoutMask & 0xF0)) {
            layout.setTileGridXOffset(layout.getMinX((RenderedImage)targetImage));
            layout.setTileGridYOffset(layout.getMinY((RenderedImage)targetImage));
            int width = layout.getWidth((RenderedImage)targetImage);
            int height = layout.getHeight((RenderedImage)targetImage);
            if (layout.getTileWidth((RenderedImage)targetImage) > width) {
                layout.setTileWidth(width);
            }
            if (layout.getTileHeight((RenderedImage)targetImage) > height) {
                layout.setTileHeight(height);
            }
            targetImage.setRenderingHint(JAI.KEY_IMAGE_LAYOUT, (Object)layout);
        }
        if (transform.isIdentity()) {
            GridRange sourceGR = sourceGG.getGridRange();
            GridRange targetGR = targetGG.getGridRange();
            int xmin = targetGR.getLower(0);
            int xmax = targetGR.getUpper(0);
            int ymin = targetGR.getLower(1);
            int ymax = targetGR.getUpper(1);
            if (xmin >= sourceGR.getLower(0) && xmax <= sourceGR.getUpper(0) && ymin >= sourceGR.getLower(1) && ymax <= sourceGR.getUpper(1)) {
                paramBlk.add((float)xmin);
                paramBlk.add((float)ymin);
                paramBlk.add((float)(xmax - xmin));
                paramBlk.add((float)(ymax - ymin));
                targetImage.setParameterBlock(paramBlk);
                targetImage.setOperationName("Crop");
            }
        }
        GridSampleDimension[] sampleDimensions = sourceCoverage.getSampleDimensions();
        double[] background = new double[sampleDimensions.length];
        for (int i = 0; i < background.length; ++i) {
            NumberRange range = sampleDimensions[i].getBackground().getRange();
            double min = range.getMinimum();
            double max = range.getMaximum();
            background[i] = range.isMinIncluded() ? min : (range.isMaxIncluded() ? max : 0.5 * (min + max));
        }
        if (targetImage.getOperationName().equalsIgnoreCase("Null") && transform instanceof AffineTransform) {
            if (targetCoverage != null) {
                MathTransform mtr = targetGG.getGridToCoordinateSystem();
                mtr = mtFactory.createConcatenatedTransform(transform.inverse(), mtr);
                targetGG = new GridGeometry2D(sourceGG.getGridRange(), mtr);
                return new Resampler2D(sourceCoverage, (RenderedImage)sourceImage, targetCRS, targetGG.getGridToCoordinateSystem());
            }
            AffineTransform affine = (AffineTransform)transform.inverse();
            paramBlk.add(affine).add(interpolation).add(background);
            targetImage.setParameterBlock(paramBlk);
            targetImage.setOperationName("Affine");
            Rectangle targetBounds = targetGG.getGridRange2D();
            if (!targetBounds.equals(targetImage.getBounds())) {
                if (targetCoverage == null) {
                    paramBlk.removeParameters();
                    targetImage.setOperationName("Null");
                    targetImage.setParameterBlock(paramBlk);
                } else {
                    targetCoverage = new Resampler2D(sourceCoverage, (RenderedImage)targetImage, targetCRS, targetCoverage.getEnvelope());
                    targetGG = (GridGeometry2D)targetCoverage.getGridGeometry();
                }
            }
        }
        if (targetImage.getOperationName().equalsIgnoreCase("Null")) {
            paramBlk.add(WarpTransform2D.getWarp((CharSequence)sourceCoverage.getName(), (MathTransform2D)transform));
            paramBlk.add(interpolation).add(background);
            targetImage.setParameterBlock(paramBlk);
            targetImage.setOperationName("Warp");
        }
        if (targetGG != null) {
            GridRange targetGR = targetGG.getGridRange();
            int[] lower = targetGR.getLowers();
            int[] upper = targetGR.getUppers();
            lower[0] = targetImage.getMinX();
            lower[1] = targetImage.getMinY();
            upper[0] = targetImage.getWidth() + lower[0];
            upper[1] = targetImage.getHeight() + lower[1];
            GeneralGridRange actualGR = new GeneralGridRange(lower, upper);
            if (!targetGR.equals(actualGR)) {
                MathTransform gridToCoordinateSystem = targetGG.getGridToCoordinateSystem();
                targetGG = new GridGeometry2D(actualGR, gridToCoordinateSystem);
                targetCoverage = null;
            }
        }
        if (targetCoverage == null) {
            targetCoverage = new Resampler2D(sourceCoverage, (RenderedImage)targetImage, targetCRS, targetGG.getGridToCoordinateSystem());
        }
        if (targetGeophysics != null) {
            targetCoverage = targetCoverage.geophysics(targetGeophysics);
        }
        if (!$assertionsDisabled && !CRSUtilities.equalsIgnoreMetadata(targetCoverage.getCoordinateReferenceSystem(), targetCRS != null ? targetCRS : sourceCRS)) {
            throw new AssertionError(targetCoverage);
        }
        if (!$assertionsDisabled && targetGG == null && !targetImage.getBounds().equals(sourceImage.getBounds())) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !((GridGeometry2D)targetCoverage.getGridGeometry()).getGridRange2D().equals(targetImage.getBounds())) {
            throw new AssertionError(targetGG);
        }
        if (AbstractGridCoverageProcessor.LOGGER.isLoggable(Level.FINE)) {
            Locale locale = sourceCoverage.getLocale();
            Object[] objectArray = new Object[11];
            objectArray[0] = sourceCoverage.getName().toString(locale);
            objectArray[1] = sourceCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[2] = new Integer(sourceImage.getWidth());
            objectArray[3] = new Integer(sourceImage.getHeight());
            objectArray[4] = targetCoverage.getCoordinateReferenceSystem().getName().getCode();
            objectArray[5] = new Integer(targetImage.getWidth());
            objectArray[6] = new Integer(targetImage.getHeight());
            objectArray[7] = targetImage.getOperationName();
            objectArray[8] = new Integer(sourceCoverage == sourceCoverage.geophysics(true) ? 1 : 0);
            objectArray[9] = ImageUtilities.getInterpolationName(interpolation);
            objectArray[10] = background.length == 1 ? (Double.isNaN(background[0]) ? "NaN" : new Double(background[0])) : XArray.toString(background, locale);
            Resampler2D.log(Resources.getResources(locale).getLogRecord(Level.FINE, 82, objectArray));
        }
        return targetCoverage;
    }

    private static MathTransform2D getMathTransform2D(MathTransform transform, MathTransformFactory mtFactory, int xAxis, int yAxis) throws FactoryException {
        DimensionFilter filter = new DimensionFilter(mtFactory);
        filter.addSourceDimension(xAxis);
        filter.addSourceDimension(yAxis);
        MathTransform candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        filter.addTargetDimension(xAxis);
        filter.addTargetDimension(yAxis);
        candidate = filter.separate(transform);
        if (candidate instanceof MathTransform2D) {
            return (MathTransform2D)candidate;
        }
        throw new FactoryException(Resources.format(64));
    }

    private static boolean equivalent(GridGeometry2D geom1, GridGeometry2D geom2) {
        if (geom1.equals(geom2)) {
            return true;
        }
        try {
            if (!geom1.getGridRange().equals(geom2.getGridRange())) {
                return false;
            }
        }
        catch (InvalidGridGeometryException exception) {
            // empty catch block
        }
        try {
            if (!geom1.getGridToCoordinateSystem().equals(geom2.getGridToCoordinateSystem())) {
                return false;
            }
        }
        catch (InvalidGridGeometryException invalidGridGeometryException) {
            // empty catch block
        }
        return true;
    }

    private static void log(LogRecord record) {
        record.setSourceClassName("GridCoverageProcessor");
        record.setSourceMethodName("doOperation(\"Resample\")");
        AbstractGridCoverageProcessor.LOGGER.log(record);
    }

    static {
        $assertionsDisabled = !Resampler2D.class.desiredAssertionStatus();
        ImageUtilities.allowNativeAcceleration("Affine", false);
    }

    public static final class Operation
    extends Operation2D {
        public static final ParameterDescriptor INTERPOLATION_TYPE = new DefaultParameterDescriptor("InterpolationType", class$java$lang$Object == null ? (class$java$lang$Object = Resampler2D.class$("java.lang.Object")) : class$java$lang$Object, null, "NearestNeighbor");
        public static final ParameterDescriptor COORDINATE_REFERENCE_SYSTEM = new DefaultParameterDescriptor("CoordinateReferenceSystem", class$org$opengis$referencing$crs$CoordinateReferenceSystem == null ? (class$org$opengis$referencing$crs$CoordinateReferenceSystem = Resampler2D.class$("org.opengis.referencing.crs.CoordinateReferenceSystem")) : class$org$opengis$referencing$crs$CoordinateReferenceSystem, null, null);
        public static final ParameterDescriptor GRID_GEOMETRY = new DefaultParameterDescriptor("GridGeometry", class$org$geotools$coverage$grid$GridGeometry2D == null ? (class$org$geotools$coverage$grid$GridGeometry2D = Resampler2D.class$("org.geotools.coverage.grid.GridGeometry2D")) : class$org$geotools$coverage$grid$GridGeometry2D, null, null);

        public Operation() {
            super(new DefaultParameterDescriptorGroup("Resample", (GeneralParameterDescriptor[])new ParameterDescriptor[]{SOURCE_0, INTERPOLATION_TYPE, COORDINATE_REFERENCE_SYSTEM, GRID_GEOMETRY}));
        }

        protected GridCoverage2D doOperation(ParameterValueGroup parameters, RenderingHints hints) {
            GridCoverage2D coverage;
            GridCoverage2D source = (GridCoverage2D)parameters.parameter("Source").getValue();
            Interpolation interp = ImageUtilities.toInterpolation(parameters.parameter("InterpolationType").getValue());
            CoordinateReferenceSystem crs = (CoordinateReferenceSystem)parameters.parameter("CoordinateReferenceSystem").getValue();
            GridGeometry2D gridGeom = (GridGeometry2D)parameters.parameter("GridGeometry").getValue();
            if (crs == null) {
                crs = source.getCoordinateReferenceSystem();
            }
            try {
                coverage = Resampler2D.reproject(source, crs, gridGeom, interp, hints instanceof Hints ? (Hints)hints : new Hints((Map)hints));
            }
            catch (FactoryException exception) {
                throw new CannotReprojectException(Resources.format(47, source.getName()), exception);
            }
            catch (TransformException exception) {
                throw new CannotReprojectException(Resources.format(47, source.getName()), exception);
            }
            if (gridGeom != null) {
                boolean mismatche = false;
                GridGeometry2D actualGeom = (GridGeometry2D)coverage.getGridGeometry();
                if (GCSUtilities.hasGridRange(gridGeom)) {
                    mismatche |= !gridGeom.getGridRange().equals(actualGeom.getGridRange());
                }
                if (GCSUtilities.hasTransform(gridGeom)) {
                    mismatche |= !gridGeom.getGridToCoordinateSystem().equals(actualGeom.getGridToCoordinateSystem());
                }
                if (mismatche) {
                    Locale locale = source.getLocale();
                    Resampler2D.log(Resources.getResources(locale).getLogRecord(Level.WARNING, 34, coverage.getName().toString(locale)));
                }
            }
            return coverage;
        }
    }
}

