/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SimpleFeature;
import org.geotools.filter.FidFilter;
import org.geotools.filter.Filter;
import org.geotools.filter.FilterFactory;

public class DataTestCase
extends TestCase {
    protected GeometryFactory gf;
    protected FeatureType roadType;
    protected FeatureType subRoadType;
    protected SimpleFeature[] roadFeatures;
    protected Envelope roadBounds;
    protected Envelope rd12Bounds;
    protected Filter rd1Filter;
    protected Filter rd2Filter;
    protected Filter rd12Filter;
    protected Feature newRoad;
    protected FeatureType riverType;
    protected FeatureType subRiverType;
    protected Feature[] riverFeatures;
    protected Envelope riverBounds;
    protected Filter rv1Filter;
    protected Feature newRiver;
    protected FeatureType lakeType;
    protected Feature[] lakeFeatures;
    protected Envelope lakeBounds;

    public DataTestCase(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        String namespace = this.getName();
        this.roadType = DataUtilities.createType(namespace + ".road", "id:0,geom:LineString,name:String");
        this.subRoadType = DataUtilities.createType(namespace + "road", "id:0,geom:LineString");
        this.gf = new GeometryFactory();
        this.roadFeatures = new SimpleFeature[3];
        this.roadFeatures[0] = (SimpleFeature)this.roadType.create(new Object[]{new Integer(1), this.line(new int[]{1, 1, 2, 2, 4, 2, 5, 1}), "r1"}, "road.rd1");
        this.roadFeatures[1] = (SimpleFeature)this.roadType.create(new Object[]{new Integer(2), this.line(new int[]{3, 0, 3, 2, 3, 3, 3, 4}), "r2"}, "road.rd2");
        this.roadFeatures[2] = (SimpleFeature)this.roadType.create(new Object[]{new Integer(3), this.line(new int[]{3, 2, 4, 2, 5, 3}), "r3"}, "road.rd3");
        this.roadBounds = new Envelope();
        this.roadBounds.expandToInclude(this.roadFeatures[0].getBounds());
        this.roadBounds.expandToInclude(this.roadFeatures[1].getBounds());
        this.roadBounds.expandToInclude(this.roadFeatures[2].getBounds());
        FilterFactory factory = FilterFactory.createFilterFactory();
        this.rd1Filter = factory.createFidFilter("road.rd1");
        this.rd2Filter = factory.createFidFilter("road.rd2");
        FidFilter create = factory.createFidFilter();
        create.addFid("road.rd1");
        create.addFid("road.rd2");
        this.rd12Filter = create;
        this.rd12Bounds = new Envelope();
        this.rd12Bounds.expandToInclude(this.roadFeatures[0].getBounds());
        this.rd12Bounds.expandToInclude(this.roadFeatures[1].getBounds());
        this.newRoad = this.roadType.create(new Object[]{new Integer(4), this.line(new int[]{1, 2, 2, 3}), "r4"}, "road.rd4");
        this.riverType = DataUtilities.createType(namespace + ".river", "id:0,geom:MultiLineString,river:String,flow:0.0");
        this.subRiverType = DataUtilities.createType(namespace + ".river", "river:String,flow:0.0");
        this.gf = new GeometryFactory();
        this.riverFeatures = new Feature[2];
        this.riverFeatures[0] = this.riverType.create(new Object[]{new Integer(1), this.lines(new int[][]{{5, 5, 7, 4}, {7, 5, 9, 7, 13, 7}, {7, 5, 9, 3, 11, 3}}), "rv1", new Double(4.5)}, "river.rv1");
        this.riverFeatures[1] = this.riverType.create(new Object[]{new Integer(2), this.lines(new int[][]{{4, 6, 4, 8, 6, 10}}), "rv2", new Double(3.0)}, "river.rv2");
        this.riverBounds = new Envelope();
        this.riverBounds.expandToInclude(this.riverFeatures[0].getBounds());
        this.riverBounds.expandToInclude(this.riverFeatures[1].getBounds());
        this.rv1Filter = FilterFactory.createFilterFactory().createFidFilter("river.rv1");
        this.newRiver = this.riverType.create(new Object[]{new Integer(3), this.lines(new int[][]{{9, 5, 11, 5, 13, 3}}), "rv3", new Double(1.5)}, "river.rv3");
        this.lakeType = DataUtilities.createType(namespace + ".lake", "id:0,geom:Polygon:nillable,name:String");
        this.lakeFeatures = new Feature[1];
        this.lakeFeatures[0] = this.lakeType.create(new Object[]{new Integer(0), this.polygon(new int[]{12, 6, 14, 8, 16, 6, 16, 4, 14, 4, 12, 6}), "muddy"}, "lake.lk1");
        this.lakeBounds = new Envelope();
        this.lakeBounds.expandToInclude(this.lakeFeatures[0].getBounds());
    }

    protected void tearDown() throws Exception {
        this.gf = null;
        this.roadType = null;
        this.subRoadType = null;
        this.roadFeatures = null;
        this.roadBounds = null;
        this.rd1Filter = null;
        this.rd2Filter = null;
        this.newRoad = null;
        this.riverType = null;
        this.subRiverType = null;
        this.riverFeatures = null;
        this.riverBounds = null;
        this.rv1Filter = null;
        this.newRiver = null;
    }

    public LineString line(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLineString(coords);
    }

    public MultiLineString lines(int[][] xy) {
        LineString[] lines = new LineString[xy.length];
        for (int i = 0; i < xy.length; ++i) {
            lines[i] = this.line(xy[i]);
        }
        return this.gf.createMultiLineString(lines);
    }

    public Polygon polygon(int[] xy) {
        LinearRing shell = this.ring(xy);
        return this.gf.createPolygon(shell, null);
    }

    public Polygon polygon(int[] xy, int[][] holes) {
        if (holes == null || holes.length == 0) {
            return this.polygon(xy);
        }
        LinearRing shell = this.ring(xy);
        LinearRing[] rings = new LinearRing[holes.length];
        for (int i = 0; i < xy.length; ++i) {
            rings[i] = this.ring(holes[i]);
        }
        return this.gf.createPolygon(shell, rings);
    }

    public LinearRing ring(int[] xy) {
        Coordinate[] coords = new Coordinate[xy.length / 2];
        for (int i = 0; i < xy.length; i += 2) {
            coords[i / 2] = new Coordinate((double)xy[i], (double)xy[i + 1]);
        }
        return this.gf.createLinearRing(coords);
    }

    protected void assertEquals(Geometry expected, Geometry actual) {
        if (expected == actual) {
            return;
        }
        DataTestCase.assertNotNull((Object)expected);
        DataTestCase.assertNotNull((Object)actual);
        DataTestCase.assertTrue((boolean)expected.equals(actual));
    }

    protected void assertEquals(String message, Geometry expected, Geometry actual) {
        if (expected == actual) {
            return;
        }
        DataTestCase.assertNotNull((String)message, (Object)expected);
        DataTestCase.assertNotNull((String)message, (Object)actual);
        DataTestCase.assertTrue((String)message, (boolean)expected.equals(actual));
    }

    protected int count(FeatureReader reader) throws IOException {
        if (reader == null) {
            return -1;
        }
        int count = 0;
        try {
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
        }
        catch (NoSuchElementException e) {
            throw new DataSourceException("hasNext() lied to me at:" + count, e);
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("next() could not understand feature at:" + count, e);
        }
        finally {
            reader.close();
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int count(FeatureWriter writer) throws NoSuchElementException, IOException, IllegalAttributeException {
        int count = 0;
        try {
            while (writer.hasNext()) {
                writer.next();
                ++count;
            }
        }
        finally {
            writer.close();
        }
        return count;
    }
}

