/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.DataFeatureCollection;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureCollections;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.JTS;

public class DefaultFeatureResults
extends DataFeatureCollection {
    protected Query query;
    protected FeatureSource featureSource;

    public DefaultFeatureResults(FeatureSource source, Query query) {
        this.featureSource = source;
        String typeName = source.getSchema().getTypeName();
        if (typeName.equals(query.getTypeName())) {
            this.query = query;
        } else {
            this.query = new DefaultQuery(typeName, query.getFilter(), query.getMaxFeatures(), query.getPropertyNames(), query.getHandle());
            ((DefaultQuery)this.query).setCoordinateSystem(query.getCoordinateSystem());
            ((DefaultQuery)this.query).setCoordinateSystemReproject(query.getCoordinateSystemReproject());
        }
    }

    public FeatureType getSchema() {
        if (this.query.retrieveAllProperties()) {
            return this.featureSource.getSchema();
        }
        try {
            return DataUtilities.createSubType(this.featureSource.getSchema(), this.query.getPropertyNames());
        }
        catch (SchemaException e) {
            return this.featureSource.getSchema();
        }
    }

    protected Transaction getTransaction() {
        if (this.featureSource instanceof FeatureStore) {
            FeatureStore featureStore = (FeatureStore)this.featureSource;
            return featureStore.getTransaction();
        }
        return Transaction.AUTO_COMMIT;
    }

    public FeatureReader reader() throws IOException {
        FeatureReader reader = this.featureSource.getDataStore().getFeatureReader(this.query, this.getTransaction());
        int maxFeatures = this.query.getMaxFeatures();
        if (maxFeatures == Integer.MAX_VALUE) {
            return reader;
        }
        return new MaxFeatureReader(reader, maxFeatures);
    }

    public Envelope getBounds() {
        Envelope bounds;
        try {
            bounds = this.featureSource.getBounds(this.query);
        }
        catch (IOException e1) {
            return JTS.empty();
        }
        if (bounds != null) {
            return bounds;
        }
        try {
            bounds = new Envelope();
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                Feature feature = reader.next();
                bounds.expandToInclude(feature.getBounds());
            }
            reader.close();
            return bounds;
        }
        catch (IllegalAttributeException e) {
            return JTS.empty();
        }
        catch (IOException e) {
            return JTS.empty();
        }
    }

    public int getCount() throws IOException {
        int count = this.featureSource.getCount(this.query);
        if (count != -1) {
            return count;
        }
        try {
            count = 0;
            FeatureReader reader = this.reader();
            while (reader.hasNext()) {
                reader.next();
                ++count;
            }
            reader.close();
            return count;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", e);
        }
    }

    public FeatureCollection collection() throws IOException {
        try {
            FeatureCollection collection = FeatureCollections.newCollection();
            FeatureReader reader = this.reader();
            FeatureType type = reader.getFeatureType();
            while (reader.hasNext()) {
                collection.add(reader.next());
            }
            reader.close();
            return collection;
        }
        catch (IllegalAttributeException e) {
            throw new DataSourceException("Could not read feature ", e);
        }
    }
}

