/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.FactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public abstract class AbstractGridFormat
implements Format {
    protected Map mInfo;
    protected ParameterValueGroup readParameters;
    protected ParameterValueGroup writeParameters;
    protected static Map CRSAuthorityfactoriesMap = Collections.synchronizedMap(new HashMap());

    protected static synchronized void addAuthorityFactory(String code, CRSAuthorityFactory authorityFactory) {
        if (!CRSAuthorityfactoriesMap.containsKey(code)) {
            CRSAuthorityfactoriesMap.put(code, authorityFactory);
        }
    }

    protected static synchronized CRSAuthorityFactory getAuthorityfactory(String code) {
        if (CRSAuthorityfactoriesMap.containsKey(code)) {
            return (CRSAuthorityFactory)CRSAuthorityfactoriesMap.get(code);
        }
        CRSAuthorityFactory temp = FactoryFinder.getCRSAuthorityFactory(code, null);
        CRSAuthorityfactoriesMap.put(code, temp);
        return temp;
    }

    public String getName() {
        return (String)this.mInfo.get("name");
    }

    public String getDescription() {
        return (String)this.mInfo.get("description");
    }

    public String getVendor() {
        return (String)this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return (String)this.mInfo.get("docURL");
    }

    public String getVersion() {
        return (String)this.mInfo.get("version");
    }

    public abstract GridCoverageReader getReader(Object var1);

    public abstract GridCoverageWriter getWriter(Object var1);

    public abstract boolean accepts(Object var1);

    public boolean equals(Format f) {
        return f.getClass() == this.getClass();
    }

    public ParameterValueGroup getReadParameters() {
        return this.readParameters;
    }

    public ParameterValueGroup getWriteParameters() {
        return this.writeParameters;
    }

    public static CoordinateReferenceSystem getDefaultCRS() {
        try {
            CRSAuthorityFactory factory = AbstractGridFormat.getAuthorityfactory("EPSG");
            return factory.createCoordinateReferenceSystem("EPSG:4326");
        }
        catch (Exception e) {
            return DefaultGeographicCRS.WGS84;
        }
    }
}

