/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.GridFormatFactorySpi;
import org.geotools.factory.FactoryFinder;
import org.opengis.coverage.grid.Format;

public final class GridFormatFinder {
    private GridFormatFinder() {
    }

    public static Iterator getAvailableFormats() {
        HashSet<GridFormatFactorySpi> available = new HashSet<GridFormatFactorySpi>();
        Iterator it = FactoryFinder.factories(GridFormatFactorySpi.class);
        while (it.hasNext()) {
            GridFormatFactorySpi factory = (GridFormatFactorySpi)it.next();
            if (!factory.isAvailable()) continue;
            available.add(factory);
        }
        return available.iterator();
    }

    public static Format[] getFormatArray() {
        LinkedList<Format> formatSet = new LinkedList<Format>();
        Iterator iter = GridFormatFinder.getAvailableFormats();
        while (iter.hasNext()) {
            GridFormatFactorySpi element = (GridFormatFactorySpi)iter.next();
            formatSet.add(element.createFormat());
        }
        Format[] formats = new Format[formatSet.size()];
        formatSet.toArray(formats);
        return formats;
    }

    public static Format findFormat(Object o) {
        Format[] formats = GridFormatFinder.getFormatArray();
        for (int i = 0; i < formats.length; ++i) {
            Format f = formats[i];
            if (!((AbstractGridFormat)f).accepts(o)) continue;
            return f;
        }
        return null;
    }
}

