/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.coverage.grid.file;

import java.io.File;
import java.util.Iterator;
import org.geotools.data.coverage.grid.AbstractGridFormat;
import org.geotools.data.coverage.grid.UnknownFormat;
import org.geotools.data.coverage.grid.file.FileMetadata;
import org.geotools.data.coverage.grid.file.FileMetadataImpl;
import org.opengis.catalog.CatalogEntry;
import org.opengis.catalog.MetadataEntity;
import org.opengis.coverage.grid.Format;

public class FSCatalogEntry
implements CatalogEntry {
    private File resource;
    private FileMetadata metadata;

    public FSCatalogEntry(File f, Format[] formats) {
        this.resource = f;
        for (int i = 0; i < formats.length; ++i) {
            Format format = formats[i];
            if (!((AbstractGridFormat)format).accepts(f)) continue;
            this.metadata = new FileMetadataImpl(f, format);
        }
        if (this.metadata == null) {
            this.metadata = new FileMetadataImpl(f, new UnknownFormat());
        }
    }

    public String getDataName() {
        return this.resource.getPath();
    }

    public String[] getMetadataNames() {
        String[] n = new String[]{this.resource.getPath()};
        return n;
    }

    public MetadataEntity getMetadata(String name) {
        return this.metadata;
    }

    public Object getResource() {
        return this.resource;
    }

    public Iterator iterator() {
        return new FSIterator();
    }

    public int getNumMetadata() {
        return 1;
    }

    public MetadataEntity getMetadata(int index) {
        if (index < 0) {
            return null;
        }
        return this.metadata;
    }

    private class FSIterator
    implements Iterator {
        boolean next = false;

        private FSIterator() {
        }

        public void remove() {
        }

        public boolean hasNext() {
            return !this.next;
        }

        public Object next() {
            if (this.next) {
                return null;
            }
            return FSCatalogEntry.this.metadata;
        }
    }
}

