/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc;

import java.io.IOException;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.catalog.CatalogEntry;
import org.geotools.catalog.QueryRequest;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTypeEntry;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.SchemaNotFoundException;
import org.geotools.data.Transaction;
import org.geotools.data.TypeEntry;
import org.geotools.data.jdbc.ConnectionPool;
import org.geotools.data.jdbc.DefaultSQLBuilder;
import org.geotools.data.jdbc.FeatureTypeHandler;
import org.geotools.data.jdbc.FeatureTypeInfo;
import org.geotools.data.jdbc.JDBCDataStoreConfig;
import org.geotools.data.jdbc.JDBCFeatureLocking;
import org.geotools.data.jdbc.JDBCFeatureReader;
import org.geotools.data.jdbc.JDBCFeatureSource;
import org.geotools.data.jdbc.JDBCFeatureStore;
import org.geotools.data.jdbc.JDBCFeatureWriter;
import org.geotools.data.jdbc.JDBCTransactionState;
import org.geotools.data.jdbc.JDBCUtils;
import org.geotools.data.jdbc.QueryData;
import org.geotools.data.jdbc.SQLBuilder;
import org.geotools.data.jdbc.attributeio.AttributeIO;
import org.geotools.data.jdbc.attributeio.BasicAttributeIO;
import org.geotools.data.jdbc.fidmapper.DefaultFIDMapperFactory;
import org.geotools.data.jdbc.fidmapper.FIDMapper;
import org.geotools.data.jdbc.fidmapper.FIDMapperFactory;
import org.geotools.data.view.DefaultView;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.feature.AttributeType;
import org.geotools.feature.AttributeTypeFactory;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeFactory;
import org.geotools.feature.SchemaException;
import org.geotools.filter.Filter;
import org.geotools.filter.SQLEncoder;
import org.geotools.filter.SQLEncoderException;

public abstract class JDBCDataStore
implements DataStore {
    protected static final Logger LOGGER = Logger.getLogger("org.geotools.data.jdbc");
    protected static final Map TYPE_MAPPINGS = new HashMap();
    private BasicAttributeIO basicAttributeIO;
    public FeatureListenerManager listenerManager = new FeatureListenerManager();
    private LockingManager lockingManager = this.createLockingManager();
    protected ConnectionPool connectionPool;
    protected final JDBCDataStoreConfig config;
    protected FeatureTypeHandler typeHandler = null;
    protected String sqlNameEscape = "";
    protected boolean allowWriteOnVolatileFIDs;
    private List contents = null;

    public JDBCDataStore(ConnectionPool connectionPool, JDBCDataStoreConfig config) throws IOException {
        this.connectionPool = connectionPool;
        this.config = config;
        this.typeHandler = this.getFeatureTypeHandler(config);
    }

    public String getSqlNameEscape() {
        return this.sqlNameEscape;
    }

    protected void setSqlNameEscape(String sqlNameEscape) {
        this.sqlNameEscape = sqlNameEscape;
    }

    public List entries() {
        if (this.contents == null) {
            this.contents = this.createContents();
        }
        return Collections.unmodifiableList(this.contents);
    }

    protected List createContents() {
        try {
            String[] typeNames = this.getTypeNames();
            ArrayList<TypeEntry> list = new ArrayList<TypeEntry>(typeNames.length);
            for (int i = 0; i < typeNames.length; ++i) {
                list.add(this.createTypeEntry(typeNames[i]));
            }
            return Collections.unmodifiableList(list);
        }
        catch (IOException help) {
            LOGGER.warning("Could not aquire getTypeName() to build contents");
            return null;
        }
    }

    protected TypeEntry createTypeEntry(String typeName) {
        URI namespace;
        try {
            namespace = this.getSchema(typeName).getNamespace();
        }
        catch (IOException e) {
            namespace = null;
        }
        return new DefaultTypeEntry(this, namespace, typeName);
    }

    public List search(QueryRequest queryRequest) {
        if (queryRequest == QueryRequest.ALL) {
            return this.entries();
        }
        ArrayList<CatalogEntry> queryResults = new ArrayList<CatalogEntry>();
        Iterator i = this.entries().iterator();
        block0: while (i.hasNext()) {
            CatalogEntry entry = (CatalogEntry)i.next();
            Iterator m = entry.metadata().values().iterator();
            while (m.hasNext()) {
                if (!queryRequest.match(m.next())) continue;
                queryResults.add(entry);
                continue block0;
            }
        }
        return queryResults;
    }

    protected FeatureTypeHandler getFeatureTypeHandler(JDBCDataStoreConfig config) throws IOException {
        return new FeatureTypeHandler(this, this.buildFIDMapperFactory(config), config.getTypeHandlerTimeout());
    }

    protected FIDMapperFactory buildFIDMapperFactory(JDBCDataStoreConfig config) {
        return new DefaultFIDMapperFactory();
    }

    public FIDMapper getFIDMapper(String tableName) throws IOException {
        return this.typeHandler.getFIDMapper(tableName);
    }

    protected LockingManager createLockingManager() {
        return new InProcessLockingManager();
    }

    public String[] getTypeNames() throws IOException {
        return this.typeHandler.getTypeNames();
    }

    public FeatureType getSchema(String typeName) throws IOException {
        return this.typeHandler.getSchema(typeName);
    }

    public void createSchema(FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table creation not implemented");
    }

    public void updateSchema(String typeName, FeatureType featureType) throws IOException {
        throw new UnsupportedOperationException("Table modification not supported");
    }

    public FeatureSource getView(Query query) throws IOException, SchemaException {
        return new DefaultView(this.getFeatureSource(query.getTypeName()), query);
    }

    public FeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.typeHandler.getFIDMapper(typeName).isVolatile() || this.allowWriteOnVolatileFIDs) {
            if (this.getLockingManager() != null) {
                return new JDBCFeatureLocking(this, this.getSchema(typeName));
            }
            return new JDBCFeatureStore(this, this.getSchema(typeName));
        }
        return new JDBCFeatureSource(this, this.getSchema(typeName));
    }

    public FeatureReader getFeatureReader(FeatureType requestType, Filter filter, Transaction transaction) throws IOException {
        DefaultQuery query;
        String typeName = requestType.getTypeName();
        FeatureType schemaType = this.getSchema(typeName);
        int compare = DataUtilities.compare(requestType, schemaType);
        if (compare == 0) {
            query = new DefaultQuery(typeName, filter);
        } else if (compare == 1) {
            String[] names = this.attributeNames(requestType, filter);
            query = new DefaultQuery(typeName, filter, Integer.MAX_VALUE, names, "getFeatureReader");
        } else {
            throw new IOException("Type " + typeName + " does match request");
        }
        if (filter == Filter.ALL || filter.equals(Filter.ALL)) {
            return new EmptyFeatureReader(requestType);
        }
        FeatureReader reader = this.getFeatureReader(query, transaction);
        if (compare == 1) {
            reader = new ReTypeFeatureReader(reader, requestType);
        }
        return reader;
    }

    protected String[] attributeNames(FeatureType featureType, Filter filter) throws IOException {
        String typeName = featureType.getTypeName();
        FeatureType origional = this.getSchema(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        if (featureType.getAttributeCount() == origional.getAttributeCount()) {
            return DataUtilities.attributeNames(featureType);
        }
        String[] typeAttributes = DataUtilities.attributeNames(featureType);
        String[] filterAttributes = DataUtilities.attributeNames(sqlBuilder.getPostQueryFilter(filter));
        if (filterAttributes == null || filterAttributes.length == 0) {
            return typeAttributes;
        }
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(typeAttributes));
        set.addAll(Arrays.asList(filterAttributes));
        if (set.size() == typeAttributes.length) {
            return typeAttributes;
        }
        return set.toArray(new String[set.size()]);
    }

    public FeatureReader getFeatureReader(Query query, Transaction trans) throws IOException {
        FeatureType schema;
        String[] propertyNames;
        String typeName = query.getTypeName();
        FeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo typeInfo = this.typeHandler.getFeatureTypeInfo(typeName);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        String[] requestedNames = this.propertyNames(query);
        if (this.allSameOrder(requestedNames, featureType)) {
            propertyNames = requestedNames;
        } else if (requestedNames.length <= featureType.getAttributeCount()) {
            String[] filterNames = DataUtilities.attributeNames(postFilter);
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(requestedNames));
            set.addAll(Arrays.asList(filterNames));
            propertyNames = set.size() == requestedNames.length ? requestedNames : set.toArray(new String[set.size()]);
            try {
                typeInfo = new FeatureTypeInfo(typeInfo.getFeatureTypeName(), DataUtilities.createSubType(typeInfo.getSchema(), requestedNames), typeInfo.getFIDMapper());
            }
            catch (SchemaException e1) {
                throw new DataSourceException("Could not create subtype", e1);
            }
        } else {
            throw new DataSourceException(typeName + " does not contain requested properties:" + query);
        }
        AttributeType[] attrTypes = null;
        try {
            attrTypes = this.getAttributeTypes(typeName, propertyNames);
        }
        catch (SchemaException schemaException) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(propertyNames) + ", " + "FeatureType: " + featureType, schemaException);
        }
        String sqlQuery = this.constructQuery(query, attrTypes);
        QueryData queryData = this.executeQuery(typeInfo, typeName, sqlQuery, trans, false);
        try {
            schema = FeatureTypeFactory.newFeatureType(attrTypes, typeName, this.getNameSpace());
        }
        catch (FactoryConfigurationError e) {
            throw new DataSourceException("Schema Factory Error when creating schema for FeatureReader", e);
        }
        catch (SchemaException e) {
            throw new DataSourceException("Schema Error when creating schema for FeatureReader", e);
        }
        FeatureReader reader = this.createFeatureReader(schema, postFilter, queryData);
        if (requestedNames.length < propertyNames.length) {
            try {
                FeatureType requestType = DataUtilities.createSubType(schema, requestedNames);
                reader = new ReTypeFeatureReader(reader, requestType);
            }
            catch (SchemaException schemaException) {
                throw new DataSourceException("Could not handle query", schemaException);
            }
        }
        return reader;
    }

    private String constructQuery(Query query, AttributeType[] attrTypes) throws IOException, DataSourceException {
        String sqlQuery;
        String typeName = query.getTypeName();
        SQLBuilder sqlBuilder = this.getSqlBuilder(query.getTypeName());
        Filter preFilter = sqlBuilder.getPreQueryFilter(query.getFilter());
        Filter postFilter = sqlBuilder.getPostQueryFilter(query.getFilter());
        FIDMapper mapper = this.getFIDMapper(typeName);
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        boolean useMax = postFilter == null;
        try {
            LOGGER.fine("calling sql builder with filter " + preFilter);
            if (query.getFilter() == Filter.ALL) {
                StringBuffer buf = new StringBuffer("SELECT ");
                sqlBuilder.sqlColumns(buf, mapper, attrTypes);
                sqlBuilder.sqlFrom(buf, typeName);
                buf.append(" WHERE '1' = '0'");
                sqlQuery = buf.toString();
            } else {
                sqlQuery = sqlBuilder.buildSQLQuery(typeName, mapper, attrTypes, preFilter);
            }
            LOGGER.fine("sql is " + sqlQuery);
        }
        catch (SQLEncoderException e) {
            throw new DataSourceException("Error building SQL Query", e);
        }
        return sqlQuery;
    }

    protected FeatureReader createFeatureReader(FeatureType schema, Filter postFilter, QueryData queryData) throws IOException {
        FeatureReader fReader = this.getJDBCFeatureReader(queryData);
        if (postFilter != null && postFilter != Filter.ALL) {
            fReader = new FilteringFeatureReader(fReader, postFilter);
        }
        return fReader;
    }

    protected JDBCFeatureReader getJDBCFeatureReader(QueryData queryData) throws IOException {
        return new JDBCFeatureReader(queryData);
    }

    protected AttributeIO getAttributeIO(AttributeType type) {
        if (this.basicAttributeIO == null) {
            this.basicAttributeIO = new BasicAttributeIO();
        }
        return this.basicAttributeIO;
    }

    protected abstract AttributeIO getGeometryAttributeIO(AttributeType var1, QueryData var2) throws IOException;

    protected QueryData executeQuery(FeatureTypeInfo featureTypeInfo, String tableName, String sqlQuery, Transaction transaction, boolean forWrite) throws IOException {
        LOGGER.fine("About to execute query: " + sqlQuery);
        Connection conn = null;
        Statement statement = null;
        ResultSet rs = null;
        try {
            conn = this.getConnection(transaction);
            if (!forWrite) {
                conn.setAutoCommit(false);
            }
            statement = conn.createStatement(this.getResultSetType(forWrite), this.getConcurrency(forWrite));
            statement.setFetchSize(200);
            rs = statement.executeQuery(sqlQuery);
            return new QueryData(featureTypeInfo, this, conn, statement, rs, transaction);
        }
        catch (SQLException e) {
            String msg = "Error Performing SQL query: " + sqlQuery;
            LOGGER.log(Level.SEVERE, msg, e);
            JDBCUtils.close(rs);
            JDBCUtils.close(statement);
            JDBCUtils.close(conn, transaction, e);
            throw new DataSourceException(msg, e);
        }
    }

    protected int getResultSetType(boolean forWrite) {
        return 1003;
    }

    protected int getConcurrency(boolean forWrite) {
        if (forWrite) {
            return 1008;
        }
        return 1007;
    }

    public SQLBuilder getSqlBuilder(String typeName) throws IOException {
        SQLEncoder encoder = new SQLEncoder();
        encoder.setFIDMapper(this.getFIDMapper(typeName));
        return new DefaultSQLBuilder();
    }

    protected final Connection getConnection(Transaction transaction) throws IOException {
        if (transaction != Transaction.AUTO_COMMIT) {
            JDBCTransactionState state = (JDBCTransactionState)transaction.getState(this.connectionPool);
            if (state == null) {
                state = new JDBCTransactionState(this.connectionPool);
                transaction.putState(this.connectionPool, state);
            }
            return state.getConnection();
        }
        try {
            return this.connectionPool.getConnection();
        }
        catch (SQLException sqle) {
            throw new DataSourceException("Connection failed:" + sqle, sqle);
        }
    }

    protected boolean allowTable(String tablename) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FIDMapper buildFIDMapper(String typeName, FIDMapperFactory factory) throws IOException {
        Connection conn = null;
        try {
            FIDMapper mapper;
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            FIDMapper fIDMapper = mapper = factory.getMapper(null, null, typeName, conn);
            return fIDMapper;
        }
        finally {
            JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected FeatureType buildSchema(String typeName, FIDMapper mapper) throws IOException {
        FeatureType featureType;
        int NAME_COLUMN = 4;
        int TYPE_NAME = 6;
        Connection conn = null;
        ResultSet tableInfo = null;
        try {
            conn = this.getConnection(Transaction.AUTO_COMMIT);
            DatabaseMetaData dbMetaData = conn.getMetaData();
            ArrayList<AttributeType> attributeTypes = new ArrayList<AttributeType>();
            tableInfo = dbMetaData.getColumns(null, null, typeName, "%");
            boolean tableInfoFound = false;
            while (tableInfo.next()) {
                tableInfoFound = true;
                try {
                    AttributeType attributeType;
                    String columnName = tableInfo.getString(4);
                    if (!mapper.returnFIDColumnsAsAttributes()) {
                        boolean isPresent = false;
                        for (int i = 0; i < mapper.getColumnCount(); ++i) {
                            if (!columnName.equalsIgnoreCase(mapper.getColumnName(i))) continue;
                            isPresent = true;
                            break;
                        }
                        if (isPresent) continue;
                    }
                    if ((attributeType = this.buildAttributeType(tableInfo)) != null) {
                        attributeTypes.add(attributeType);
                        continue;
                    }
                    LOGGER.finest("Unknown SQL Type: " + tableInfo.getString(6));
                }
                catch (DataSourceException dse) {
                    String msg = "Error building attribute type. The column will be ignored";
                    LOGGER.log(Level.WARNING, msg, dse);
                }
            }
            if (!tableInfoFound) {
                throw new SchemaNotFoundException(typeName);
            }
            AttributeType[] types = attributeTypes.toArray(new AttributeType[0]);
            featureType = FeatureTypeFactory.newFeatureType(types, typeName, this.getNameSpace());
        }
        catch (SQLException sqlException) {
            try {
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                conn = null;
                throw new DataSourceException("SQL Error building FeatureType for " + typeName + " " + sqlException.getMessage(), sqlException);
                catch (FactoryConfigurationError e) {
                    throw new DataSourceException("Error creating FeatureType " + typeName, e);
                }
                catch (SchemaException e) {
                    throw new DataSourceException("Error creating FeatureType for " + typeName, e);
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(tableInfo);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                throw throwable;
            }
        }
        JDBCUtils.close(tableInfo);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return featureType;
    }

    protected AttributeType buildAttributeType(ResultSet rs) throws IOException {
        try {
            int COLUMN_NAME = 4;
            int DATA_TYPE = 5;
            String columnName = rs.getString(4);
            int dataType = rs.getInt(5);
            Class type = (Class)TYPE_MAPPINGS.get(new Integer(dataType));
            if (type == null) {
                return null;
            }
            return AttributeTypeFactory.newAttributeType(columnName, type);
        }
        catch (SQLException e) {
            throw new IOException("SQL exception occurred: " + e.getMessage());
        }
    }

    protected int determineSRID(String tableName, String geometryColumnName) throws IOException {
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String determineFidColumnName(String typeName) throws IOException {
        Connection conn;
        ResultSet rs;
        String fidColumnName;
        block4: {
            int NAME_COLUMN = 4;
            fidColumnName = null;
            rs = null;
            conn = null;
            try {
                conn = this.getConnection(Transaction.AUTO_COMMIT);
                DatabaseMetaData dbMetadata = conn.getMetaData();
                rs = dbMetadata.getPrimaryKeys(null, null, typeName);
                if (!rs.next()) break block4;
                fidColumnName = rs.getString(4);
            }
            catch (SQLException sqlException) {
                try {
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, sqlException);
                    conn = null;
                    LOGGER.warning("Could not find the primary key - using the default");
                }
                catch (Throwable throwable) {
                    JDBCUtils.close(rs);
                    JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
                    throw throwable;
                }
                JDBCUtils.close(rs);
                JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
            }
        }
        JDBCUtils.close(rs);
        JDBCUtils.close(conn, Transaction.AUTO_COMMIT, null);
        return fidColumnName;
    }

    public URI getNameSpace() {
        try {
            if (this.config.getNamespace() != null) {
                return new URI(this.config.getNamespace());
            }
        }
        catch (URISyntaxException e) {
            LOGGER.warning("Could not use namespace " + this.config.getNamespace() + " - " + e.getMessage());
            return null;
        }
        return null;
    }

    public FeatureWriter getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        return this.getFeatureWriter(typeName, Filter.NONE, transaction);
    }

    public FeatureWriter getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        FeatureWriter writer = this.getFeatureWriter(typeName, Filter.ALL, transaction);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public FeatureWriter getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        String sqlQuery;
        if (filter == null) {
            throw new NullPointerException("getFeatureReader requires Filter: did you mean Filter.NONE?");
        }
        if (transaction == null) {
            throw new NullPointerException("getFeatureReader requires Transaction: did you mean Transaction.AUTO_COMMIT");
        }
        FeatureType featureType = this.getSchema(typeName);
        FeatureTypeInfo info = this.typeHandler.getFeatureTypeInfo(typeName);
        LOGGER.fine("getting feature writer for " + typeName + ": " + info);
        SQLBuilder sqlBuilder = this.getSqlBuilder(typeName);
        Filter preFilter = sqlBuilder.getPreQueryFilter(filter);
        Filter postFilter = sqlBuilder.getPostQueryFilter(filter);
        DefaultQuery query = new DefaultQuery(typeName, filter);
        try {
            sqlQuery = this.constructQuery(query, this.getAttributeTypes(typeName, this.propertyNames(query)));
        }
        catch (SchemaException e) {
            throw new DataSourceException("Some Attribute Names were specified that do not exist in the FeatureType " + typeName + ". " + "Requested names: " + Arrays.asList(query.getPropertyNames()) + ", " + "FeatureType: " + featureType, e);
        }
        QueryData queryData = this.executeQuery(this.typeHandler.getFeatureTypeInfo(typeName), typeName, sqlQuery, transaction, true);
        FeatureReader reader = this.createFeatureReader(info.getSchema(), postFilter, queryData);
        FeatureWriter writer = this.createFeatureWriter(reader, queryData);
        if (this.getLockingManager() != null && this.getLockingManager() instanceof InProcessLockingManager) {
            InProcessLockingManager inProcess = (InProcessLockingManager)this.getLockingManager();
            writer = inProcess.checkedWriter(writer, transaction);
        }
        if (postFilter != null && postFilter != Filter.NONE) {
            writer = new FilteringFeatureWriter(writer, postFilter);
        }
        return writer;
    }

    protected JDBCFeatureWriter createFeatureWriter(FeatureReader reader, QueryData queryData) throws IOException {
        LOGGER.fine("returning jdbc feature writer");
        return new JDBCFeatureWriter(reader, queryData);
    }

    private String[] propertyNames(Query query) throws IOException {
        String[] names = query.getPropertyNames();
        if (names == null || query.retrieveAllProperties()) {
            String typeName = query.getTypeName();
            FeatureType schema = this.getSchema(typeName);
            names = new String[schema.getAttributeCount()];
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                names[i] = schema.getAttributeType(i).getName();
            }
        }
        return names;
    }

    protected final AttributeType[] getAttributeTypes(String typeName, String[] propertyNames) throws IOException, SchemaException {
        FeatureType schema = this.getSchema(typeName);
        AttributeType[] types = new AttributeType[propertyNames.length];
        for (int i = 0; i < propertyNames.length; ++i) {
            types[i] = schema.getAttributeType(propertyNames[i]);
            if (types[i] != null) continue;
            throw new SchemaException(typeName + " does not contain requested " + propertyNames[i] + " attribute");
        }
        return types;
    }

    public LockingManager getLockingManager() {
        return this.lockingManager;
    }

    public void setFIDMapper(String featureTypeName, FIDMapper fidMapper) {
        this.typeHandler.setFIDMapper(featureTypeName, fidMapper);
    }

    public FIDMapperFactory getFIDMapperFactory() {
        return this.typeHandler.getFIDMapperFactory();
    }

    public void setFIDMapperFactory(FIDMapperFactory fmFactory) throws UnsupportedOperationException {
        this.typeHandler.setFIDMapperFactory(fmFactory);
    }

    public boolean allSameOrder(String[] requestedNames, FeatureType ft) {
        if (requestedNames.length != ft.getAttributeCount()) {
            return false;
        }
        for (int t = 0; t < requestedNames.length; ++t) {
            if (requestedNames[t].equals(ft.getAttributeType(t).getName())) continue;
            return false;
        }
        return true;
    }

    static {
        TYPE_MAPPINGS.put(new Integer(12), String.class);
        TYPE_MAPPINGS.put(new Integer(1), String.class);
        TYPE_MAPPINGS.put(new Integer(-1), String.class);
        TYPE_MAPPINGS.put(new Integer(-7), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(16), Boolean.class);
        TYPE_MAPPINGS.put(new Integer(-6), Short.class);
        TYPE_MAPPINGS.put(new Integer(5), Short.class);
        TYPE_MAPPINGS.put(new Integer(4), Integer.class);
        TYPE_MAPPINGS.put(new Integer(-5), Long.class);
        TYPE_MAPPINGS.put(new Integer(7), Float.class);
        TYPE_MAPPINGS.put(new Integer(6), Double.class);
        TYPE_MAPPINGS.put(new Integer(8), Double.class);
        TYPE_MAPPINGS.put(new Integer(3), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(2), BigDecimal.class);
        TYPE_MAPPINGS.put(new Integer(91), Date.class);
        TYPE_MAPPINGS.put(new Integer(92), Time.class);
        TYPE_MAPPINGS.put(new Integer(93), Timestamp.class);
    }
}

