/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.jdbc.fidmapper;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.sql.Connection;
import java.sql.Statement;
import org.geotools.data.DataSourceException;
import org.geotools.data.jdbc.fidmapper.AbstractFIDMapper;
import org.geotools.feature.Feature;

public class MultiColumnFIDMapper
extends AbstractFIDMapper {
    private static final long serialVersionUID = 1L;
    private static final String UTF8 = "UTF-8";
    private boolean[] autoIncrement;
    private int[] colTypes;
    private String[] colNames;
    private int[] colDecimalDigits;
    private int[] colSizes;

    public MultiColumnFIDMapper(String[] colNames, int[] colTypes, int[] colSizes, int[] colDecimalDigits, boolean[] autoIncrement) {
        if (colNames == null || colTypes == null || autoIncrement == null) {
            throw new IllegalArgumentException("Column description arrays must be not null");
        }
        if (colNames.length == 0) {
            throw new IllegalArgumentException("Column description arrays must be not empty");
        }
        if (colNames.length != colTypes.length || colNames.length != autoIncrement.length) {
            throw new IllegalArgumentException("Column description arrays must have the same size");
        }
        this.colNames = colNames;
        this.colTypes = colTypes;
        this.colSizes = colSizes;
        this.colDecimalDigits = colDecimalDigits;
        this.autoIncrement = autoIncrement;
    }

    public void initSupportStructures() {
    }

    public String getID(Object[] attributes) {
        StringBuffer sb = new StringBuffer();
        try {
            for (int i = 0; i < attributes.length; ++i) {
                sb.append(URLEncoder.encode(attributes[i].toString(), UTF8));
                if (i >= attributes.length - 1) continue;
                sb.append("&");
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return sb.toString();
    }

    public Object[] getPKAttributes(String FID) throws IOException {
        Object[] attributes = FID.split("&");
        if (attributes.length != this.colNames.length) {
            throw new DataSourceException("The FID is not compatible with MultiColumnFIDMapper, was expecting " + this.colNames.length + " URL-encoded columns and got " + attributes.length + " columns");
        }
        for (int i = 0; i < attributes.length; ++i) {
            attributes[i] = URLDecoder.decode((String)attributes[i], UTF8);
        }
        return attributes;
    }

    public String createID(Connection conn, Feature feature, Statement statement) throws IOException {
        Object[] attValues = new String[this.colNames.length];
        for (int i = 0; i < this.colNames.length; ++i) {
            attValues[i] = feature.getAttribute(this.colNames[i]).toString();
        }
        return this.getID(attValues);
    }

    public boolean returnFIDColumnsAsAttributes() {
        return true;
    }

    public int getColumnCount() {
        return this.colNames.length;
    }

    public String getColumnName(int colIndex) {
        return this.colNames[colIndex];
    }

    public int getColumnType(int colIndex) {
        return this.colTypes[colIndex];
    }

    public int getColumnSize(int colIndex) {
        return this.colSizes[colIndex];
    }

    public int getColumnDecimalDigits(int colIndex) {
        return this.colDecimalDigits[colIndex];
    }

    public boolean isAutoIncrement(int colIndex) {
        return this.autoIncrement[colIndex];
    }
}

