/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.geotools.data.DataSourceException;
import org.geotools.data.FeatureReader;
import org.geotools.feature.AbstractFeatureCollection;
import org.geotools.feature.CollectionEvent;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.DefaultFeatureType;
import org.geotools.feature.Feature;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.FeatureType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.type.FeatureAttributeType;
import org.geotools.xml.gml.GMLSchema;

public class DefaultFeatureCollection
extends AbstractFeatureCollection {
    private SortedMap contents = new TreeMap();
    private List listeners = new ArrayList(2);
    private Envelope bounds = null;
    private String id;
    private FeatureType featureType;
    private FeatureType childType;
    private FeatureCollection parent;

    protected DefaultFeatureCollection(String id, FeatureType featureType) {
        this.id = id;
        if (featureType == null) {
            LinkedList<FeatureAttributeType> ats = new LinkedList<FeatureAttributeType>();
            ats.add(new FeatureAttributeType("_Feature", new DefaultFeatureType("AbstractFeatureType", GMLSchema.NAMESPACE, new LinkedList(), new LinkedList(), null), false));
            featureType = new DefaultFeatureType("AbstractFeatureColletionType", GMLSchema.NAMESPACE, ats, new LinkedList(), null);
        }
        this.featureType = featureType;
        this.childType = null;
    }

    public FeatureType getSchema() {
        if (this.childType == null) {
            new DefaultFeatureType("AbstractFeatureType", GMLSchema.NAMESPACE, new LinkedList(), new LinkedList(), null);
        }
        return this.childType;
    }

    public Envelope getBounds() {
        if (this.bounds == null) {
            this.bounds = new Envelope();
            Iterator i = this.contents.values().iterator();
            while (i.hasNext()) {
                Envelope geomBounds = ((Feature)i.next()).getBounds();
                if (geomBounds.isNull()) continue;
                this.bounds.expandToInclude(geomBounds);
            }
        }
        return this.bounds;
    }

    public void addListener(CollectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(CollectionListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireChange(Feature[] features, int type) {
        this.bounds = null;
        CollectionEvent cEvent = new CollectionEvent(this, features, type);
        int ii = this.listeners.size();
        for (int i = 0; i < ii; ++i) {
            ((CollectionListener)this.listeners.get(i)).collectionChanged(cEvent);
        }
    }

    protected void fireChange(Feature feature, int type) {
        this.fireChange(new Feature[]{feature}, type);
    }

    protected void fireChange(Collection coll, int type) {
        Feature[] features = new Feature[coll.size()];
        features = coll.toArray(features);
        this.fireChange(features, type);
    }

    public boolean add(Object o) {
        return this.add((Feature)o, true);
    }

    protected boolean add(Feature feature, boolean fire) {
        if (feature == null) {
            return false;
        }
        String ID2 = feature.getID();
        if (ID2 == null) {
            return false;
        }
        if (this.contents.containsKey(ID2)) {
            return false;
        }
        feature.setParent(this);
        this.contents.put(ID2, feature);
        if (fire) {
            this.fireChange(feature, 0);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<Feature> featuresAdded = new ArrayList<Feature>(collection.size());
            while (iterator.hasNext()) {
                Feature f = (Feature)iterator.next();
                boolean added = this.add(f, false);
                changed |= added;
                if (!added) continue;
                featuresAdded.add(f);
            }
            if (changed) {
                this.fireChange(featuresAdded, 0);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public void clear() {
        if (this.contents.isEmpty()) {
            return;
        }
        Feature[] oldFeatures = new Feature[this.contents.size()];
        oldFeatures = this.contents.values().toArray(oldFeatures);
        this.contents.clear();
        this.fireChange(oldFeatures, 1);
    }

    public boolean contains(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature feature = (Feature)o;
        String ID2 = feature.getID();
        return this.contents.containsKey(ID2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection collection) {
        Iterator iterator = collection.iterator();
        try {
            while (iterator.hasNext()) {
                Feature feature = (Feature)iterator.next();
                if (this.contents.containsKey(feature.getID())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public Iterator iterator() {
        final Iterator iterator = this.contents.values().iterator();
        return new Iterator(){
            Feature currFeature = null;

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Object next() {
                this.currFeature = (Feature)iterator.next();
                return this.currFeature;
            }

            public void remove() {
                iterator.remove();
                DefaultFeatureCollection.this.fireChange(this.currFeature, 1);
            }
        };
    }

    public FeatureIterator features() {
        return new FeatureIterator(this);
    }

    public boolean remove(Object o) {
        if (!(o instanceof Feature)) {
            return false;
        }
        Feature f = (Feature)o;
        boolean changed = this.contents.values().remove(f.getID());
        if (changed) {
            this.fireChange(f, 1);
        }
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAll(Collection collection) {
        boolean changed = false;
        Iterator iterator = collection.iterator();
        try {
            ArrayList<Feature> removedFeatures = new ArrayList<Feature>(collection.size());
            while (iterator.hasNext()) {
                Feature f = (Feature)iterator.next();
                boolean removed = this.contents.values().remove(f);
                if (!removed) continue;
                changed = true;
                removedFeatures.add(f);
            }
            if (changed) {
                this.fireChange(removedFeatures, 1);
            }
            boolean bl = changed;
            return bl;
        }
        finally {
            if (collection instanceof FeatureCollection) {
                ((FeatureCollection)collection).close(iterator);
            }
        }
    }

    public boolean retainAll(Collection collection) {
        ArrayList<Feature> removedFeatures = new ArrayList<Feature>(this.contents.size() - collection.size());
        boolean modified = false;
        Iterator it = this.contents.values().iterator();
        while (it.hasNext()) {
            Feature f = (Feature)it.next();
            if (collection.contains(f)) continue;
            it.remove();
            modified = true;
            removedFeatures.add(f);
        }
        if (modified) {
            this.fireChange(removedFeatures, 1);
        }
        return modified;
    }

    public int size() {
        return this.contents.size();
    }

    public Object[] toArray() {
        return this.contents.values().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.contents.values().toArray(a);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public FeatureCollection getParent() {
        return this.parent;
    }

    public void setParent(FeatureCollection collection) {
        this.parent = collection;
    }

    public String getID() {
        return this.id;
    }

    public Object[] getAttributes(Object[] attributes) {
        return this.toArray(attributes);
    }

    public Object getAttribute(String xPath) {
        if (xPath.indexOf(this.featureType.getTypeName()) > -1) {
            if (xPath.endsWith("]")) {
                return this.contents.values();
            }
            return this.contents.values();
        }
        return null;
    }

    public Object getAttribute(int index) {
        if (index == 0) {
            return this.contents.values();
        }
        return null;
    }

    public void setAttribute(int position, Object val) throws IllegalAttributeException, ArrayIndexOutOfBoundsException {
        if (position == 0 && val instanceof List) {
            List nw = (List)val;
            if (!this.isFeatures(nw)) {
                return;
            }
            this.contents.clear();
            Iterator i = nw.iterator();
            while (i.hasNext()) {
                Feature feature = (Feature)i.next();
                feature.setParent(this);
                this.contents.put(feature.getID(), feature);
            }
            this.fireChange(nw, 0);
        }
    }

    public int getNumberOfAttributes() {
        return this.contents.size();
    }

    public void setAttribute(String xPath, Object attribute) throws IllegalAttributeException {
        if (xPath.indexOf(this.featureType.getTypeName()) > -1 && !xPath.endsWith("]")) {
            this.setAttribute(0, attribute);
        }
    }

    public Geometry getDefaultGeometry() {
        return null;
    }

    public void setDefaultGeometry(Geometry geometry) throws IllegalAttributeException {
        throw new IllegalAttributeException("Not Supported");
    }

    public void close(FeatureIterator close) {
    }

    public void close(Iterator close) {
    }

    public FeatureReader reader() throws IOException {
        final FeatureIterator iterator = this.features();
        return new FeatureReader(){

            public FeatureType getFeatureType() {
                return DefaultFeatureCollection.this.getSchema();
            }

            public Feature next() throws IOException, IllegalAttributeException, NoSuchElementException {
                return iterator.next();
            }

            public boolean hasNext() throws IOException {
                return iterator.hasNext();
            }

            public void close() throws IOException {
                DefaultFeatureCollection.this.close(iterator);
            }
        };
    }

    public int getCount() throws IOException {
        return this.contents.size();
    }

    public FeatureCollection collection() throws IOException {
        DefaultFeatureCollection copy = new DefaultFeatureCollection(null, this.featureType);
        ArrayList<Feature> list = new ArrayList<Feature>(this.contents.size());
        FeatureIterator iterator = this.features();
        while (iterator.hasNext()) {
            Feature duplicate;
            Feature feature = iterator.next();
            try {
                duplicate = feature.getFeatureType().duplicate(feature);
            }
            catch (IllegalAttributeException e) {
                throw new DataSourceException("Unable to copy " + feature.getID(), e);
            }
            list.add(duplicate);
        }
        copy.addAll(list);
        return copy;
    }

    public Set fids() {
        return Collections.unmodifiableSet(this.contents.keySet());
    }
}

