/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.util.Arrays;
import org.geotools.factory.FactoryConfigurationError;
import org.geotools.factory.FactoryFinder;
import org.geotools.feature.AttributeType;
import org.geotools.feature.FeatureType;
import org.geotools.feature.FeatureTypeBuilder;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.SchemaException;
import org.geotools.xml.gml.GMLSchema;

public abstract class FeatureTypeFactory
extends FeatureTypeBuilder {
    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, AttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (defaultGeometry != null) {
            factory.setDefaultGeometry((GeometryAttributeType)defaultGeometry);
        }
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract, FeatureType[] superTypes, GeometryAttributeType defaultGeometry) throws FactoryConfigurationError, SchemaException {
        FeatureTypeFactory factory = FeatureTypeFactory.newInstance(name);
        factory.addTypes(types);
        factory.setNamespace(ns);
        factory.setAbstract(isAbstract);
        if (superTypes != null) {
            factory.setSuperTypes(Arrays.asList(superTypes));
        }
        if (defaultGeometry != null) {
            factory.setDefaultGeometry(defaultGeometry);
        }
        return factory.getFeatureType();
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns, boolean isAbstract) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name, URI ns) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, ns, false);
    }

    public static FeatureType newFeatureType(AttributeType[] types, String name) throws FactoryConfigurationError, SchemaException {
        return FeatureTypeFactory.newFeatureType(types, name, GMLSchema.NAMESPACE, false);
    }

    public static FeatureTypeFactory newInstance(String name) throws FactoryConfigurationError {
        FeatureTypeFactory factory = (FeatureTypeFactory)FactoryFinder.findFactory("org.geotools.feature.FeatureTypeFactory", "org.geotools.feature.DefaultFeatureTypeFactory");
        factory.setName(name);
        return factory;
    }

    public static FeatureTypeFactory createTemplate(FeatureType original) throws FactoryConfigurationError {
        FeatureTypeFactory builder = FeatureTypeFactory.newInstance(original.getTypeName());
        builder.importType(original);
        builder.setNamespace(original.getNamespace());
        builder.setDefaultGeometry(original.getDefaultGeometry());
        FeatureType[] ancestors = original.getAncestors();
        if (ancestors != null) {
            builder.setSuperTypes(Arrays.asList(ancestors));
        }
        return builder;
    }

    public String toString() {
        String types = "";
        int ii = this.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            types = types + this.get(i);
            if (i >= ii) continue;
            types = types + " , ";
        }
        return "FeatureTypeFactory(" + this.getClass().getName() + ") [ " + types + " ]";
    }
}

