/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature.type;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import org.geotools.feature.DefaultAttributeType;
import org.geotools.feature.GeometryAttributeType;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.type.CSGeometryFactory;
import org.geotools.filter.Filter;
import org.geotools.referencing.crs.DefaultGeocentricCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeometricAttributeType
extends DefaultAttributeType
implements GeometryAttributeType {
    protected CoordinateReferenceSystem coordinateSystem;
    protected GeometryFactory geometryFactory;
    private Filter filter;

    public GeometricAttributeType(String name, Class type, boolean nillable, int min, int max, Object defaultValue, CoordinateReferenceSystem cs, Filter filter) {
        super(name, type, nillable, min, max, defaultValue);
        this.filter = filter;
        this.coordinateSystem = cs;
        this.geometryFactory = cs == null ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(cs);
    }

    public GeometricAttributeType(String name, Class type, boolean nillable, Object defaultValue, CoordinateReferenceSystem cs, Filter filter) {
        this(name, type, nillable, 1, 1, defaultValue, cs, filter);
    }

    public GeometricAttributeType(GeometricAttributeType copy, CoordinateReferenceSystem override) {
        super(copy);
        this.coordinateSystem = copy.getCoordinateSystem();
        if (override != null) {
            this.coordinateSystem = override;
        }
        if (this.coordinateSystem == null) {
            this.coordinateSystem = DefaultGeocentricCRS.CARTESIAN;
        }
        this.geometryFactory = this.coordinateSystem == DefaultGeocentricCRS.CARTESIAN ? CSGeometryFactory.DEFAULT : new CSGeometryFactory(this.coordinateSystem);
    }

    public CoordinateReferenceSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public GeometryFactory getGeometryFactory() {
        return this.geometryFactory;
    }

    public Object parse(Object value) throws IllegalArgumentException {
        if (value == null) {
            return value;
        }
        if (value instanceof Geometry) {
            return value;
        }
        if (value instanceof String) {
            String wkt = (String)value;
            WKTReader reader = new WKTReader();
            try {
                return reader.read(wkt);
            }
            catch (ParseException pe) {
                throw new IllegalArgumentException("Could not parse the string: " + wkt + " to well known text");
            }
        }
        throw new IllegalArgumentException("AttributeGT.Geometric cannot parse " + value);
    }

    public Object duplicate(Object o) throws IllegalAttributeException {
        if (o == null) {
            return o;
        }
        if (o instanceof Geometry) {
            return ((Geometry)o).clone();
        }
        throw new IllegalAttributeException("Cannot duplicate " + o.getClass().getName());
    }

    public Filter getRestriction() {
        return this.filter;
    }
}

