/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import com.vividsolutions.jts.geom.Geometry;
import java.util.Collections;
import java.util.Map;
import org.geotools.algorithms.RobustGeometryProperties;
import org.geotools.feature.Feature;
import org.geotools.filter.Expression;
import org.geotools.filter.FilterVisitor;
import org.geotools.filter.FunctionExpression;

public class AreaFunction
implements FunctionExpression {
    private Expression geom;
    private Expression[] args;
    private RobustGeometryProperties calc = new RobustGeometryProperties();

    public short getType() {
        return 114;
    }

    public Object getValue(Feature feature) {
        Geometry g = (Geometry)this.geom.getValue(feature);
        return new Double(this.calc.getArea(g));
    }

    public int getArgCount() {
        return 1;
    }

    public String getName() {
        return "Area";
    }

    public void setArgs(Expression[] args) {
        this.geom = args[0];
        this.args = args;
    }

    public void accept(FilterVisitor visitor) {
        visitor.visit(this);
    }

    public Expression[] getArgs() {
        return this.args;
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }
}

