/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.jai;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RasterFormatException;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import javax.vecmath.MismatchedSizeException;
import org.geotools.image.jai.CombineTransform;
import org.geotools.resources.XArray;
import org.geotools.resources.image.ImageUtilities;

public class Combine
extends PointOpImage {
    final double[][] matrix;
    final int[][] sources;
    final int[][] bands;
    final int numSamples;
    protected final CombineTransform transform;

    public Combine(Vector images, double[][] matrix, CombineTransform transform, RenderingHints hints) throws MismatchedSizeException {
        super(images, ImageUtilities.createIntersection((ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT), images), (Map)hints, false);
        matrix = (double[][])matrix.clone();
        this.matrix = matrix;
        this.sources = new int[matrix.length][];
        this.bands = new int[matrix.length][];
        this.transform = transform;
        int numSamples = 0;
        int i = this.getNumSources();
        while (--i >= 0) {
            numSamples += this.getSourceImage(i).getNumBands();
        }
        this.numSamples = numSamples;
        boolean isSeparable = transform == null || transform.isSeparable();
        for (int j = 0; j < matrix.length; ++j) {
            double[] row = matrix[j];
            if (row.length != numSamples + 1) {
                throw new MismatchedSizeException();
            }
            int source = -1;
            int band = -1;
            int numBands = 0;
            int count = 0;
            double[] copy = new double[row.length];
            int[] sources = new int[row.length - 1];
            int[] bands = new int[row.length - 1];
            for (int i2 = 0; i2 < sources.length; ++i2) {
                if (++band >= numBands) {
                    band = 0;
                    numBands = this.getSourceImage(++source).getNumBands();
                }
                if (row[i2] == 0.0 && isSeparable) continue;
                copy[count] = row[i2];
                sources[count] = source;
                bands[count] = band;
                ++count;
            }
            copy[count] = row[row.length - 1];
            this.matrix[j] = XArray.resize(copy, count + 1);
            this.sources[j] = XArray.resize(sources, count);
            this.bands[j] = XArray.resize(bands, count);
        }
        if (this.getNumBands() != matrix.length) {
            throw new UnsupportedOperationException("Automatic derivation of SampleModel not yet implemented.");
        }
        this.permitInPlaceOperation();
    }

    public void computeRect(PlanarImage[] images, WritableRaster dest, Rectangle destRect) {
        RectIter[] iters = new RectIter[images.length];
        RectIter[] iterRef = new RectIter[this.numSamples];
        double[] samples = null;
        for (int i = 0; i < iters.length; ++i) {
            iters[i] = RectIterFactory.create((RenderedImage)images[i], (Rectangle)this.mapDestRect(destRect, i));
        }
        WritableRectIter iTarget = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        int band = 0;
        iTarget.startBands();
        boolean finished = iTarget.finishedBands();
        while (!finished) {
            int i;
            double[] row = this.matrix[band];
            int[] bands = this.bands[band];
            int[] sources = this.sources[band];
            int numSamples = sources.length;
            if (numSamples > this.numSamples || numSamples > bands.length || numSamples >= row.length) {
                throw new AssertionError(numSamples);
            }
            for (i = 0; i < numSamples; ++i) {
                iterRef[i] = iters[sources[i]];
            }
            if (samples == null || samples.length != numSamples) {
                samples = new double[numSamples];
            }
            iTarget.startLines();
            finished = iTarget.finishedLines();
            for (i = 0; i < iters.length; ++i) {
                iters[i].startLines();
                if (iters[i].finishedLines() == finished) continue;
                throw new RasterFormatException("Missing lines");
            }
            while (!finished) {
                iTarget.startPixels();
                finished = iTarget.finishedPixels();
                for (i = 0; i < iters.length; ++i) {
                    iters[i].startPixels();
                    if (iters[i].finishedPixels() == finished) continue;
                    throw new RasterFormatException("Missing pixels");
                }
                while (!finished) {
                    int i2;
                    for (i = 0; i < numSamples; ++i) {
                        samples[i] = iterRef[i].getSampleDouble(bands[i]);
                    }
                    if (this.transform != null) {
                        this.transform.transformSamples(samples);
                    }
                    double value = row[numSamples];
                    for (i2 = 0; i2 < numSamples; ++i2) {
                        value += row[i2] * samples[i2];
                    }
                    iTarget.setSample(value);
                    finished = iTarget.nextPixelDone();
                    for (i2 = 0; i2 < iters.length; ++i2) {
                        if (iters[i2].nextPixelDone() == finished) continue;
                        throw new RasterFormatException("Missing pixels");
                    }
                }
                finished = iTarget.nextLineDone();
                for (i = 0; i < iters.length; ++i) {
                    if (iters[i].nextLineDone() == finished) continue;
                    throw new RasterFormatException("Missing lines");
                }
            }
            ++band;
            finished = iTarget.nextBandDone();
        }
    }

    static final class Dyadic
    extends Combine {
        private final double[] scales0;
        private final double[] scales1;
        private final double[] offsets;

        public Dyadic(Vector images, double[][] matrix, RenderingHints hints) throws MismatchedSizeException {
            super(images, matrix, null, hints);
            if (this.getNumSources() != 2) {
                throw new IllegalArgumentException();
            }
            int numBands = this.getNumBands();
            this.scales0 = new double[numBands];
            this.scales1 = new double[numBands];
            this.offsets = new double[numBands];
            for (int j = 0; j < numBands; ++j) {
                double[] row = this.matrix[j];
                int[] sources = this.sources[j];
                int[] bands = this.bands[j];
                block5: for (int i = 0; i < sources.length; ++i) {
                    double coeff = row[i];
                    int band = bands[i];
                    int source = sources[i];
                    if (band != j) {
                        throw new AssertionError(band);
                    }
                    switch (source) {
                        case 0: {
                            this.scales0[band] = coeff;
                            continue block5;
                        }
                        case 1: {
                            this.scales1[band] = coeff;
                            continue block5;
                        }
                        default: {
                            throw new AssertionError(source);
                        }
                    }
                }
                this.offsets[j] = row[sources.length];
            }
        }

        public void computeRect(PlanarImage[] images, WritableRaster dest, Rectangle destRect) {
            RectIter iSrc0 = RectIterFactory.create((RenderedImage)images[0], (Rectangle)this.mapDestRect(destRect, 0));
            RectIter iSrc1 = RectIterFactory.create((RenderedImage)images[1], (Rectangle)this.mapDestRect(destRect, 1));
            WritableRectIter iTarget = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
            int band = 0;
            iSrc0.startBands();
            iSrc1.startBands();
            iTarget.startBands();
            if (!(iTarget.finishedBands() || iSrc0.finishedBands() || iSrc1.finishedBands())) {
                double scale0 = this.scales0[Math.min(band, this.scales0.length - 1)];
                double scale1 = this.scales1[Math.min(band, this.scales1.length - 1)];
                double offset = this.offsets[Math.min(band, this.offsets.length - 1)];
                do {
                    iSrc0.startLines();
                    iSrc1.startLines();
                    iTarget.startLines();
                    if (!(iTarget.finishedLines() || iSrc0.finishedLines() || iSrc1.finishedLines())) {
                        do {
                            iSrc0.startPixels();
                            iSrc1.startPixels();
                            iTarget.startPixels();
                            if (iTarget.finishedPixels() || iSrc0.finishedPixels() || iSrc1.finishedPixels()) continue;
                            do {
                                iTarget.setSample(iSrc0.getSampleDouble() * scale0 + iSrc1.getSampleDouble() * scale1 + offset);
                            } while (!iSrc0.nextPixelDone() && !iSrc1.nextPixelDone() && !iTarget.nextPixelDone());
                        } while (!iSrc0.nextLineDone() && !iSrc1.nextLineDone() && !iTarget.nextLineDone());
                    }
                    ++band;
                } while (!iSrc0.nextBandDone() && !iSrc1.nextBandDone() && !iTarget.nextBandDone());
            }
        }
    }
}

