/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.measure;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.units.Converter;
import javax.units.NonSI;
import javax.units.SI;
import javax.units.Unit;
import org.geotools.measure.Angle;
import org.geotools.measure.AngleFormat;
import org.geotools.measure.Latitude;
import org.geotools.measure.Longitude;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.crs.DefaultTemporalCRS;
import org.geotools.resources.CRSUtilities;
import org.geotools.resources.cts.Resources;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.spatialschema.geometry.DirectPosition;
import org.opengis.spatialschema.geometry.MismatchedDimensionException;

public class CoordinateFormat
extends Format {
    private static final long serialVersionUID = -1334894996513164253L;
    private CoordinateReferenceSystem crs;
    private Format[] formats;
    private byte[] types;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private long[] epochs;
    private Converter[] toMillis;
    private final FieldPosition dummy = new FieldPosition(0);
    private final Locale locale;

    public CoordinateFormat() {
        this(Locale.getDefault());
    }

    public CoordinateFormat(Locale locale) {
        this(locale, DefaultGeographicCRS.WGS84);
    }

    public CoordinateFormat(Locale locale, CoordinateReferenceSystem crs) {
        this.locale = locale;
        this.setCoordinateReferenceSystem(crs);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        if (!CRSUtilities.equalsIgnoreMetadata(this.crs, crs)) {
            int i;
            CoordinateSystem cs = crs.getCoordinateSystem();
            Format numberFormat = null;
            Format angleFormat = null;
            Format dateFormat = null;
            if (this.formats != null) {
                i = this.formats.length;
                while (--i >= 0) {
                    Format format = this.formats[i];
                    if (format instanceof NumberFormat) {
                        numberFormat = format;
                        continue;
                    }
                    if (format instanceof AngleFormat) {
                        angleFormat = format;
                        continue;
                    }
                    if (!(format instanceof DateFormat)) continue;
                    dateFormat = format;
                }
            }
            this.epochs = null;
            this.toMillis = null;
            this.formats = new Format[cs.getDimension()];
            this.types = new byte[this.formats.length];
            for (i = 0; i < this.formats.length; ++i) {
                Unit unit = cs.getAxis(i).getUnit();
                if (NonSI.DEGREE_ANGLE.equals((Object)unit)) {
                    if (angleFormat == null) {
                        angleFormat = new AngleFormat("DD\ufffdMM.m'", this.locale);
                    }
                    this.formats[i] = angleFormat;
                    AxisDirection axis = cs.getAxis(i).getDirection().absolute();
                    if (AxisDirection.EAST.equals(axis)) {
                        this.types[i] = 1;
                        continue;
                    }
                    if (AxisDirection.NORTH.equals(axis)) {
                        this.types[i] = 2;
                        continue;
                    }
                    this.types[i] = 3;
                    continue;
                }
                if (SI.SECOND.isCompatible(unit)) {
                    Datum datum = CRSUtilities.getDatum(CRSUtilities.getSubCRS(crs, i, i + 1));
                    if (datum instanceof TemporalDatum) {
                        if (this.toMillis == null) {
                            this.toMillis = new Converter[this.formats.length];
                            this.epochs = new long[this.formats.length];
                        }
                        this.toMillis[i] = unit.getConverterTo(DefaultTemporalCRS.MILLISECOND);
                        this.epochs[i] = ((TemporalDatum)datum).getOrigin().getTime();
                        if (dateFormat == null) {
                            dateFormat = DateFormat.getDateInstance(2, this.locale);
                        }
                        this.formats[i] = dateFormat;
                        this.types[i] = 4;
                        continue;
                    }
                    this.types[i] = 5;
                }
                if (numberFormat == null) {
                    numberFormat = NumberFormat.getNumberInstance(this.locale);
                }
                this.formats[i] = numberFormat;
            }
        }
        this.crs = crs;
    }

    public void setNumberPattern(String pattern) {
        Format lastFormat = null;
        for (int i = 0; i < this.formats.length; ++i) {
            Format format = this.formats[i];
            if (format == lastFormat || !(format instanceof DecimalFormat)) continue;
            ((DecimalFormat)format).applyPattern(pattern);
            lastFormat = format;
        }
    }

    public void setAnglePattern(String pattern) {
        Format lastFormat = null;
        for (int i = 0; i < this.formats.length; ++i) {
            Format format = this.formats[i];
            if (format == lastFormat || !(format instanceof AngleFormat)) continue;
            ((AngleFormat)format).applyPattern(pattern);
            lastFormat = format;
        }
    }

    public void setDatePattern(String pattern) {
        Format lastFormat = null;
        for (int i = 0; i < this.formats.length; ++i) {
            Format format = this.formats[i];
            if (format == lastFormat || !(format instanceof SimpleDateFormat)) continue;
            ((SimpleDateFormat)format).applyPattern(pattern);
            lastFormat = format;
        }
    }

    public void setTimeZone(TimeZone timezone) {
        Format lastFormat = null;
        for (int i = 0; i < this.formats.length; ++i) {
            Format format = this.formats[i];
            if (format == lastFormat || !(format instanceof DateFormat)) continue;
            ((DateFormat)format).setTimeZone(timezone);
            lastFormat = format;
        }
    }

    public Format getFormat(int dimension) throws IndexOutOfBoundsException {
        return this.formats[dimension];
    }

    public String format(DirectPosition point) {
        return this.format(point, new StringBuffer(), (FieldPosition)null).toString();
    }

    public StringBuffer format(DirectPosition point, StringBuffer toAppendTo, FieldPosition position) throws IllegalArgumentException {
        int dimension = point.getDimension();
        if (dimension != this.formats.length) {
            throw new MismatchedDimensionException(Resources.format(99, "point", new Integer(dimension), new Integer(this.formats.length)));
        }
        for (int i = 0; i < this.formats.length; ++i) {
            Comparable<Double> object;
            double value = point.getOrdinate(i);
            switch (this.types[i]) {
                default: {
                    object = new Double(value);
                    break;
                }
                case 1: {
                    object = new Longitude(value);
                    break;
                }
                case 2: {
                    object = new Latitude(value);
                    break;
                }
                case 3: {
                    object = new Angle(value);
                    break;
                }
                case 4: {
                    CoordinateSystemAxis axis = this.crs.getCoordinateSystem().getAxis(i);
                    long offset = Math.round(this.toMillis[i].convert(value));
                    if (AxisDirection.PAST.equals(axis.getDirection())) {
                        offset = -offset;
                    }
                    object = new Date(this.epochs[i] + offset);
                    break;
                }
            }
            if (i != 0) {
                toAppendTo.append(' ');
            }
            this.formats[i].format(object, toAppendTo, this.dummy);
        }
        return toAppendTo;
    }

    public StringBuffer format(Object object, StringBuffer toAppendTo, FieldPosition position) throws IllegalArgumentException {
        if (object instanceof DirectPosition) {
            return this.format((DirectPosition)object, toAppendTo, position);
        }
        throw new IllegalArgumentException(String.valueOf(object));
    }

    public Object parseObject(String source, ParsePosition position) {
        throw new UnsupportedOperationException("DirectPosition parsing not yet implemented.");
    }
}

