/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.ResponsiblePartyImpl;
import org.geotools.resources.Utilities;
import org.geotools.util.SimpleInternationalString;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.OnLineFunction;
import org.opengis.metadata.citation.PresentationForm;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.citation.Role;
import org.opengis.metadata.citation.Series;
import org.opengis.util.InternationalString;

public class CitationImpl
extends MetadataEntity
implements Citation {
    private static final long serialVersionUID = -4415559967618358778L;
    public static final Citation AUTO;
    public static final Citation AUTO2;
    public static final Citation OGC;
    public static final Citation OPEN_GIS;
    public static final Citation EPSG;
    public static final Citation GEOTIFF;
    public static final Citation ESRI;
    public static final Citation ORACLE;
    public static final Citation GEOTOOLS;
    private static final Citation[] AUTHORITIES;
    private InternationalString title;
    private Collection alternateTitles;
    private Collection dates;
    private InternationalString edition;
    private long editionDate = Long.MIN_VALUE;
    private Collection identifiers;
    private Collection identifierTypes;
    private Collection citedResponsibleParties;
    private Collection presentationForm;
    private Series series;
    private InternationalString otherCitationDetails;
    private InternationalString collectiveTitle;
    private String ISBN;
    private String ISSN;

    private static ResponsibleParty OGC(Role role, OnLineFunction function, String onlineResource) {
        try {
            return ResponsiblePartyImpl.OGC(role, function, new URI(onlineResource));
        }
        catch (URISyntaxException badContact) {
            Utilities.unexpectedException("org.geotools.metadata.iso", "Citation", "OGC", badContact);
            return ResponsiblePartyImpl.OGC;
        }
    }

    public CitationImpl() {
    }

    public CitationImpl(Citation source) {
        this.setTitle(source.getTitle());
        this.setAlternateTitles(source.getAlternateTitles());
        this.setDates(source.getDates());
        this.setEdition(source.getEdition());
        this.setEditionDate(source.getEditionDate());
        this.setIdentifiers(source.getIdentifiers());
        this.setIdentifierTypes(source.getIdentifierTypes());
        this.setCitedResponsibleParties(source.getCitedResponsibleParties());
        this.setPresentationForm(source.getPresentationForm());
        this.setSeries(source.getSeries());
        this.setOtherCitationDetails(source.getOtherCitationDetails());
        this.setCollectiveTitle(source.getCollectiveTitle());
        this.setISBN(source.getISBN());
        this.setISSN(source.getISSN());
    }

    public CitationImpl(CharSequence title) {
        Object t = title instanceof InternationalString ? (InternationalString)title : new SimpleInternationalString(((Object)title).toString());
        this.setTitle((InternationalString)t);
    }

    public static Citation createCitation(String name) {
        for (int i = 0; i < AUTHORITIES.length; ++i) {
            Citation citation = AUTHORITIES[i];
            if (!CitationImpl.titleMatches(citation, name)) continue;
            return citation;
        }
        return new CitationImpl(name);
    }

    public static boolean titleMatches(Citation citation, String title) {
        title = title.trim();
        InternationalString candidate = citation.getTitle();
        Iterator iterator = null;
        while (true) {
            if (candidate.toString(Locale.US).trim().equalsIgnoreCase(title)) {
                return true;
            }
            if (candidate.toString().trim().equalsIgnoreCase(title)) {
                return true;
            }
            if (iterator == null) {
                Collection titles = citation.getAlternateTitles();
                if (titles == null) break;
                iterator = titles.iterator();
            }
            if (!iterator.hasNext()) break;
            candidate = (InternationalString)iterator.next();
        }
        return false;
    }

    public InternationalString getTitle() {
        return this.title;
    }

    public synchronized void setTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.title = newValue;
    }

    public synchronized Collection getAlternateTitles() {
        this.alternateTitles = this.nonNullCollection(this.alternateTitles, InternationalString.class);
        return this.alternateTitles;
    }

    public synchronized void setAlternateTitles(Collection newValues) {
        this.alternateTitles = this.copyCollection(newValues, this.alternateTitles, InternationalString.class);
    }

    public synchronized Collection getDates() {
        this.dates = this.nonNullCollection(this.dates, CitationDate.class);
        return this.dates;
    }

    public synchronized void setDates(Collection newValues) {
        this.dates = this.copyCollection(newValues, this.dates, CitationDate.class);
    }

    public InternationalString getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(InternationalString newValue) {
        this.checkWritePermission();
        this.edition = newValue;
    }

    public synchronized Date getEditionDate() {
        return this.editionDate != Long.MIN_VALUE ? new Date(this.editionDate) : null;
    }

    public synchronized void setEditionDate(Date newValue) {
        this.checkWritePermission();
        this.editionDate = newValue != null ? newValue.getTime() : Long.MIN_VALUE;
    }

    public synchronized Collection getIdentifiers() {
        this.identifiers = this.nonNullCollection(this.identifiers, String.class);
        return this.identifiers;
    }

    public synchronized void setIdentifiers(Collection newValues) {
        this.identifiers = this.copyCollection(newValues, this.identifiers, String.class);
    }

    public synchronized Collection getIdentifierTypes() {
        this.identifierTypes = this.nonNullCollection(this.identifierTypes, String.class);
        return this.identifierTypes;
    }

    public synchronized void setIdentifierTypes(Collection newValues) {
        this.identifierTypes = this.copyCollection(newValues, this.identifierTypes, String.class);
    }

    public synchronized Collection getCitedResponsibleParties() {
        this.citedResponsibleParties = this.nonNullCollection(this.citedResponsibleParties, ResponsibleParty.class);
        return this.citedResponsibleParties;
    }

    public synchronized void setCitedResponsibleParties(Collection newValues) {
        this.citedResponsibleParties = this.copyCollection(newValues, this.citedResponsibleParties, ResponsibleParty.class);
    }

    public synchronized Collection getPresentationForm() {
        this.presentationForm = this.nonNullCollection(this.presentationForm, PresentationForm.class);
        return this.presentationForm;
    }

    public synchronized void setPresentationForm(Collection newValues) {
        this.presentationForm = this.copyCollection(newValues, this.presentationForm, PresentationForm.class);
    }

    public Series getSeries() {
        return this.series;
    }

    public synchronized void setSeries(Series newValue) {
        this.checkWritePermission();
        this.series = newValue;
    }

    public InternationalString getOtherCitationDetails() {
        return this.otherCitationDetails;
    }

    public synchronized void setOtherCitationDetails(InternationalString newValue) {
        this.checkWritePermission();
        this.otherCitationDetails = newValue;
    }

    public InternationalString getCollectiveTitle() {
        return this.collectiveTitle;
    }

    public synchronized void setCollectiveTitle(InternationalString newValue) {
        this.checkWritePermission();
        this.collectiveTitle = newValue;
    }

    public String getISBN() {
        return this.ISBN;
    }

    public synchronized void setISBN(String newValue) {
        this.checkWritePermission();
        this.ISBN = newValue;
    }

    public String getISSN() {
        return this.ISSN;
    }

    public synchronized void setISSN(String newValue) {
        this.checkWritePermission();
        this.ISSN = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.title = (InternationalString)CitationImpl.unmodifiable(this.title);
        this.alternateTitles = (Collection)CitationImpl.unmodifiable(this.alternateTitles);
        this.dates = (Collection)CitationImpl.unmodifiable(this.dates);
        this.edition = (InternationalString)CitationImpl.unmodifiable(this.edition);
        this.identifiers = (Collection)CitationImpl.unmodifiable(this.identifiers);
        this.identifierTypes = (Collection)CitationImpl.unmodifiable(this.identifierTypes);
        this.citedResponsibleParties = (Collection)CitationImpl.unmodifiable(this.citedResponsibleParties);
        this.presentationForm = (Collection)CitationImpl.unmodifiable(this.presentationForm);
        this.otherCitationDetails = (InternationalString)CitationImpl.unmodifiable(this.otherCitationDetails);
        this.collectiveTitle = (InternationalString)CitationImpl.unmodifiable(this.collectiveTitle);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            CitationImpl that = (CitationImpl)object;
            return Utilities.equals(this.title, that.title) && Utilities.equals(this.alternateTitles, that.alternateTitles) && Utilities.equals(this.dates, that.dates) && Utilities.equals(this.edition, that.edition) && this.editionDate == that.editionDate && Utilities.equals(this.identifiers, that.identifiers) && Utilities.equals(this.identifierTypes, that.identifierTypes) && Utilities.equals(this.citedResponsibleParties, that.citedResponsibleParties) && Utilities.equals(this.presentationForm, that.presentationForm) && Utilities.equals(this.otherCitationDetails, that.otherCitationDetails) && Utilities.equals(this.collectiveTitle, that.collectiveTitle) && Utilities.equals(this.ISBN, that.ISBN) && Utilities.equals(this.ISSN, that.ISSN);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1515445754;
        if (this.title != null) {
            code ^= this.title.hashCode();
        }
        if (this.identifiers != null) {
            code ^= ((Object)this.identifiers).hashCode();
        }
        if (this.ISBN != null) {
            code ^= this.ISBN.hashCode();
        }
        if (this.ISSN != null) {
            code ^= this.ISSN.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.title);
    }

    static {
        CitationImpl c = new CitationImpl("Automatic Projections");
        c.setPresentationForm(Collections.singleton(PresentationForm.MODEL_DIGITAL));
        ArrayList<SimpleInternationalString> titles = new ArrayList<SimpleInternationalString>(3);
        titles.add(new SimpleInternationalString("AUTO"));
        titles.add(new SimpleInternationalString("WMS 1.1.1"));
        titles.add(new SimpleInternationalString("OGC 01-068r2"));
        c.setAlternateTitles(titles);
        HashSet<ResponsibleParty> parties = new HashSet<ResponsibleParty>(4);
        parties.add(CitationImpl.OGC(Role.POINT_OF_CONTACT, OnLineFunction.INFORMATION, "http://www.opengeospatial.org/"));
        parties.add(CitationImpl.OGC(Role.OWNER, OnLineFunction.INFORMATION, "http://www.opengis.org/docs/01-068r3.pdf"));
        c.setCitedResponsibleParties(parties);
        c.setIdentifiers(Collections.singleton("AUTO"));
        c.freeze();
        AUTO = c;
        c = new CitationImpl("Automatic Projections");
        c.setPresentationForm(Collections.singleton(PresentationForm.MODEL_DIGITAL));
        titles = new ArrayList(3);
        titles.add(new SimpleInternationalString("AUTO2"));
        titles.add(new SimpleInternationalString("WMS 1.3.0"));
        titles.add(new SimpleInternationalString("OGC 04-024"));
        c.setAlternateTitles(titles);
        parties = new HashSet(4);
        parties.add(CitationImpl.OGC(Role.POINT_OF_CONTACT, OnLineFunction.INFORMATION, "http://www.opengeospatial.org/"));
        parties.add(CitationImpl.OGC(Role.OWNER, OnLineFunction.INFORMATION, "http://portal.opengis.org/files/?artifact_id=5316"));
        c.setCitedResponsibleParties(parties);
        c.setIdentifiers(Collections.singleton("AUTO2"));
        c.freeze();
        AUTO2 = c;
        c = new CitationImpl((CharSequence)ResponsiblePartyImpl.OGC_NAME);
        c.setPresentationForm(Collections.singleton(PresentationForm.DOCUMENT_DIGITAL));
        c.setAlternateTitles(Collections.singletonList(new SimpleInternationalString("OGC")));
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.OGC));
        c.freeze();
        OGC = c;
        c = new CitationImpl("OpenGIS consortium");
        c.setPresentationForm(Collections.singleton(PresentationForm.DOCUMENT_DIGITAL));
        c.setAlternateTitles(Collections.singletonList(new SimpleInternationalString("OpenGIS")));
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.OPEN_GIS));
        c.freeze();
        OPEN_GIS = c;
        c = new CitationImpl("European Petroleum Survey Group");
        c.setPresentationForm(Collections.singleton(PresentationForm.TABLE_DIGITAL));
        c.setAlternateTitles(Collections.singletonList(new SimpleInternationalString("EPSG")));
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.EPSG));
        c.setIdentifiers(Collections.singleton("EPSG"));
        c.freeze();
        EPSG = c;
        c = new CitationImpl("GeoTIFF");
        c.setPresentationForm(Collections.singleton(PresentationForm.DOCUMENT_DIGITAL));
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.GEOTIFF));
        c.freeze();
        GEOTIFF = c;
        c = new CitationImpl("ESRI");
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.ESRI));
        c.freeze();
        ESRI = c;
        c = new CitationImpl("Oracle");
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.ORACLE));
        c.freeze();
        ORACLE = c;
        c = new CitationImpl("Geotools");
        c.setCitedResponsibleParties(Collections.singleton(ResponsiblePartyImpl.GEOTOOLS));
        c.freeze();
        GEOTOOLS = c;
        AUTHORITIES = new Citation[]{OPEN_GIS, EPSG, GEOTIFF, ESRI, ORACLE, GEOTOOLS, AUTO, AUTO2};
    }
}

