/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.citation;

import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.metadata.iso.citation.OnLineResourceImpl;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Address;
import org.opengis.metadata.citation.Contact;
import org.opengis.metadata.citation.OnLineResource;
import org.opengis.metadata.citation.Telephone;
import org.opengis.util.InternationalString;

public class ContactImpl
extends MetadataEntity
implements Contact {
    private static final long serialVersionUID = 3283637180253117382L;
    public static final Contact OGC;
    public static final Contact OPEN_GIS;
    public static final Contact EPSG;
    public static final Contact GEOTIFF;
    public static final Contact ESRI;
    public static final Contact ORACLE;
    public static final Contact GEOTOOLS;
    private InternationalString contactInstructions;
    private InternationalString hoursOfService;
    private OnLineResource onLineResource;
    private Address address;
    private Telephone phone;

    public Address getAddress() {
        return this.address;
    }

    public synchronized void setAddress(Address newValue) {
        this.checkWritePermission();
        this.address = newValue;
    }

    public InternationalString getContactInstructions() {
        return this.contactInstructions;
    }

    public synchronized void setContactInstructions(InternationalString newValue) {
        this.checkWritePermission();
        this.contactInstructions = newValue;
    }

    public OnLineResource getOnLineResource() {
        return this.onLineResource;
    }

    public synchronized void setOnLineResource(OnLineResource newValue) {
        this.checkWritePermission();
        this.onLineResource = newValue;
    }

    public Telephone getPhone() {
        return this.phone;
    }

    public synchronized void setPhone(Telephone newValue) {
        this.checkWritePermission();
        this.phone = newValue;
    }

    public InternationalString getHoursOfService() {
        return this.hoursOfService;
    }

    public synchronized void setHoursOfService(InternationalString newValue) {
        this.checkWritePermission();
        this.hoursOfService = newValue;
    }

    protected void freeze() {
        super.freeze();
        this.contactInstructions = (InternationalString)ContactImpl.unmodifiable(this.contactInstructions);
        this.hoursOfService = (InternationalString)ContactImpl.unmodifiable(this.hoursOfService);
        this.onLineResource = (OnLineResource)ContactImpl.unmodifiable(this.onLineResource);
        this.address = (Address)ContactImpl.unmodifiable(this.address);
        this.phone = (Telephone)ContactImpl.unmodifiable(this.phone);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            ContactImpl that = (ContactImpl)object;
            return Utilities.equals(this.contactInstructions, that.contactInstructions) && Utilities.equals(this.hoursOfService, that.hoursOfService) && Utilities.equals(this.onLineResource, that.onLineResource) && Utilities.equals(this.address, that.address) && Utilities.equals(this.phone, that.phone);
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 876649414;
        if (this.contactInstructions != null) {
            code ^= this.contactInstructions.hashCode();
        }
        if (this.address != null) {
            code ^= this.address.hashCode();
        }
        return code;
    }

    public synchronized String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.contactInstructions != null) {
            buffer.append((CharSequence)this.contactInstructions);
        }
        if (this.address != null) {
            ContactImpl.appendLineSeparator(buffer);
            buffer.append(this.address);
        }
        if (this.phone != null) {
            ContactImpl.appendLineSeparator(buffer);
            buffer.append(this.phone);
        }
        if (this.onLineResource != null) {
            ContactImpl.appendLineSeparator(buffer);
            buffer.append(this.onLineResource);
        }
        return buffer.toString();
    }

    static {
        ContactImpl c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.OGC);
        c.freeze();
        OGC = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.OPEN_GIS);
        c.freeze();
        OPEN_GIS = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.EPSG);
        c.freeze();
        EPSG = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.GEOTIFF);
        c.freeze();
        GEOTIFF = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.ESRI);
        c.freeze();
        ESRI = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.ORACLE);
        c.freeze();
        ORACLE = c;
        c = new ContactImpl();
        c.setOnLineResource(OnLineResourceImpl.GEOTOOLS);
        c.freeze();
        GEOTOOLS = c;
    }
}

