/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.lineage;

import java.util.Collection;
import org.geotools.metadata.iso.MetadataEntity;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.extent.Extent;
import org.opengis.metadata.lineage.ProcessStep;
import org.opengis.metadata.lineage.Source;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

public class SourceImpl
extends MetadataEntity
implements Source {
    private static final long serialVersionUID = 1754233428736991423L;
    private InternationalString description;
    private long scaleDenominator;
    private ReferenceSystem sourceReferenceSystem;
    private Citation sourceCitation;
    private Collection sourceExtents;
    private Collection sourceSteps;

    public SourceImpl() {
    }

    public SourceImpl(InternationalString description) {
        this.setDescription(description);
    }

    public InternationalString getDescription() {
        return this.description;
    }

    public synchronized void setDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.description = newValue;
    }

    public synchronized long getScaleDenominator() {
        return this.scaleDenominator;
    }

    public synchronized void setScaleDenominator(long newValue) {
        this.checkWritePermission();
        this.scaleDenominator = newValue;
    }

    public ReferenceSystem getSourceReferenceSystem() {
        return this.sourceReferenceSystem;
    }

    public synchronized void setSourceReferenceSystem(ReferenceSystem newValue) {
        this.checkWritePermission();
        this.sourceReferenceSystem = newValue;
    }

    public Citation getSourceCitation() {
        return this.sourceCitation;
    }

    public synchronized void setSourceCitation(Citation newValue) {
        this.checkWritePermission();
        this.sourceCitation = newValue;
    }

    public synchronized Collection getSourceExtents() {
        this.sourceExtents = this.nonNullCollection(this.sourceExtents, Extent.class);
        return this.sourceExtents;
    }

    public synchronized void setSourceExtents(Collection newValues) {
        this.sourceExtents = this.copyCollection(newValues, this.sourceExtents, Extent.class);
    }

    public synchronized Collection getSourceSteps() {
        this.sourceSteps = this.nonNullCollection(this.sourceSteps, ProcessStep.class);
        return this.sourceSteps;
    }

    public synchronized void setSourceSteps(Collection newValues) {
        this.sourceSteps = this.copyCollection(newValues, this.sourceSteps, ProcessStep.class);
    }

    protected void freeze() {
        super.freeze();
        this.description = (InternationalString)SourceImpl.unmodifiable(this.description);
        this.sourceReferenceSystem = (ReferenceSystem)SourceImpl.unmodifiable(this.sourceReferenceSystem);
        this.sourceCitation = (Citation)SourceImpl.unmodifiable(this.sourceCitation);
        this.sourceExtents = (Collection)SourceImpl.unmodifiable(this.sourceExtents);
        this.sourceSteps = (Collection)SourceImpl.unmodifiable(this.sourceSteps);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            SourceImpl that = (SourceImpl)object;
            return Utilities.equals(this.description, that.description) && Utilities.equals(this.sourceReferenceSystem, that.sourceReferenceSystem) && Utilities.equals(this.sourceCitation, that.sourceCitation) && Utilities.equals(this.sourceExtents, that.sourceExtents) && Utilities.equals(this.sourceSteps, that.sourceSteps) && this.scaleDenominator == that.scaleDenominator;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = 1425793215;
        if (this.description != null) {
            code ^= this.description.hashCode();
        }
        if (this.sourceReferenceSystem != null) {
            code ^= this.sourceReferenceSystem.hashCode();
        }
        if (this.sourceCitation != null) {
            code ^= this.sourceCitation.hashCode();
        }
        if (this.sourceExtents != null) {
            code ^= ((Object)this.sourceExtents).hashCode();
        }
        if (this.sourceSteps != null) {
            code ^= ((Object)this.sourceSteps).hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.description);
    }
}

