/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.metadata.iso.spatial;

import java.util.Collection;
import java.util.List;
import org.geotools.metadata.iso.spatial.GridSpatialRepresentationImpl;
import org.geotools.resources.Utilities;
import org.geotools.util.CheckedArrayList;
import org.opengis.metadata.spatial.CellGeometry;
import org.opengis.metadata.spatial.Georectified;
import org.opengis.metadata.spatial.PixelOrientation;
import org.opengis.spatialschema.geometry.primitive.Point;
import org.opengis.util.InternationalString;

public class GeorectifiedImpl
extends GridSpatialRepresentationImpl
implements Georectified {
    private static final long serialVersionUID = 5875851898471237138L;
    private boolean checkPointAvailable;
    private InternationalString checkPointDescription;
    private List cornerPoints;
    private Point centerPoint;
    private PixelOrientation pointInPixel;
    private InternationalString transformationDimensionDescription;
    private Collection transformationDimensionMapping;

    public GeorectifiedImpl() {
    }

    public GeorectifiedImpl(int numberOfDimensions, List axisDimensionsProperties, CellGeometry cellGeometry, boolean transformationParameterAvailable, boolean checkPointAvailable, List cornerPoints, PixelOrientation pointInPixel) {
        super(numberOfDimensions, axisDimensionsProperties, cellGeometry, transformationParameterAvailable);
        this.setCheckPointAvailable(checkPointAvailable);
        this.setCornerPoints(cornerPoints);
        this.setPointInPixel(pointInPixel);
    }

    public boolean isCheckPointAvailable() {
        return this.checkPointAvailable;
    }

    public synchronized void setCheckPointAvailable(boolean newValue) {
        this.checkWritePermission();
        this.checkPointAvailable = newValue;
    }

    public InternationalString getCheckPointDescription() {
        return this.checkPointDescription;
    }

    public synchronized void setCheckPointDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.checkPointDescription = newValue;
    }

    public synchronized List getCornerPoints() {
        if (this.cornerPoints == null) {
            this.cornerPoints = new CheckedArrayList(Point.class);
        }
        return this.cornerPoints;
    }

    public synchronized void setCornerPoints(List newValues) {
        this.checkWritePermission();
        if (this.cornerPoints == null) {
            this.cornerPoints = new CheckedArrayList(Point.class);
        } else {
            this.cornerPoints.clear();
        }
        this.cornerPoints.addAll(newValues);
    }

    public Point getCenterPoint() {
        return this.centerPoint;
    }

    public synchronized void setCenterPoint(Point newValue) {
        this.checkWritePermission();
        this.centerPoint = newValue;
    }

    public PixelOrientation getPointInPixel() {
        return this.pointInPixel;
    }

    public synchronized void setPointInPixel(PixelOrientation newValue) {
        this.checkWritePermission();
        this.pointInPixel = newValue;
    }

    public InternationalString getTransformationDimensionDescription() {
        return this.transformationDimensionDescription;
    }

    public synchronized void setTransformationDimensionDescription(InternationalString newValue) {
        this.checkWritePermission();
        this.transformationDimensionDescription = newValue;
    }

    public synchronized Collection getTransformationDimensionMapping() {
        this.transformationDimensionMapping = this.nonNullCollection(this.transformationDimensionMapping, InternationalString.class);
        return this.transformationDimensionMapping;
    }

    public synchronized void setTransformationDimensionMapping(Collection newValues) {
        this.transformationDimensionMapping = this.copyCollection(newValues, this.transformationDimensionMapping, InternationalString.class);
    }

    protected void freeze() {
        super.freeze();
        this.checkPointDescription = (InternationalString)GeorectifiedImpl.unmodifiable(this.checkPointDescription);
        this.cornerPoints = (List)GeorectifiedImpl.unmodifiable(this.cornerPoints);
        this.centerPoint = (Point)GeorectifiedImpl.unmodifiable(this.centerPoint);
        this.transformationDimensionDescription = (InternationalString)GeorectifiedImpl.unmodifiable(this.transformationDimensionDescription);
        this.transformationDimensionMapping = (Collection)GeorectifiedImpl.unmodifiable(this.transformationDimensionMapping);
    }

    public synchronized boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass().equals(this.getClass())) {
            GeorectifiedImpl that = (GeorectifiedImpl)object;
            return Utilities.equals(this.checkPointDescription, that.checkPointDescription) && Utilities.equals(this.cornerPoints, that.cornerPoints) && Utilities.equals(this.centerPoint, that.centerPoint) && Utilities.equals(this.pointInPixel, that.pointInPixel) && Utilities.equals(this.transformationDimensionDescription, that.transformationDimensionDescription) && Utilities.equals(this.transformationDimensionMapping, that.transformationDimensionMapping) && this.checkPointAvailable == that.checkPointAvailable;
        }
        return false;
    }

    public synchronized int hashCode() {
        int code = -1993423342;
        if (this.checkPointDescription != null) {
            code ^= this.checkPointDescription.hashCode();
        }
        if (this.transformationDimensionDescription != null) {
            code ^= this.transformationDimensionDescription.hashCode();
        }
        return code;
    }

    public String toString() {
        return String.valueOf(this.checkPointDescription);
    }
}

