/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import javax.imageio.spi.ServiceRegistry;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.io.TableWriter;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.resources.Arguments;
import org.geotools.resources.LazySet;
import org.geotools.resources.Utilities;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.Factory;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CRSFactory;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CSFactory;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.datum.DatumFactory;
import org.opengis.referencing.operation.CoordinateOperationFactory;
import org.opengis.referencing.operation.MathTransformFactory;

public final class FactoryFinder {
    private static FactoryRegistry registry;
    static final /* synthetic */ boolean $assertionsDisabled;

    private FactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        if (!$assertionsDisabled && !Thread.holdsLock(FactoryFinder.class)) {
            throw new AssertionError();
        }
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(DatumFactory.class, CSFactory.class, CRSFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CRSAuthorityFactory.class, MathTransformFactory.class, CoordinateOperationFactory.class));
        }
        return registry;
    }

    public static synchronized void addAuthorityFactory(AuthorityFactory authority) {
        FactoryFinder.getServiceRegistry().registerServiceProvider(authority);
    }

    public static synchronized void removeAuthorityFactory(AuthorityFactory authority) {
        FactoryFinder.getServiceRegistry().deregisterServiceProvider(authority);
    }

    public static synchronized DatumFactory getDatumFactory(Hints hints) throws FactoryRegistryException {
        return (DatumFactory)FactoryFinder.getServiceRegistry().getServiceProvider(DatumFactory.class, null, hints, Hints.DATUM_FACTORY);
    }

    public static synchronized Set getDatumFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(DatumFactory.class));
    }

    public static synchronized CSFactory getCSFactory(Hints hints) throws FactoryRegistryException {
        return (CSFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CSFactory.class, null, hints, Hints.CS_FACTORY);
    }

    public static synchronized Set getCSFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CSFactory.class));
    }

    public static synchronized CRSFactory getCRSFactory(Hints hints) throws FactoryRegistryException {
        return (CRSFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CRSFactory.class, null, hints, Hints.CRS_FACTORY);
    }

    public static synchronized Set getCRSFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CRSFactory.class));
    }

    public static synchronized DatumAuthorityFactory getDatumAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (DatumAuthorityFactory)FactoryFinder.getServiceRegistry().getServiceProvider(DatumAuthorityFactory.class, new AuthorityFilter(authority), hints, Hints.DATUM_AUTHORITY_FACTORY);
    }

    public static synchronized Set getDatumAuthorityFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(DatumAuthorityFactory.class));
    }

    public static synchronized CSAuthorityFactory getCSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (CSAuthorityFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CSAuthorityFactory.class, new AuthorityFilter(authority), hints, Hints.CS_AUTHORITY_FACTORY);
    }

    public static synchronized Set getCSAuthorityFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CSAuthorityFactory.class));
    }

    public static synchronized CRSAuthorityFactory getCRSAuthorityFactory(String authority, Hints hints) throws FactoryRegistryException {
        return (CRSAuthorityFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CRSAuthorityFactory.class, new AuthorityFilter(authority), hints, Hints.CRS_AUTHORITY_FACTORY);
    }

    public static synchronized Set getCRSAuthorityFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CRSAuthorityFactory.class));
    }

    public static synchronized MathTransformFactory getMathTransformFactory(Hints hints) throws FactoryRegistryException {
        return (MathTransformFactory)FactoryFinder.getServiceRegistry().getServiceProvider(MathTransformFactory.class, null, hints, Hints.MATH_TRANSFORM_FACTORY);
    }

    public static synchronized Set getMathTransformFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(MathTransformFactory.class));
    }

    public static synchronized CoordinateOperationFactory getCoordinateOperationFactory(Hints hints) throws FactoryRegistryException {
        return (CoordinateOperationFactory)FactoryFinder.getServiceRegistry().getServiceProvider(CoordinateOperationFactory.class, null, hints, Hints.COORDINATE_OPERATION_FACTORY);
    }

    public static synchronized Set getCoordinateOperationFactories() {
        return new LazySet(FactoryFinder.getServiceRegistry().getServiceProviders(CoordinateOperationFactory.class));
    }

    public static boolean setVendorOrdering(String vendor1, String vendor2) {
        return FactoryFinder.getServiceRegistry().setOrdering(Factory.class, true, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static boolean unsetVendorOrdering(String vendor1, String vendor2) {
        return FactoryFinder.getServiceRegistry().setOrdering(Factory.class, false, new VendorFilter(vendor1), new VendorFilter(vendor2));
    }

    public static boolean setAuthorityOrdering(String authority1, String authority2) {
        return FactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, true, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static boolean unsetAuthorityOrdering(String authority1, String authority2) {
        return FactoryFinder.getServiceRegistry().setOrdering(AuthorityFactory.class, false, new AuthorityFilter(authority1), new AuthorityFilter(authority2));
    }

    public static void scanForPlugins() {
        if (registry != null) {
            registry.scanForPlugins();
        }
    }

    public static synchronized void listProviders(Writer out, Locale locale) throws IOException {
        FactoryFinder.getServiceRegistry().getServiceProviders(DatumFactory.class);
        TableWriter table = new TableWriter(out, " \u2502 ");
        table.setMultiLinesCells(true);
        table.writeHorizontalSeparator();
        table.write("Factory");
        table.nextColumn();
        table.write("Implementation(s)");
        table.writeHorizontalSeparator();
        Iterator<Class<?>> categories = FactoryFinder.getServiceRegistry().getCategories();
        while (categories.hasNext()) {
            Class<?> category = categories.next();
            table.write(Utilities.getShortName(category));
            table.nextColumn();
            boolean first = true;
            Iterator providers = FactoryFinder.getServiceRegistry().getServiceProviders(category);
            while (providers.hasNext()) {
                if (!first) {
                    table.write(10);
                }
                first = false;
                Factory provider = (Factory)providers.next();
                Citation vendor = provider.getVendor();
                table.write(vendor.getTitle().toString(locale));
            }
            table.nextLine();
        }
        table.writeHorizontalSeparator();
        table.flush();
    }

    public static void main(String[] args) {
        Arguments arguments = new Arguments(args);
        args = arguments.getRemainingArguments(0);
        try {
            FactoryFinder.listProviders(arguments.out, arguments.locale);
        }
        catch (Exception exception) {
            exception.printStackTrace(arguments.err);
        }
    }

    static {
        $assertionsDisabled = !FactoryFinder.class.desiredAssertionStatus();
    }

    private static final class AuthorityFilter
    implements ServiceRegistry.Filter {
        private final String authority;

        public AuthorityFilter(String authority) {
            this.authority = authority;
        }

        public boolean filter(Object provider) {
            return CitationImpl.titleMatches(((AuthorityFactory)provider).getAuthority(), this.authority);
        }
    }

    private static final class VendorFilter
    implements ServiceRegistry.Filter {
        private final String vendor;

        public VendorFilter(String vendor) {
            this.vendor = vendor;
        }

        public boolean filter(Object provider) {
            return CitationImpl.titleMatches(((Factory)provider).getVendor(), this.vendor);
        }
    }
}

